/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;

public class UsesAllMethods<P>
extends JavaIsoVisitor<P> {
    private final List<MethodMatcher> methodMatchers;

    public UsesAllMethods(MethodMatcher ... methodMatchers) {
        this(Arrays.asList(methodMatchers));
    }

    @Override
    public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, P p) {
        ArrayList<MethodMatcher> unmatched = new ArrayList<MethodMatcher>(this.methodMatchers);
        for (JavaType.Method type : cu.getTypesInUse().getUsedMethods()) {
            if (!unmatched.removeIf(matcher -> matcher.matches(type)) || !unmatched.isEmpty()) continue;
            return (JavaSourceFile)cu.withMarkers(cu.getMarkers().searchResult());
        }
        return cu;
    }

    public UsesAllMethods(List<MethodMatcher> methodMatchers) {
        this.methodMatchers = methodMatchers;
    }
}

