/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.openrewrite.Incubating;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

@Incubating(since="7.4.0")
public class MaybeUsesImport<P>
extends JavaIsoVisitor<P> {
    private final List<String> fullyQualifiedTypeSegments;

    public MaybeUsesImport(String fullyQualifiedType) {
        Scanner scanner = new Scanner(fullyQualifiedType);
        scanner.useDelimiter("\\.");
        this.fullyQualifiedTypeSegments = new ArrayList<String>();
        while (scanner.hasNext()) {
            this.fullyQualifiedTypeSegments.add(scanner.next());
        }
    }

    @Override
    public J.Import visitImport(J.Import _import, P p) {
        J i = super.visitImport(_import, (Object)p);
        if (this.matchesType((J.Import)i)) {
            i = ((J.Import)i).withMarkers(((J.Import)i).getMarkers().searchResult());
        }
        return i;
    }

    private boolean matchesType(J.Import i) {
        J.FieldAccess prior = null;
        for (String segment : this.fullyQualifiedTypeSegments) {
            Expression expr = i.getQualid();
            while (expr != prior) {
                if (expr instanceof J.Identifier) {
                    prior = expr;
                    if (((J.Identifier)expr).getSimpleName().equals(segment)) continue;
                    return false;
                }
                J.FieldAccess fa = expr;
                if (fa.getTarget() == prior) {
                    String simpleName = fa.getSimpleName();
                    if (!("*".equals(segment) || simpleName.equals(segment) || "*".equals(simpleName))) {
                        return false;
                    }
                    prior = fa;
                    continue;
                }
                expr = fa.getTarget();
            }
        }
        Expression expr = i.getQualid();
        while (expr != prior) {
            if (!(expr instanceof J.FieldAccess)) {
                return false;
            }
            J.FieldAccess fa = expr;
            if (Character.isLowerCase(fa.getSimpleName().charAt(0))) {
                return fa == i.getQualid() && i.isStatic();
            }
            expr = fa.getTarget();
        }
        return true;
    }

    @Override
    public J.Annotation visitAnnotation(J.Annotation annotation, P p) {
        return annotation;
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        return classDecl;
    }
}

