/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;

public class JavadocPrinter<P>
extends JavadocVisitor<PrintOutputCapture<P>> {
    public JavadocPrinter() {
        super(new JavadocJavaPrinter());
    }

    @Override
    public Javadoc visitAttribute(Javadoc.Attribute attribute, PrintOutputCapture<P> p) {
        this.visitMarkers(attribute.getMarkers(), p);
        p.append(attribute.getName());
        if (attribute.getSpaceBeforeEqual() != null) {
            this.visit(attribute.getSpaceBeforeEqual(), p);
            if (attribute.getValue() != null) {
                p.append('=');
                this.visit(attribute.getValue(), p);
            }
        }
        return attribute;
    }

    @Override
    public Javadoc visitAuthor(Javadoc.Author author, PrintOutputCapture<P> p) {
        this.visitMarkers(author.getMarkers(), p);
        p.append("@author");
        this.visit(author.getName(), p);
        return author;
    }

    @Override
    public Javadoc visitDeprecated(Javadoc.Deprecated deprecated, PrintOutputCapture<P> p) {
        this.visitMarkers(deprecated.getMarkers(), p);
        p.append("@deprecated");
        this.visit(deprecated.getDescription(), p);
        return deprecated;
    }

    @Override
    public Javadoc visitDocComment(Javadoc.DocComment javadoc, PrintOutputCapture<P> p) {
        this.visitMarkers(javadoc.getMarkers(), p);
        p.append("/**");
        this.visit(javadoc.getBody(), p);
        p.append("*/");
        return javadoc;
    }

    @Override
    public Javadoc visitDocRoot(Javadoc.DocRoot docRoot, PrintOutputCapture<P> p) {
        this.visitMarkers(docRoot.getMarkers(), p);
        p.append("{@docRoot");
        this.visit(docRoot.getEndBrace(), p);
        return docRoot;
    }

    @Override
    public Javadoc visitDocType(Javadoc.DocType docType, PrintOutputCapture<P> p) {
        this.visitMarkers(docType.getMarkers(), p);
        p.append("<!doctype");
        this.visit(docType.getText(), p);
        p.append('>');
        return docType;
    }

    @Override
    public Javadoc visitEndElement(Javadoc.EndElement endElement, PrintOutputCapture<P> p) {
        this.visitMarkers(endElement.getMarkers(), p);
        p.append("</").append(endElement.getName());
        this.visit(endElement.getSpaceBeforeEndBracket(), p);
        p.append('>');
        return endElement;
    }

    @Override
    public Javadoc visitErroneous(Javadoc.Erroneous erroneous, PrintOutputCapture<P> p) {
        this.visitMarkers(erroneous.getMarkers(), p);
        this.visit(erroneous.getText(), p);
        return erroneous;
    }

    @Override
    public Javadoc visitHidden(Javadoc.Hidden hidden, PrintOutputCapture<P> p) {
        this.visitMarkers(hidden.getMarkers(), p);
        p.append("@hidden");
        this.visit(hidden.getBody(), p);
        return hidden;
    }

    @Override
    public Javadoc visitIndex(Javadoc.Index index, PrintOutputCapture<P> p) {
        this.visitMarkers(index.getMarkers(), p);
        p.append("{@index");
        this.visit(index.getSearchTerm(), p);
        this.visit(index.getDescription(), p);
        this.visit(index.getEndBrace(), p);
        return index;
    }

    @Override
    public Javadoc visitInheritDoc(Javadoc.InheritDoc inheritDoc, PrintOutputCapture<P> p) {
        this.visitMarkers(inheritDoc.getMarkers(), p);
        p.append("{@inheritDoc");
        this.visit(inheritDoc.getEndBrace(), p);
        return inheritDoc;
    }

    @Override
    public Javadoc visitInlinedValue(Javadoc.InlinedValue value, PrintOutputCapture<P> p) {
        this.visitMarkers(value.getMarkers(), p);
        p.append("{@value");
        this.visit(value.getSpaceBeforeTree(), p);
        this.javaVisitor.visit(value.getTree(), p);
        this.visit(value.getEndBrace(), p);
        return value;
    }

    @Override
    public Javadoc visitLineBreak(Javadoc.LineBreak lineBreak, PrintOutputCapture<P> p) {
        this.visitMarkers(lineBreak.getMarkers(), p);
        p.append(lineBreak.getMargin());
        return lineBreak;
    }

    @Override
    public Javadoc visitLink(Javadoc.Link link, PrintOutputCapture<P> p) {
        this.visitMarkers(link.getMarkers(), p);
        p.append(link.isPlain() ? "{@linkplain" : "{@link");
        this.visit(link.getSpaceBeforeTree(), p);
        this.visit(link.getTreeReference(), p);
        this.visit(link.getLabel(), p);
        this.visit(link.getEndBrace(), p);
        return link;
    }

    @Override
    public Javadoc visitLiteral(Javadoc.Literal literal, PrintOutputCapture<P> p) {
        this.visitMarkers(literal.getMarkers(), p);
        p.append(literal.isCode() ? "{@code" : "{@literal");
        this.visit(literal.getDescription(), p);
        this.visit(literal.getEndBrace(), p);
        return literal;
    }

    @Override
    public Javadoc visitParameter(Javadoc.Parameter parameter, PrintOutputCapture<P> p) {
        this.visitMarkers(parameter.getMarkers(), p);
        p.append("@param");
        this.visit(parameter.getSpaceBeforeName(), p);
        this.visit(parameter.getNameReference(), p);
        this.visit(parameter.getDescription(), p);
        return parameter;
    }

    @Override
    public Javadoc visitProvides(Javadoc.Provides provides, PrintOutputCapture<P> p) {
        this.visitMarkers(provides.getMarkers(), p);
        p.append("@provides");
        this.visit(provides.getSpaceBeforeServiceType(), p);
        this.javaVisitor.visit(provides.getServiceType(), p);
        this.visit(provides.getDescription(), p);
        return provides;
    }

    @Override
    public Javadoc visitReturn(Javadoc.Return aReturn, PrintOutputCapture<P> p) {
        this.visitMarkers(aReturn.getMarkers(), p);
        p.append("@return");
        this.visit(aReturn.getDescription(), p);
        return aReturn;
    }

    @Override
    public Javadoc visitSee(Javadoc.See see, PrintOutputCapture<P> p) {
        this.visitMarkers(see.getMarkers(), p);
        p.append("@see");
        this.visit(see.getSpaceBeforeTree(), p);
        this.visit(see.getTreeReference(), p);
        this.visit(see.getReference(), p);
        return see;
    }

    @Override
    public Javadoc visitSerial(Javadoc.Serial serial, PrintOutputCapture<P> p) {
        this.visitMarkers(serial.getMarkers(), p);
        p.append("@serial");
        this.visit(serial.getDescription(), p);
        return serial;
    }

    @Override
    public Javadoc visitSerialData(Javadoc.SerialData serialData, PrintOutputCapture<P> p) {
        this.visitMarkers(serialData.getMarkers(), p);
        p.append("@serialData");
        this.visit(serialData.getDescription(), p);
        return serialData;
    }

    @Override
    public Javadoc visitSerialField(Javadoc.SerialField serialField, PrintOutputCapture<P> p) {
        this.visitMarkers(serialField.getMarkers(), p);
        p.append("@serialField");
        this.javaVisitor.visit(serialField.getName(), p);
        this.javaVisitor.visit(serialField.getType(), p);
        this.visit(serialField.getDescription(), p);
        return serialField;
    }

    @Override
    public Javadoc visitSince(Javadoc.Since since, PrintOutputCapture<P> p) {
        this.visitMarkers(since.getMarkers(), p);
        p.append("@since");
        this.visit(since.getDescription(), p);
        return since;
    }

    @Override
    public Javadoc visitStartElement(Javadoc.StartElement startElement, PrintOutputCapture<P> p) {
        this.visitMarkers(startElement.getMarkers(), p);
        p.append('<').append(startElement.getName());
        this.visit(startElement.getAttributes(), p);
        this.visit(startElement.getSpaceBeforeEndBracket(), p);
        if (startElement.isSelfClosing()) {
            p.append('/');
        }
        p.append('>');
        return startElement;
    }

    @Override
    public Javadoc visitSummary(Javadoc.Summary summary, PrintOutputCapture<P> p) {
        this.visitMarkers(summary.getMarkers(), p);
        p.append("{@summary");
        this.visit(summary.getSummary(), p);
        this.visit(summary.getBeforeBrace(), p);
        return summary;
    }

    @Override
    public Javadoc visitText(Javadoc.Text text, PrintOutputCapture<P> p) {
        this.visitMarkers(text.getMarkers(), p);
        p.append(text.getText());
        return text;
    }

    @Override
    public Javadoc visitThrows(Javadoc.Throws aThrows, PrintOutputCapture<P> p) {
        this.visitMarkers(aThrows.getMarkers(), p);
        p.append(aThrows.isThrowsKeyword() ? "@throws" : "@exception");
        this.visit(aThrows.getSpaceBeforeExceptionName(), p);
        this.javaVisitor.visit(aThrows.getExceptionName(), p);
        this.visit(aThrows.getDescription(), p);
        return aThrows;
    }

    @Override
    public Javadoc visitUnknownBlock(Javadoc.UnknownBlock unknownBlock, PrintOutputCapture<P> p) {
        this.visitMarkers(unknownBlock.getMarkers(), p);
        p.append("@").append(unknownBlock.getName());
        this.visit(unknownBlock.getContent(), p);
        return unknownBlock;
    }

    @Override
    public Javadoc visitUnknownInline(Javadoc.UnknownInline unknownInline, PrintOutputCapture<P> p) {
        this.visitMarkers(unknownInline.getMarkers(), p);
        p.append("{@").append(unknownInline.getName());
        this.visit(unknownInline.getContent(), p);
        this.visit(unknownInline.getEndBrace(), p);
        return unknownInline;
    }

    @Override
    public Javadoc visitUses(Javadoc.Uses uses, PrintOutputCapture<P> p) {
        this.visitMarkers(uses.getMarkers(), p);
        p.append("@uses");
        this.visit(uses.getBeforeServiceType(), p);
        this.javaVisitor.visit(uses.getServiceType(), p);
        this.visit(uses.getDescription(), p);
        return uses;
    }

    @Override
    public Javadoc visitVersion(Javadoc.Version since, PrintOutputCapture<P> p) {
        this.visitMarkers(since.getMarkers(), p);
        p.append("@version");
        this.visit(since.getBody(), p);
        return since;
    }

    public void visit(@Nullable List<? extends Javadoc> nodes, PrintOutputCapture<P> p) {
        if (nodes != null) {
            for (Javadoc javadoc : nodes) {
                this.visit(javadoc, p);
            }
        }
    }

    @Override
    public Javadoc visitReference(Javadoc.Reference reference, PrintOutputCapture<P> p) {
        this.getCursor().putMessageOnFirstEnclosing(Javadoc.DocComment.class, "JAVADOC_LINE_BREAKS", reference.getLineBreaks());
        this.getCursor().putMessageOnFirstEnclosing(Javadoc.DocComment.class, "JAVADOC_LINE_BREAK_INDEX", (Object)0);
        this.javaVisitor.visit(reference.getTree(), p, this.getCursor());
        return reference;
    }

    static class JavadocJavaPrinter<P>
    extends JavaVisitor<PrintOutputCapture<P>> {
        JavadocJavaPrinter() {
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
            this.visitMarkers(method.getMarkers(), p);
            this.visitSpace(method.getPrefix(), Space.Location.IDENTIFIER_PREFIX, p);
            this.visit(method.getSelect(), p);
            if (method.getSelect() != null) {
                p.append('#');
            }
            p.append(method.getSimpleName());
            this.visitContainer("(", method.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, ",", ")", p);
            return method;
        }

        @Override
        public J visitIdentifier(J.Identifier ident, PrintOutputCapture<P> p) {
            this.visitMarkers(ident.getMarkers(), p);
            this.visitSpace(ident.getPrefix(), Space.Location.IDENTIFIER_PREFIX, p);
            p.append(ident.getSimpleName());
            return ident;
        }

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess, PrintOutputCapture<P> p) {
            this.visitSpace(fieldAccess.getPrefix(), Space.Location.FIELD_ACCESS_PREFIX, p);
            this.visitMarkers(fieldAccess.getMarkers(), p);
            this.visit(fieldAccess.getTarget(), p);
            this.visitLeftPadded(".", fieldAccess.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p);
            return fieldAccess;
        }

        @Override
        public J visitMemberReference(J.MemberReference memberRef, PrintOutputCapture<P> p) {
            this.visitSpace(memberRef.getPrefix(), Space.Location.MEMBER_REFERENCE_PREFIX, p);
            this.visitMarkers(memberRef.getMarkers(), p);
            this.visit(memberRef.getContaining(), p);
            this.visitLeftPadded("#", memberRef.getPadding().getReference(), JLeftPadded.Location.MEMBER_REFERENCE_NAME, p);
            return memberRef;
        }

        @Override
        public J visitParameterizedType(J.ParameterizedType type, PrintOutputCapture<P> p) {
            this.visitSpace(type.getPrefix(), Space.Location.IDENTIFIER_PREFIX, p);
            this.visitMarkers(type.getMarkers(), p);
            this.visit(type.getClazz(), p);
            this.visitContainer("<", type.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            return type;
        }

        @Override
        public J visitTypeParameter(J.TypeParameter typeParam, PrintOutputCapture<P> p) {
            this.visitSpace(typeParam.getPrefix(), Space.Location.TYPE_PARAMETERS_PREFIX, p);
            this.visitMarkers(typeParam.getMarkers(), p);
            p.append("<");
            this.visit(typeParam.getName(), p);
            p.append(">");
            return typeParam;
        }

        @Override
        public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
            List lineBreaks = (List)this.getCursor().getNearestMessage("JAVADOC_LINE_BREAKS");
            Integer index = (Integer)this.getCursor().getNearestMessage("JAVADOC_LINE_BREAK_INDEX");
            if (lineBreaks != null && !lineBreaks.isEmpty() && index != null && space.getWhitespace().contains("\n")) {
                for (char c : space.getWhitespace().toCharArray()) {
                    if (c == '\n') {
                        this.visitLineBreak((Javadoc.LineBreak)lineBreaks.get(index), p);
                        Integer n = index;
                        index = index + 1;
                        continue;
                    }
                    p.append(c);
                }
                this.getCursor().putMessageOnFirstEnclosing(Javadoc.DocComment.class, "JAVADOC_LINE_BREAK_INDEX", (Object)index);
            } else {
                p.append(space.getWhitespace());
            }
            return space;
        }

        private void visitLineBreak(Javadoc.LineBreak lineBreak, PrintOutputCapture<P> p) {
            this.visitMarkers(lineBreak.getMarkers(), p);
            p.append(lineBreak.getMargin());
        }

        private void visitLeftPadded(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, JLeftPadded.Location location, PrintOutputCapture<P> p) {
            if (leftPadded != null) {
                this.visitSpace(leftPadded.getBefore(), location.getBeforeLocation(), p);
                if (prefix != null) {
                    p.append(prefix);
                }
                this.visit(leftPadded.getElement(), p);
            }
        }

        private void visitContainer(String before, @Nullable JContainer<? extends J> container, JContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
            if (container == null) {
                return;
            }
            this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
            p.append(before);
            this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
            p.append(after == null ? "" : after);
        }

        private void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, JRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
            for (int i = 0; i < nodes.size(); ++i) {
                JRightPadded<? extends J> node = nodes.get(i);
                this.visit(node.getElement(), p);
                this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
                if (i >= nodes.size() - 1) continue;
                p.append(suffixBetween);
            }
        }
    }
}

