/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.HiddenFieldVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.HiddenFieldStyle;
import org.openrewrite.java.tree.JavaSourceFile;

@Incubating(since="7.6.0")
public class HiddenField
extends Recipe {
    public String getDisplayName() {
        return "Hidden field";
    }

    public String getDescription() {
        return "Refactor local variables or parameters which shadow a field defined in the same class.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1117");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new HiddenFieldFromCompilationUnitStyle();
    }

    private static class HiddenFieldFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private HiddenFieldFromCompilationUnitStyle() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
            HiddenFieldStyle style = (HiddenFieldStyle)((SourceFile)cu).getStyle(HiddenFieldStyle.class);
            if (style == null) {
                style = Checkstyle.hiddenFieldStyle();
            }
            this.doAfterVisit(new HiddenFieldVisitor(style));
            return cu;
        }
    }
}

