/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.marker.JavaSearchResult;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;

public final class ResultOfMethodCallIgnored
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="java.io.File mkdir*()")
    private final String methodPattern;

    public String getDisplayName() {
        return "Result of method call ignored";
    }

    public String getDescription() {
        return "Find locations where the result of the method call is being ignored.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = new MethodMatcher(this.methodPattern);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J m = super.visitMethodInvocation(method, executionContext);
                if (methodMatcher.matches(method)) {
                    if (this.getCursor().dropParentUntil(J.class::isInstance).getValue() instanceof J.Block) {
                        m = ((J.MethodInvocation)m).withMarkers(((J.MethodInvocation)m).getMarkers().addIfAbsent((Marker)new JavaSearchResult(ResultOfMethodCallIgnored.this)));
                    }
                }
                return m;
            }
        };
    }

    public ResultOfMethodCallIgnored(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    @NonNull
    public String toString() {
        return "ResultOfMethodCallIgnored(methodPattern=" + this.getMethodPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultOfMethodCallIgnored)) {
            return false;
        }
        ResultOfMethodCallIgnored other = (ResultOfMethodCallIgnored)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ResultOfMethodCallIgnored;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

