/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import org.openrewrite.TreePrinter;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JavaType;

public class MethodInvocationToString {
    private static final JavaPrinter<Void> METHOD_PRINTER = new JavaPrinter<Void>(TreePrinter.identity()){

        @Override
        public J visitMethodInvocation(J.MethodInvocation method, Void unused) {
            StringBuilder acc = this.getPrinter();
            JavaType.Method type = method.getType();
            if (type == null) {
                acc.append("<unknown receiver type>.");
                acc.append(method.getSimpleName());
                acc.append("(?)");
            } else {
                acc.append(type.getDeclaringType().getFullyQualifiedName().replaceFirst("^java\\.lang\\.", ""));
                acc.append('.');
                this.visitContainer("<", method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", unused);
                acc.append(type.getName());
                acc.append('(');
                acc.append(String.join((CharSequence)",", type.getParamNames()));
                acc.append(')');
            }
            return method;
        }
    };

    public static String toString(J.MethodInvocation method) {
        return METHOD_PRINTER.print(method, null);
    }
}

