/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

public class RemoveTrailingWhitespaceVisitor<P>
extends JavaIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;

    @JsonCreator
    public RemoveTrailingWhitespaceVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public RemoveTrailingWhitespaceVisitor() {
        this(null);
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
        String eof = cu.getEof().getWhitespace();
        eof = eof.chars().filter(c -> c == 10 || c == 13).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        J c2 = super.visitCompilationUnit(cu, (Object)p);
        return ((J.CompilationUnit)c2).withEof(((J.CompilationUnit)c2).getEof().withWhitespace(eof));
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, P p) {
        Space s = space;
        int lastNewline = s.getWhitespace().lastIndexOf(10);
        if (lastNewline > 0 && loc != Space.Location.IMPORT_PREFIX) {
            StringBuilder ws = new StringBuilder();
            char[] charArray = s.getWhitespace().toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                char c = charArray[i];
                if (i >= lastNewline) {
                    ws.append(c);
                    continue;
                }
                if (c != '\r' && c != '\n') continue;
                ws.append(c);
            }
            s = s.withWhitespace(ws.toString());
        }
        return s;
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }
}

