/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class ExternalizableHasNoArgsConstructor
extends Recipe {
    public String getDisplayName() {
        return "`Externalizable` classes must have a no-arguments constructor";
    }

    public String getDescription() {
        return "`Externalizable` classes handle both serialization and deserialization and must have a no-args constructor for the deserialization process.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2060");
    }

    protected UsesType<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>("java.io.Externalizable");
    }

    protected ExternalizableHasNoArgsConstructorVisitor getVisitor() {
        return new ExternalizableHasNoArgsConstructorVisitor();
    }

    private static class ExternalizableHasNoArgsConstructorVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final JavaType externalizableType = JavaType.buildType("java.io.Externalizable");

        private ExternalizableHasNoArgsConstructorVisitor() {
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
            J cd = super.visitClassDeclaration(classDecl, executionContext);
            if (TypeUtils.isAssignableTo(externalizableType, ((J.ClassDeclaration)cd).getType())) {
                boolean hasNoArgsConstructor = false;
                boolean hasDefaultConstructor = true;
                int firstMethodDeclarationIndex = 0;
                List<Statement> statements = ((J.ClassDeclaration)cd).getBody().getStatements();
                for (int i = 0; i < statements.size(); ++i) {
                    Statement statement = statements.get(i);
                    if (!(statement instanceof J.MethodDeclaration)) continue;
                    J.MethodDeclaration md = (J.MethodDeclaration)statement;
                    if (md.isConstructor()) {
                        if (md.getParameters().isEmpty() || md.getParameters().size() == 1 && md.getParameters().get(0) instanceof J.Empty) {
                            hasNoArgsConstructor = true;
                        } else {
                            hasDefaultConstructor = false;
                        }
                    }
                    if (firstMethodDeclarationIndex != 0) continue;
                    firstMethodDeclarationIndex = i;
                }
                if (!hasNoArgsConstructor && !hasDefaultConstructor) {
                    cd = (J.ClassDeclaration)cd.withTemplate(JavaTemplate.builder(() -> ((ExternalizableHasNoArgsConstructorVisitor)this).getCursor(), "public " + ((J.ClassDeclaration)cd).getSimpleName() + "() {}").build(), ((J.ClassDeclaration)cd).getBody().getCoordinates().lastStatement(), new Object[0]);
                    statements.add(firstMethodDeclarationIndex, ((J.ClassDeclaration)cd).getBody().getStatements().remove(((J.ClassDeclaration)cd).getBody().getStatements().size() - 1));
                    cd = ((J.ClassDeclaration)cd).withBody(((J.ClassDeclaration)cd).getBody().withStatements(statements));
                }
            }
            return cd;
        }
    }
}

