/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;

public class JavadocPrinter<P>
extends JavadocVisitor<P> {
    private static final String PRINTER_ACC_KEY = "printed";
    private final TreePrinter<P> treePrinter;

    public JavadocPrinter(TreePrinter<P> treePrinter) {
        this.javaVisitor = new JavadocJavaPrinter();
        this.treePrinter = treePrinter;
    }

    @NonNull
    protected StringBuilder getPrinter() {
        StringBuilder acc = (StringBuilder)this.getCursor().getRoot().getNearestMessage(PRINTER_ACC_KEY);
        if (acc == null) {
            acc = new StringBuilder();
            this.getCursor().getRoot().putMessage(PRINTER_ACC_KEY, (Object)acc);
        }
        return acc;
    }

    public String print(Javadoc j, P p) {
        this.setCursor(new Cursor(null, (Object)"EPSILON"));
        this.visit((Tree)j, (Object)p);
        return this.getPrinter().toString();
    }

    @Nullable
    public Javadoc visit(@Nullable Tree tree, P p) {
        if (tree == null) {
            return (Javadoc)this.defaultValue(null, p);
        }
        StringBuilder printerAcc = this.getPrinter();
        this.treePrinter.doBefore(tree, printerAcc, p);
        tree = super.visit(tree, p);
        if (tree != null) {
            this.treePrinter.doAfter(tree, printerAcc, p);
        }
        return (Javadoc)tree;
    }

    @Override
    public Javadoc visitAttribute(Javadoc.Attribute attribute, P p) {
        this.visitMarkers(attribute.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append(attribute.getName());
        if (attribute.getSpaceBeforeEqual() != null) {
            this.visit(attribute.getSpaceBeforeEqual(), p);
            if (attribute.getValue() != null) {
                acc.append('=');
                this.visit(attribute.getValue(), p);
            }
        }
        return attribute;
    }

    @Override
    public Javadoc visitAuthor(Javadoc.Author author, P p) {
        this.visitMarkers(author.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@author");
        this.visit(author.getName(), p);
        return author;
    }

    @Override
    public Javadoc visitDeprecated(Javadoc.Deprecated deprecated, P p) {
        this.visitMarkers(deprecated.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@deprecated");
        this.visit(deprecated.getDescription(), p);
        return deprecated;
    }

    @Override
    public Javadoc visitDocComment(Javadoc.DocComment javadoc, P p) {
        this.visitMarkers(javadoc.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("/**");
        this.visit(javadoc.getBody(), p);
        acc.append("*/");
        return javadoc;
    }

    @Override
    public Javadoc visitDocRoot(Javadoc.DocRoot docRoot, P p) {
        this.visitMarkers(docRoot.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("{@docRoot");
        this.visit(docRoot.getEndBrace(), p);
        return docRoot;
    }

    @Override
    public Javadoc visitDocType(Javadoc.DocType docType, P p) {
        this.visitMarkers(docType.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("<!doctype");
        this.visit(docType.getText(), p);
        acc.append('>');
        return docType;
    }

    @Override
    public Javadoc visitEndElement(Javadoc.EndElement endElement, P p) {
        this.visitMarkers(endElement.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("</").append(endElement.getName());
        this.visit(endElement.getSpaceBeforeEndBracket(), p);
        acc.append('>');
        return endElement;
    }

    @Override
    public Javadoc visitErroneous(Javadoc.Erroneous erroneous, P p) {
        this.visitMarkers(erroneous.getMarkers(), p);
        this.visit(erroneous.getText(), p);
        return erroneous;
    }

    @Override
    public Javadoc visitHidden(Javadoc.Hidden hidden, P p) {
        this.visitMarkers(hidden.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@hidden");
        this.visit(hidden.getBody(), p);
        return hidden;
    }

    @Override
    public Javadoc visitIndex(Javadoc.Index index, P p) {
        this.visitMarkers(index.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("{@index");
        this.visit(index.getSearchTerm(), p);
        this.visit(index.getDescription(), p);
        this.visit(index.getEndBrace(), p);
        return index;
    }

    @Override
    public Javadoc visitInheritDoc(Javadoc.InheritDoc inheritDoc, P p) {
        this.visitMarkers(inheritDoc.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("{@inheritDoc");
        this.visit(inheritDoc.getEndBrace(), p);
        return inheritDoc;
    }

    @Override
    public Javadoc visitInlinedValue(Javadoc.InlinedValue value, P p) {
        this.visitMarkers(value.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("{@value");
        this.visit(value.getSpaceBeforeTree(), p);
        this.javaVisitor.visit(value.getTree(), p);
        this.visit(value.getEndBrace(), p);
        return value;
    }

    @Override
    public Javadoc visitLineBreak(Javadoc.LineBreak lineBreak, P p) {
        this.visitMarkers(lineBreak.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append('\n').append(lineBreak.getMargin());
        return lineBreak;
    }

    @Override
    public Javadoc visitLink(Javadoc.Link link, P p) {
        this.visitMarkers(link.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append(link.isPlain() ? "{@linkplain" : "{@link");
        this.visit(link.getSpaceBeforeTree(), p);
        this.javaVisitor.visit(link.getTree(), p);
        this.visit(link.getLabel(), p);
        this.visit(link.getEndBrace(), p);
        return link;
    }

    @Override
    public Javadoc visitLiteral(Javadoc.Literal literal, P p) {
        this.visitMarkers(literal.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append(literal.isCode() ? "{@code" : "{@literal");
        this.visit(literal.getDescription(), p);
        this.visit(literal.getEndBrace(), p);
        return literal;
    }

    @Override
    public Javadoc visitParameter(Javadoc.Parameter parameter, P p) {
        this.visitMarkers(parameter.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@param");
        this.visit(parameter.getSpaceBeforeName(), p);
        this.javaVisitor.visit(parameter.getName(), p);
        this.visit(parameter.getDescription(), p);
        return parameter;
    }

    @Override
    public Javadoc visitProvides(Javadoc.Provides provides, P p) {
        this.visitMarkers(provides.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@provides");
        this.visit(provides.getSpaceBeforeServiceType(), p);
        this.javaVisitor.visit(provides.getServiceType(), p);
        this.visit(provides.getDescription(), p);
        return provides;
    }

    @Override
    public Javadoc visitReturn(Javadoc.Return aReturn, P p) {
        this.visitMarkers(aReturn.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@return");
        this.visit(aReturn.getDescription(), p);
        return aReturn;
    }

    @Override
    public Javadoc visitSee(Javadoc.See see, P p) {
        this.visitMarkers(see.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@see");
        this.visit(see.getSpaceBeforeTree(), p);
        this.javaVisitor.visit(see.getTree(), p);
        this.visit(see.getReference(), p);
        return see;
    }

    @Override
    public Javadoc visitSerial(Javadoc.Serial serial, P p) {
        this.visitMarkers(serial.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@serial");
        this.visit(serial.getDescription(), p);
        return serial;
    }

    @Override
    public Javadoc visitSerialData(Javadoc.SerialData serialData, P p) {
        this.visitMarkers(serialData.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@serialData");
        this.visit(serialData.getDescription(), p);
        return serialData;
    }

    @Override
    public Javadoc visitSerialField(Javadoc.SerialField serialField, P p) {
        this.visitMarkers(serialField.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@serialField");
        this.javaVisitor.visit(serialField.getName(), p);
        this.javaVisitor.visit(serialField.getType(), p);
        this.visit(serialField.getDescription(), p);
        return serialField;
    }

    @Override
    public Javadoc visitSince(Javadoc.Since since, P p) {
        this.visitMarkers(since.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@since");
        this.visit(since.getDescription(), p);
        return since;
    }

    @Override
    public Javadoc visitStartElement(Javadoc.StartElement startElement, P p) {
        this.visitMarkers(startElement.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append('<').append(startElement.getName());
        this.visit(startElement.getAttributes(), p);
        this.visit(startElement.getSpaceBeforeEndBracket(), p);
        if (startElement.isSelfClosing()) {
            acc.append('/');
        }
        acc.append('>');
        return startElement;
    }

    @Override
    public Javadoc visitSummary(Javadoc.Summary summary, P p) {
        this.visitMarkers(summary.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("{@summary");
        this.visit(summary.getSummary(), p);
        this.visit(summary.getBeforeBrace(), p);
        return summary;
    }

    @Override
    public Javadoc visitText(Javadoc.Text text, P p) {
        this.visitMarkers(text.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append(text.getText());
        return text;
    }

    @Override
    public Javadoc visitThrows(Javadoc.Throws aThrows, P p) {
        this.visitMarkers(aThrows.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append(aThrows.isThrowsKeyword() ? "@throws" : "@exception");
        this.visit(aThrows.getSpaceBeforeExceptionName(), p);
        this.javaVisitor.visit(aThrows.getExceptionName(), p);
        this.visit(aThrows.getDescription(), p);
        return aThrows;
    }

    @Override
    public Javadoc visitUnknownBlock(Javadoc.UnknownBlock unknownBlock, P p) {
        this.visitMarkers(unknownBlock.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@").append(unknownBlock.getName());
        this.visit(unknownBlock.getContent(), p);
        return unknownBlock;
    }

    @Override
    public Javadoc visitUnknownInline(Javadoc.UnknownInline unknownInline, P p) {
        this.visitMarkers(unknownInline.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("{@").append(unknownInline.getName());
        this.visit(unknownInline.getContent(), p);
        this.visit(unknownInline.getEndBrace(), p);
        return unknownInline;
    }

    @Override
    public Javadoc visitUses(Javadoc.Uses uses, P p) {
        this.visitMarkers(uses.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@uses");
        this.visit(uses.getBeforeServiceType(), p);
        this.javaVisitor.visit(uses.getServiceType(), p);
        this.visit(uses.getDescription(), p);
        return uses;
    }

    @Override
    public Javadoc visitVersion(Javadoc.Version since, P p) {
        this.visitMarkers(since.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@version");
        this.visit(since.getBody(), p);
        return since;
    }

    protected void visit(@Nullable List<? extends Javadoc> nodes, P p) {
        if (nodes != null) {
            for (Javadoc javadoc : nodes) {
                this.visit((Tree)javadoc, (Object)p);
            }
        }
    }

    class JavadocJavaPrinter
    extends JavaVisitor<P> {
        JavadocJavaPrinter() {
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method, P p) {
            this.visitMarkers(method.getMarkers(), p);
            this.visitSpace(method.getPrefix(), Space.Location.IDENTIFIER_PREFIX, p);
            StringBuilder acc = JavadocPrinter.this.getPrinter();
            this.visit(method.getSelect(), p);
            if (method.getSelect() != null) {
                acc.append('#');
            }
            acc.append(method.getSimpleName());
            this.visitContainer("(", method.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, ",", ")", p);
            return method;
        }

        @Override
        public J visitIdentifier(J.Identifier ident, P p) {
            this.visitMarkers(ident.getMarkers(), p);
            this.visitSpace(ident.getPrefix(), Space.Location.IDENTIFIER_PREFIX, p);
            StringBuilder acc = JavadocPrinter.this.getPrinter();
            acc.append(ident.getSimpleName());
            return ident;
        }

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess, P p) {
            this.visitSpace(fieldAccess.getPrefix(), Space.Location.FIELD_ACCESS_PREFIX, p);
            this.visitMarkers(fieldAccess.getMarkers(), p);
            this.visit(fieldAccess.getTarget(), p);
            this.visitLeftPadded(".", fieldAccess.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p);
            return fieldAccess;
        }

        @Override
        public J visitMemberReference(J.MemberReference memberRef, P p) {
            this.visitSpace(memberRef.getPrefix(), Space.Location.MEMBER_REFERENCE_PREFIX, p);
            this.visitMarkers(memberRef.getMarkers(), p);
            this.visit(memberRef.getContaining(), p);
            this.visitLeftPadded("#", memberRef.getPadding().getReference(), JLeftPadded.Location.MEMBER_REFERENCE_NAME, p);
            return memberRef;
        }

        @Override
        public J visitTypeParameter(J.TypeParameter typeParam, P p) {
            this.visitSpace(typeParam.getPrefix(), Space.Location.TYPE_PARAMETERS_PREFIX, p);
            this.visitMarkers(typeParam.getMarkers(), p);
            StringBuilder acc = JavadocPrinter.this.getPrinter();
            acc.append("<");
            this.visit(typeParam.getName(), p);
            acc.append(">");
            return typeParam;
        }

        @Override
        public Space visitSpace(Space space, Space.Location loc, P p) {
            JavadocPrinter.this.getPrinter().append(space.getWhitespace());
            return space;
        }

        private void visitLeftPadded(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, JLeftPadded.Location location, P p) {
            if (leftPadded != null) {
                StringBuilder acc = JavadocPrinter.this.getPrinter();
                this.visitSpace(leftPadded.getBefore(), location.getBeforeLocation(), p);
                if (prefix != null) {
                    acc.append(prefix);
                }
                this.visit(leftPadded.getElement(), p);
            }
        }

        private void visitContainer(String before, @Nullable JContainer<? extends J> container, JContainer.Location location, String suffixBetween, @Nullable String after, P p) {
            if (container == null) {
                return;
            }
            StringBuilder acc = JavadocPrinter.this.getPrinter();
            this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
            acc.append(before);
            this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
            acc.append(after == null ? "" : after);
        }

        private void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, JRightPadded.Location location, String suffixBetween, P p) {
            StringBuilder acc = JavadocPrinter.this.getPrinter();
            for (int i = 0; i < nodes.size(); ++i) {
                JRightPadded<? extends J> node = nodes.get(i);
                this.visit(node.getElement(), p);
                this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
                if (i >= nodes.size() - 1) continue;
                acc.append(suffixBetween);
            }
        }
    }
}

