/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeMethodAccessLevelVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.tree.J;

public final class ChangeMethodAccessLevel
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method declarations/invocations.", example="org.mockito.Matchers anyVararg()")
    private final String methodPattern;
    @Option(displayName="New access level", description="New method access level to apply to the method.", example="public", valid={"private", "protected", "package", "public"})
    private final String newAccessLevel;
    @Option(displayName="Match on overrides", description="When enabled, find methods that are overloads of the method pattern.", required=false)
    @Nullable
    private final Boolean matchOverrides;

    public String getDisplayName() {
        return "Change method access level";
    }

    public String getDescription() {
        return "Change the access level (public, protected, private, package private) of a method.";
    }

    public Validated validate() {
        return super.validate().and(Validated.test((String)"newAccessLevel", (String)"Must be one of 'private', 'protected', 'package', 'public'", (Object)this.newAccessLevel, level -> level.equals("private") || level.equals("protected") || level.equals("package") || level.equals("public")));
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new DeclaresMethod<ExecutionContext>(this.methodPattern, this.matchOverrides);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        J.Modifier.Type type;
        switch (this.newAccessLevel) {
            case "public": {
                type = J.Modifier.Type.Public;
                break;
            }
            case "protected": {
                type = J.Modifier.Type.Protected;
                break;
            }
            case "private": {
                type = J.Modifier.Type.Private;
                break;
            }
            default: {
                type = null;
            }
        }
        return new ChangeMethodAccessLevelVisitor<ExecutionContext>(new MethodMatcher(this.methodPattern), type);
    }

    public ChangeMethodAccessLevel(String methodPattern, String newAccessLevel, @Nullable Boolean matchOverrides) {
        this.methodPattern = methodPattern;
        this.newAccessLevel = newAccessLevel;
        this.matchOverrides = matchOverrides;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getNewAccessLevel() {
        return this.newAccessLevel;
    }

    @Nullable
    public Boolean getMatchOverrides() {
        return this.matchOverrides;
    }

    @NonNull
    public String toString() {
        return "ChangeMethodAccessLevel(methodPattern=" + this.getMethodPattern() + ", newAccessLevel=" + this.getNewAccessLevel() + ", matchOverrides=" + this.getMatchOverrides() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeMethodAccessLevel)) {
            return false;
        }
        ChangeMethodAccessLevel other = (ChangeMethodAccessLevel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$matchOverrides = this.getMatchOverrides();
        Boolean other$matchOverrides = other.getMatchOverrides();
        if (this$matchOverrides == null ? other$matchOverrides != null : !((Object)this$matchOverrides).equals(other$matchOverrides)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$newAccessLevel = this.getNewAccessLevel();
        String other$newAccessLevel = other.getNewAccessLevel();
        return !(this$newAccessLevel == null ? other$newAccessLevel != null : !this$newAccessLevel.equals(other$newAccessLevel));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeMethodAccessLevel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $matchOverrides = this.getMatchOverrides();
        result = result * 59 + ($matchOverrides == null ? 43 : ((Object)$matchOverrides).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $newAccessLevel = this.getNewAccessLevel();
        result = result * 59 + ($newAccessLevel == null ? 43 : $newAccessLevel.hashCode());
        return result;
    }
}

