/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveUnusedPrivateMethods
extends Recipe {
    public String getDisplayName() {
        return "Remove unused private methods";
    }

    public String getDescription() {
        return "`private` methods that are never executed are dead code: unnecessary, inoperative code that should be removed.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1144");
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                J m = super.visitMethodDeclaration(method, executionContext);
                JavaType.Method methodType = TypeUtils.asMethod(method.getType());
                if (methodType != null && methodType.hasFlags(Flag.Private) && !method.isConstructor() && methodType.getGenericSignature() != null && method.getAllAnnotations().isEmpty()) {
                    J.ClassDeclaration classDeclaration = (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class);
                    if (TypeUtils.isAssignableTo(JavaType.Class.build("java.io.Serializable"), classDeclaration.getType())) {
                        switch (((J.MethodDeclaration)m).getSimpleName()) {
                            case "readObject": 
                            case "readObjectNoData": 
                            case "readResolve": 
                            case "writeObject": {
                                return m;
                            }
                        }
                    }
                    J.CompilationUnit cu = (J.CompilationUnit)this.getCursor().firstEnclosingOrThrow(J.CompilationUnit.class);
                    for (JavaType type : cu.getTypesInUse()) {
                        if (type instanceof JavaType.Method) {
                            JavaType.Method usedMethodType = (JavaType.Method)type;
                            if (methodType.getName().equals(usedMethodType.getName()) && methodType.getGenericSignature().equals(usedMethodType.getGenericSignature())) {
                                return m;
                            }
                        }
                        if (!TypeUtils.isOfClassType(type, "org.junit.jupiter.params.provider.MethodSource")) continue;
                        return m;
                    }
                    return null;
                }
                return m;
            }
        };
    }
}

