/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.nio.file.Paths;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.marker.JavaSearchResult;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Marker;

public final class ChangePackage
extends Recipe {
    @Option(displayName="Old package name", description="The package name to replace.", example="com.yourorg.foo")
    private final String oldPackageName;
    @Option(displayName="New package name", description="New package name to replace the old package name with.", example="com.yourorg.bar")
    private final String newPackageName;
    @Option(displayName="Recursive", description="Recursively change subpackage names", required=false, example="true")
    @Nullable
    private final Boolean recursive;

    public String getDisplayName() {
        return "Rename package name";
    }

    public String getDescription() {
        return "A recipe that will rename a package name in package statements, imports, and fully-qualified types.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                String original;
                if (cu.getPackageDeclaration() != null && (original = cu.getPackageDeclaration().getExpression().printTrimmed().replaceAll("\\s", "")).startsWith(ChangePackage.this.oldPackageName)) {
                    return cu.withMarkers(cu.getMarkers().addIfAbsent((Marker)new JavaSearchResult(Tree.randomId(), ChangePackage.this)));
                }
                this.doAfterVisit(new UsesType(ChangePackage.this.oldPackageName + ".*"));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangePackageVisitor();
    }

    public ChangePackage(String oldPackageName, String newPackageName, @Nullable Boolean recursive) {
        this.oldPackageName = oldPackageName;
        this.newPackageName = newPackageName;
        this.recursive = recursive;
    }

    public String getOldPackageName() {
        return this.oldPackageName;
    }

    public String getNewPackageName() {
        return this.newPackageName;
    }

    @Nullable
    public Boolean getRecursive() {
        return this.recursive;
    }

    @NonNull
    public String toString() {
        return "ChangePackage(oldPackageName=" + this.getOldPackageName() + ", newPackageName=" + this.getNewPackageName() + ", recursive=" + this.getRecursive() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePackage)) {
            return false;
        }
        ChangePackage other = (ChangePackage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$recursive = this.getRecursive();
        Boolean other$recursive = other.getRecursive();
        if (this$recursive == null ? other$recursive != null : !((Object)this$recursive).equals(other$recursive)) {
            return false;
        }
        String this$oldPackageName = this.getOldPackageName();
        String other$oldPackageName = other.getOldPackageName();
        if (this$oldPackageName == null ? other$oldPackageName != null : !this$oldPackageName.equals(other$oldPackageName)) {
            return false;
        }
        String this$newPackageName = this.getNewPackageName();
        String other$newPackageName = other.getNewPackageName();
        return !(this$newPackageName == null ? other$newPackageName != null : !this$newPackageName.equals(other$newPackageName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $recursive = this.getRecursive();
        result = result * 59 + ($recursive == null ? 43 : ((Object)$recursive).hashCode());
        String $oldPackageName = this.getOldPackageName();
        result = result * 59 + ($oldPackageName == null ? 43 : $oldPackageName.hashCode());
        String $newPackageName = this.getNewPackageName();
        result = result * 59 + ($newPackageName == null ? 43 : $newPackageName.hashCode());
        return result;
    }

    @NonNull
    public ChangePackage withRecursive(@Nullable Boolean recursive) {
        return this.recursive == recursive ? this : new ChangePackage(this.oldPackageName, this.newPackageName, recursive);
    }

    private class ChangePackageVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final String RENAME_TO_KEY = "renameTo";
        private static final String RENAME_FROM_KEY = "renameFrom";
        private final JavaType.Class newPackageType;

        private ChangePackageVisitor() {
            this.newPackageType = JavaType.Class.build(ChangePackage.this.newPackageName);
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J c = super.visitCompilationUnit(cu, ctx);
            String changingTo = (String)this.getCursor().getMessage(RENAME_TO_KEY);
            if (changingTo != null) {
                String path = ((J.CompilationUnit)c).getSourcePath().toString().replace('\\', '/');
                String changingFrom = (String)this.getCursor().getMessage(RENAME_FROM_KEY);
                assert (changingFrom != null);
                c = ((J.CompilationUnit)c).withSourcePath(Paths.get(path.replaceFirst(changingFrom.replace('.', '/'), changingTo.replace('.', '/')), new String[0]));
                for (J.Import anImport : ((J.CompilationUnit)c).getImports()) {
                    if (!anImport.getPackageName().equals(ChangePackage.this.newPackageName)) continue;
                    c = new RemoveImport(anImport.getTypeName(), true).visitCompilationUnit((J.CompilationUnit)c, ctx);
                }
            }
            return c;
        }

        @Nullable
        public J postVisit(J tree, ExecutionContext executionContext) {
            JavaType.FullyQualified fq;
            J j = (J)super.postVisit((Tree)tree, (Object)executionContext);
            if (j instanceof TypedTree && (fq = TypeUtils.asFullyQualified(((TypedTree)j).getType())) != null && fq.getPackageName().equals(ChangePackage.this.oldPackageName) && !fq.getClassName().isEmpty()) {
                j = ((TypedTree)j).withType(this.buildNewType(fq.getClassName()));
            }
            return j;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            JavaType.FullyQualified type;
            J c = super.visitClassDeclaration(classDecl, ctx);
            String changingTo = (String)this.getCursor().getNearestMessage(RENAME_TO_KEY);
            if (changingTo != null && classDecl.getType() != null && (type = ((J.ClassDeclaration)c).getType()) != null) {
                c = ((J.ClassDeclaration)c).withType(type.withFullyQualifiedName(changingTo + "." + ((J.ClassDeclaration)c).getType().getClassName()));
            }
            return c;
        }

        @Override
        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            J f = super.visitFieldAccess(fieldAccess, ctx);
            if (!(!((J.FieldAccess)f).isFullyQualifiedClassReference(ChangePackage.this.oldPackageName) || this.getCursor().getParent() == null || this.getCursor().getParent().getValue() instanceof J.FieldAccess && ((J.FieldAccess)this.getCursor().getParent().getValue()).isFullyQualifiedClassReference(ChangePackage.this.newPackageName))) {
                f = (J.FieldAccess)TypeTree.build(((JavaType.FullyQualified)this.newPackageType).getFullyQualifiedName()).withPrefix(((J.FieldAccess)f).getPrefix());
            }
            return f;
        }

        @Override
        public J.Package visitPackage(J.Package pkg, ExecutionContext context) {
            String original = pkg.getExpression().printTrimmed().replaceAll("\\s", "");
            this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, RENAME_FROM_KEY, (Object)original);
            if (original.equals(ChangePackage.this.oldPackageName)) {
                this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, RENAME_TO_KEY, (Object)ChangePackage.this.newPackageName);
                pkg = (J.Package)pkg.withTemplate(JavaTemplate.builder(() -> ((ChangePackageVisitor)this).getCursor(), ChangePackage.this.newPackageName).build(), pkg.getCoordinates().replace(), new Object[0]);
            } else if ((ChangePackage.this.recursive == null || ChangePackage.this.recursive.booleanValue()) && original.startsWith(ChangePackage.this.oldPackageName) && !original.startsWith(ChangePackage.this.newPackageName)) {
                String changingTo = ChangePackage.this.newPackageName + original.substring(ChangePackage.this.oldPackageName.length());
                this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, RENAME_TO_KEY, (Object)changingTo);
                pkg = (J.Package)pkg.withTemplate(JavaTemplate.builder(() -> ((ChangePackageVisitor)this).getCursor(), changingTo).build(), pkg.getCoordinates().replace(), new Object[0]);
            }
            return pkg;
        }

        private JavaType updateType(@Nullable JavaType type) {
            JavaType.GenericTypeVariable gtv = TypeUtils.asGeneric(type);
            if (gtv != null && gtv.getBound() != null && gtv.getBound().getPackageName().equals(ChangePackage.this.oldPackageName)) {
                return gtv.withBound(TypeUtils.asFullyQualified(this.buildNewType(gtv.getBound().getClassName())));
            }
            JavaType.FullyQualified fqt = TypeUtils.asFullyQualified(type);
            if (fqt != null && fqt.getPackageName().equals(ChangePackage.this.oldPackageName)) {
                return this.buildNewType(fqt.getClassName());
            }
            JavaType.Method mt = TypeUtils.asMethod(type);
            if (mt != null) {
                return mt.withDeclaringType((JavaType.FullyQualified)this.updateType(mt.getDeclaringType())).withResolvedSignature(this.updateSignature(mt.getResolvedSignature())).withGenericSignature(this.updateSignature(mt.getGenericSignature()));
            }
            return type;
        }

        private JavaType.Method.Signature updateSignature(@Nullable JavaType.Method.Signature signature) {
            if (signature == null) {
                return signature;
            }
            return signature.withReturnType(this.updateType(signature.getReturnType())).withParamTypes(ListUtils.map(signature.getParamTypes(), this::updateType));
        }

        private JavaType buildNewType(String className) {
            return TypeUtils.asFullyQualified(JavaType.buildType(ChangePackage.this.newPackageName + "." + className));
        }
    }
}

