/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.function.UnaryOperator;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class JLeftPadded<T> {
    private final Space before;
    private final T element;
    private final Markers markers;

    public JLeftPadded<T> map(UnaryOperator<T> map) {
        return this.withElement(map.apply(this.element));
    }

    @Nullable
    public static <T> JLeftPadded<T> withElement(@Nullable JLeftPadded<T> before, @Nullable T elements) {
        if (before == null) {
            if (elements == null) {
                return null;
            }
            return new JLeftPadded<T>(Space.EMPTY, elements, Markers.EMPTY);
        }
        if (elements == null) {
            return null;
        }
        return before.withElement(elements);
    }

    public String toString() {
        return "JLeftPadded(before=" + this.before + ", element=" + this.element.getClass().getSimpleName() + ')';
    }

    public static <T> JLeftPadded<T> build(T element) {
        return new JLeftPadded<T>(Space.EMPTY, element, Markers.EMPTY);
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JLeftPadded)) {
            return false;
        }
        JLeftPadded other = (JLeftPadded)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof JLeftPadded;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public JLeftPadded(Space before, T element, Markers markers) {
        this.before = before;
        this.element = element;
        this.markers = markers;
    }

    public Space getBefore() {
        return this.before;
    }

    public T getElement() {
        return this.element;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    @NonNull
    public JLeftPadded<T> withBefore(Space before) {
        return this.before == before ? this : new JLeftPadded<T>(before, this.element, this.markers);
    }

    @NonNull
    public JLeftPadded<T> withElement(T element) {
        return this.element == element ? this : new JLeftPadded<T>(this.before, element, this.markers);
    }

    @NonNull
    public JLeftPadded<T> withMarkers(Markers markers) {
        return this.markers == markers ? this : new JLeftPadded<T>(this.before, this.element, markers);
    }

    public static enum Location {
        ASSERT_DETAIL(Space.Location.ASSERT_DETAIL_PREFIX),
        ASSIGNMENT(Space.Location.ASSIGNMENT),
        ASSIGNMENT_OPERATION_OPERATOR(Space.Location.ASSIGNMENT_OPERATION_OPERATOR),
        BINARY_OPERATOR(Space.Location.BINARY_OPERATOR),
        CLASS_KIND(Space.Location.CLASS_KIND),
        EXTENDS(Space.Location.EXTENDS),
        FIELD_ACCESS_NAME(Space.Location.FIELD_ACCESS_NAME),
        MEMBER_REFERENCE_NAME(Space.Location.MEMBER_REFERENCE_NAME),
        METHOD_DECLARATION_DEFAULT_VALUE(Space.Location.METHOD_DECLARATION_DEFAULT_VALUE),
        STATIC_IMPORT(Space.Location.STATIC_IMPORT),
        TERNARY_TRUE(Space.Location.TERNARY_TRUE),
        TERNARY_FALSE(Space.Location.TERNARY_FALSE),
        TRY_FINALLY(Space.Location.TRY_FINALLY),
        UNARY_OPERATOR(Space.Location.UNARY_OPERATOR),
        VARIABLE_INITIALIZER(Space.Location.VARIABLE_INITIALIZER),
        WHILE_CONDITION(Space.Location.WHILE_CONDITION);

        private final Space.Location beforeLocation;

        private Location(Space.Location beforeLocation) {
            this.beforeLocation = beforeLocation;
        }

        public Space.Location getBeforeLocation() {
            return this.beforeLocation;
        }
    }
}

