/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public class ForLoopIncrementInUpdate
extends Recipe {
    public String getDisplayName() {
        return "`for` loop counters incremented in update.";
    }

    public String getDescription() {
        return "The increment should be moved to the loop\u2019s increment clause if possible.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1994");
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitForLoop(J.ForLoop forLoop, ExecutionContext ctx) {
                Statement init = forLoop.getControl().getInit().get(0);
                if (init instanceof J.VariableDeclarations) {
                    J.Unary unary;
                    List<Statement> statements;
                    J.VariableDeclarations initVars = (J.VariableDeclarations)init;
                    Statement body = forLoop.getBody();
                    if (body instanceof J.Block) {
                        statements = ((J.Block)body).getStatements();
                        if (statements.isEmpty()) {
                            return super.visitForLoop(forLoop, ctx);
                        }
                    } else {
                        return super.visitForLoop(forLoop, ctx);
                    }
                    Statement lastStatement = statements.get(statements.size() - 1);
                    if (lastStatement instanceof J.Unary && (unary = (J.Unary)lastStatement).getExpression() instanceof J.Identifier) {
                        String unaryTarget = ((J.Identifier)unary.getExpression()).getSimpleName();
                        for (J.VariableDeclarations.NamedVariable initVar : initVars.getVariables()) {
                            if (!initVar.getSimpleName().equals(unaryTarget)) continue;
                            J.ForLoop f = forLoop.withControl(forLoop.getControl().withUpdate(ListUtils.insertInOrder((List)ListUtils.map(forLoop.getControl().getUpdate(), u -> u instanceof J.Empty ? null : u), (Object)unary.withPrefix(Space.format(" ")), Comparator.comparing(Tree::printTrimmed, Comparator.naturalOrder()))));
                            f = f.withBody((Statement)new JavaVisitor<ExecutionContext>(){

                                @Nullable
                                public J visit(@Nullable Tree tree, ExecutionContext executionContext) {
                                    return tree == unary ? null : (J)super.visit(tree, (Object)executionContext);
                                }
                            }.visit(f.getBody(), ctx));
                            return f;
                        }
                    }
                }
                return super.visitForLoop(forLoop, ctx);
            }
        };
    }
}

