/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class RemoveUnusedImports
extends Recipe {
    public String getDisplayName() {
        return "Remove unused imports";
    }

    public String getDescription() {
        return "Remove imports for types that are not referenced.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveUnusedImportsVisitor();
    }

    private static class ImportUsage {
        final List<JRightPadded<J.Import>> imports = new ArrayList<JRightPadded<J.Import>>();
        boolean used = true;

        private ImportUsage() {
        }
    }

    private static class RemoveUnusedImportsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private RemoveUnusedImportsVisitor() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout());
            HashMap<String, Set> methodsAndFieldsByTypeName = new HashMap<String, Set>();
            HashMap<String, Set> typesByPackage = new HashMap<String, Set>();
            for (JavaType javaType : cu.getTypesInUse()) {
                if (javaType instanceof JavaType.Variable) {
                    JavaType.Variable variable = (JavaType.Variable)javaType;
                    JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified(variable.getType());
                    if (fullyQualified == null) continue;
                    methodsAndFieldsByTypeName.computeIfAbsent(fullyQualified.getFullyQualifiedName(), f -> new HashSet()).add(variable.getName());
                    continue;
                }
                if (javaType instanceof JavaType.Method) {
                    JavaType.Method method2 = (JavaType.Method)javaType;
                    if (!method2.hasFlags(Flag.Static)) continue;
                    methodsAndFieldsByTypeName.computeIfAbsent(method2.getDeclaringType().getFullyQualifiedName(), t -> new HashSet()).add(method2.getName());
                    continue;
                }
                if (!(javaType instanceof JavaType.FullyQualified)) continue;
                Iterator fullyQualified = (JavaType.FullyQualified)javaType;
                typesByPackage.computeIfAbsent(((JavaType.FullyQualified)((Object)fullyQualified)).getPackageName(), f -> new HashSet()).add(fullyQualified);
            }
            boolean changed = false;
            ArrayList<ImportUsage> importUsage = new ArrayList<ImportUsage>(cu.getPadding().getImports().size());
            for (JRightPadded jRightPadded : cu.getPadding().getImports()) {
                ImportUsage singleUsage = new ImportUsage();
                singleUsage.imports.add(jRightPadded);
                importUsage.add(singleUsage);
            }
            for (ImportUsage importUsage2 : importUsage) {
                J.Import elem = importUsage2.imports.get(0).getElement();
                J.FieldAccess qualid = elem.getQualid();
                J.Identifier name = qualid.getName();
                if (elem.isStatic()) {
                    Set methodsAndFields = (Set)methodsAndFieldsByTypeName.get(elem.getTypeName());
                    if (methodsAndFields == null) {
                        Set types = (Set)typesByPackage.get(elem.getPackageName());
                        if (types != null && !types.stream().noneMatch(c -> qualid.printTrimmed().equals(c.getFullyQualifiedName()))) continue;
                        importUsage2.used = false;
                        changed = true;
                        continue;
                    }
                    if ("*".equals(qualid.getSimpleName())) {
                        if (methodsAndFields.size() >= layoutStyle.getNameCountToUseStarImport()) continue;
                        importUsage2.imports.clear();
                        methodsAndFields.stream().sorted().forEach(method -> anImport.imports.add(new JRightPadded<J.Import>(elem.withQualid(qualid.withName(name.withName((String)method))).withPrefix(Space.format("\n")), Space.EMPTY, Markers.EMPTY)));
                        importUsage2.imports.set(0, importUsage2.imports.get(0).withElement(importUsage2.imports.get(0).getElement().withPrefix(elem.getPrefix())));
                        changed = true;
                        continue;
                    }
                    if (methodsAndFields.contains(qualid.getSimpleName())) continue;
                    importUsage2.used = false;
                    changed = true;
                    continue;
                }
                Set types = (Set)typesByPackage.get(elem.getPackageName());
                if (types == null) {
                    importUsage2.used = false;
                    changed = true;
                    continue;
                }
                if ("*".equals(elem.getQualid().getSimpleName())) {
                    if (types.size() >= layoutStyle.getClassCountToUseStarImport()) continue;
                    importUsage2.imports.clear();
                    types.stream().map(JavaType.FullyQualified::getClassName).sorted().distinct().forEach(type -> anImport.imports.add(new JRightPadded<J.Import>(elem.withQualid(qualid.withName(name.withName((String)type))).withPrefix(Space.format("\n")), Space.EMPTY, Markers.EMPTY)));
                    importUsage2.imports.set(0, importUsage2.imports.get(0).withElement(importUsage2.imports.get(0).getElement().withPrefix(elem.getPrefix())));
                    changed = true;
                    continue;
                }
                if (!types.stream().noneMatch(c -> elem.isFromType(c.getFullyQualifiedName()))) continue;
                importUsage2.used = false;
                changed = true;
            }
            if (changed) {
                ArrayList<JRightPadded<J.Import>> imports = new ArrayList<JRightPadded<J.Import>>();
                Object var9_15 = null;
                for (ImportUsage anImportGroup : importUsage) {
                    void var9_16;
                    if (anImportGroup.used) {
                        List<JRightPadded<J.Import>> importGroup = anImportGroup.imports;
                        for (int i = 0; i < importGroup.size(); ++i) {
                            JRightPadded<J.Import> anImport = importGroup.get(i);
                            if (i == 0 && var9_16 != null && anImport.getElement().getPrefix().getLastWhitespace().chars().filter(c -> c == 10).count() <= 1L) {
                                anImport = anImport.withElement(anImport.getElement().withPrefix((Space)var9_16));
                            }
                            imports.add(anImport);
                        }
                        Object var9_17 = null;
                        continue;
                    }
                    if (var9_16 != null) continue;
                    Space space = anImportGroup.imports.get(0).getElement().getPrefix();
                }
                if ((cu = cu.getPadding().withImports(imports)).getImports().isEmpty() && !cu.getClasses().isEmpty()) {
                    cu = this.autoFormat(cu, cu.getClasses().get(0).getName(), ctx, this.getCursor());
                }
            }
            return cu;
        }
    }
}

