/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.function.Function;
import org.apache.commons.lang.StringEscapeUtils;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class ChangeLiteral<P>
extends JavaIsoVisitor<P> {
    private final Expression scope;
    private final Function<Object, Object> transform;

    public ChangeLiteral(Expression scope, Function<Object, Object> transform) {
        this.scope = scope;
        this.transform = transform;
    }

    @Override
    public J.Literal visitLiteral(J.Literal literal, P p) {
        if (this.getCursor().isScopeInPath((Tree)this.scope)) {
            String transformedSource;
            Object transformed = this.transform.apply(literal.getValue());
            if (transformed.equals(literal.getValue()) || literal.getType() == null) {
                return literal;
            }
            block0 : switch (literal.getType()) {
                case Boolean: 
                case Byte: 
                case Int: 
                case Short: 
                case Void: {
                    transformedSource = transformed.toString();
                    break;
                }
                case Char: {
                    String escaped;
                    switch (escaped = StringEscapeUtils.escapeJavaScript((String)transformed.toString())) {
                        case "\\\"": {
                            transformedSource = "'\"'";
                            break block0;
                        }
                        case "\\/": {
                            transformedSource = "'/'";
                            break block0;
                        }
                    }
                    transformedSource = "'" + escaped + "'";
                    break;
                }
                case Double: {
                    transformedSource = transformed.toString() + "d";
                    break;
                }
                case Float: {
                    transformedSource = transformed.toString() + "f";
                    break;
                }
                case Long: {
                    transformedSource = transformed.toString() + "L";
                    break;
                }
                case String: {
                    transformedSource = "\"" + StringEscapeUtils.escapeJava((String)transformed.toString()) + "\"";
                    break;
                }
                case Wildcard: {
                    transformedSource = "*";
                    break;
                }
                case Null: {
                    transformedSource = "null";
                    break;
                }
                default: {
                    transformedSource = "";
                }
            }
            return literal.withValue(transformed).withValueSource(transformedSource);
        }
        return literal;
    }
}

