/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Comparator;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.Space;

public abstract class Coordinates {
    J tree;

    Coordinates(J tree) {
        this.tree = tree;
    }

    JavaCoordinates insert(Space.Location location) {
        return new JavaCoordinates(this.tree, location, JavaCoordinates.Mode.INSERTION, null);
    }

    JavaCoordinates replace(Space.Location location) {
        return new JavaCoordinates(this.tree, location, JavaCoordinates.Mode.REPLACEMENT, null);
    }

    public JavaCoordinates replace() {
        return new JavaCoordinates(this.tree, null, JavaCoordinates.Mode.REPLACEMENT, null);
    }

    public abstract JavaCoordinates before();

    public static class Wildcard
    extends Coordinates {
        Wildcard(J.Wildcard tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.WILDCARD_PREFIX);
        }
    }

    public static class WhileLoop
    extends Coordinates {
        WhileLoop(J.WhileLoop tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.WHILE_PREFIX);
        }
    }

    public static class VariableDeclarations
    extends Coordinates {
        VariableDeclarations(J.VariableDeclarations tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.VARIABLE_DECLARATIONS_PREFIX);
        }

        public JavaCoordinates addAnnotation(Comparator<J.Annotation> idealOrdering) {
            return new JavaCoordinates(this.tree, Space.Location.ANNOTATIONS, JavaCoordinates.Mode.INSERTION, idealOrdering);
        }

        public JavaCoordinates replaceAnnotations() {
            return this.replace(Space.Location.ANNOTATIONS);
        }

        public static class NamedVar
        extends Coordinates {
            NamedVar(J.VariableDeclarations.NamedVariable tree) {
                super(tree);
            }

            @Override
            public JavaCoordinates before() {
                return this.insert(Space.Location.VARIABLE_PREFIX);
            }
        }
    }

    public static class Unary
    extends Coordinates {
        Unary(J.Unary tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.UNARY_PREFIX);
        }
    }

    public static class TypeParameter
    extends Coordinates {
        TypeParameter(J.TypeParameter tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.TYPE_PARAMETERS_PREFIX);
        }

        public JavaCoordinates bounds() {
            return this.insert(Space.Location.TYPE_BOUNDS);
        }
    }

    public static class TypeCast
    extends Coordinates {
        TypeCast(J.TypeCast tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.TYPE_CAST_PREFIX);
        }
    }

    public static class Try
    extends Coordinates {
        Try(J.Try tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.TRY_PREFIX);
        }

        public static class Resource
        extends Coordinates {
            Resource(J.Try.Resource tree) {
                super(tree);
            }

            @Override
            public JavaCoordinates before() {
                return this.insert(Space.Location.TRY_RESOURCE);
            }
        }

        public static class Catch
        extends Coordinates {
            Catch(J.Try.Catch catzch) {
                super(catzch);
            }

            @Override
            public JavaCoordinates before() {
                return this.insert(Space.Location.CATCH_PREFIX);
            }
        }
    }

    public static class Throw
    extends Coordinates {
        Throw(J.Throw tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.THROW_PREFIX);
        }
    }

    public static class Ternary
    extends Coordinates {
        Ternary(J.Ternary tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.TERNARY_PREFIX);
        }
    }

    public static class Synchronized
    extends Coordinates {
        Synchronized(J.Synchronized tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.SYNCHRONIZED_PREFIX);
        }
    }

    public static class Switch
    extends Coordinates {
        Switch(J.Switch tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.SWITCH_PREFIX);
        }
    }

    public static class Return
    extends Coordinates {
        Return(J.Return tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.RETURN_PREFIX);
        }
    }

    public static class Primitive
    extends Coordinates {
        Primitive(J.Primitive tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.PRIMITIVE_PREFIX);
        }
    }

    public static class Parentheses
    extends Coordinates {
        Parentheses(J.Parentheses<?> tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.PARENTHESES_PREFIX);
        }
    }

    public static class ParameterizedType
    extends Coordinates {
        ParameterizedType(J.ParameterizedType tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.PARAMETERIZED_TYPE_PREFIX);
        }
    }

    public static class Package
    extends Coordinates {
        Package(J.Package tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.PACKAGE_PREFIX);
        }
    }

    public static class NewClass
    extends Coordinates {
        NewClass(J.NewClass tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.NEW_CLASS_PREFIX);
        }
    }

    public static class NewArray
    extends Coordinates {
        NewArray(J.NewArray tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.NEW_ARRAY_PREFIX);
        }
    }

    public static class MultiCatch
    extends Coordinates {
        MultiCatch(J.MultiCatch tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.MULTI_CATCH_PREFIX);
        }
    }

    public static class Modifier
    extends Coordinates {
        Modifier(J.Modifier tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.MODIFIER_PREFIX);
        }
    }

    public static class MethodInvocation
    extends Coordinates {
        MethodInvocation(J.MethodInvocation tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.METHOD_INVOCATION_PREFIX);
        }

        public JavaCoordinates replaceArguments() {
            return this.replace(Space.Location.METHOD_INVOCATION_ARGUMENTS);
        }
    }

    public static class MethodDeclaration
    extends Coordinates {
        MethodDeclaration(J.MethodDeclaration tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.METHOD_DECLARATION_PREFIX);
        }

        public JavaCoordinates addAnnotation(Comparator<J.Annotation> idealOrdering) {
            return new JavaCoordinates(this.tree, Space.Location.ANNOTATIONS, JavaCoordinates.Mode.INSERTION, idealOrdering);
        }

        public JavaCoordinates replaceAnnotations() {
            return this.replace(Space.Location.ANNOTATIONS);
        }

        public JavaCoordinates replaceTypeParameters() {
            return this.replace(Space.Location.TYPE_PARAMETERS);
        }

        public JavaCoordinates replaceParameters() {
            return this.replace(Space.Location.METHOD_DECLARATION_PARAMETERS);
        }

        public JavaCoordinates replaceThrows() {
            return this.replace(Space.Location.THROWS);
        }

        public JavaCoordinates replaceBody() {
            return this.replace(Space.Location.BLOCK_PREFIX);
        }
    }

    public static class MemberReference
    extends Coordinates {
        MemberReference(J.MemberReference tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.MEMBER_REFERENCE_PREFIX);
        }
    }

    public static class Literal
    extends Coordinates {
        Literal(J.Literal tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.LITERAL_PREFIX);
        }
    }

    public static class Lambda
    extends Coordinates {
        Lambda(J.Lambda tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.LAMBDA_PREFIX);
        }

        public static class Parameters
        extends Coordinates {
            Parameters(J.Lambda.Parameters tree) {
                super(tree);
            }

            @Override
            public JavaCoordinates before() {
                return this.insert(Space.Location.LAMBDA_PARAMETERS_PREFIX);
            }
        }
    }

    public static class Label
    extends Coordinates {
        Label(J.Label tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.LABEL_PREFIX);
        }
    }

    public static class InstanceOf
    extends Coordinates {
        InstanceOf(J.InstanceOf tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.INSTANCEOF_PREFIX);
        }
    }

    public static class Import
    extends Coordinates {
        Import(J.Import tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.IMPORT_PREFIX);
        }
    }

    public static class If
    extends Coordinates {
        If(J.If tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.IF_PREFIX);
        }

        public static class Else
        extends Coordinates {
            Else(J.If.Else tree) {
                super(tree);
            }

            @Override
            public JavaCoordinates before() {
                return this.insert(Space.Location.FOR_CONTROL_PREFIX);
            }
        }
    }

    public static class Identifier
    extends Coordinates {
        Identifier(J.Identifier tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.IDENTIFIER_PREFIX);
        }
    }

    public static class ForLoop
    extends Coordinates {
        ForLoop(J.ForLoop tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.FOR_PREFIX);
        }

        public static class Control
        extends Coordinates {
            Control(J.ForLoop.Control tree) {
                super(tree);
            }

            @Override
            public JavaCoordinates before() {
                return this.insert(Space.Location.FOR_CONTROL_PREFIX);
            }
        }
    }

    public static class ForEachLoop
    extends Coordinates {
        ForEachLoop(J.ForEachLoop tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.FOR_EACH_LOOP_PREFIX);
        }

        public static class Control
        extends Coordinates {
            Control(J.ForEachLoop.Control tree) {
                super(tree);
            }

            @Override
            public JavaCoordinates before() {
                return this.insert(Space.Location.FOR_EACH_CONTROL_PREFIX);
            }
        }
    }

    public static class FieldAccess
    extends Coordinates {
        FieldAccess(J.FieldAccess tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.FIELD_ACCESS_PREFIX);
        }
    }

    public static class EnumValueSet
    extends Coordinates {
        EnumValueSet(J.EnumValueSet tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.ENUM_VALUE_SET_PREFIX);
        }
    }

    public static class EnumValue
    extends Coordinates {
        EnumValue(J.EnumValue tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.ENUM_VALUE_PREFIX);
        }
    }

    public static class Empty
    extends Coordinates {
        Empty(J.Empty tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.EMPTY_PREFIX);
        }
    }

    public static class DoWhileLoop
    extends Coordinates {
        DoWhileLoop(J.DoWhileLoop tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.DO_WHILE_PREFIX);
        }
    }

    public static class ControlParentheses
    extends Coordinates {
        ControlParentheses(J.ControlParentheses<?> tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.CONTROL_PARENTHESES_PREFIX);
        }
    }

    public static class Continue
    extends Coordinates {
        Continue(J.Continue tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.CONTINUE_PREFIX);
        }
    }

    public static class CompilationUnit
    extends Coordinates {
        CompilationUnit(J.CompilationUnit tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.COMPILATION_UNIT_PREFIX);
        }
    }

    public static class ClassDeclaration
    extends Coordinates {
        ClassDeclaration(J.ClassDeclaration tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.CLASS_DECLARATION_PREFIX);
        }

        public JavaCoordinates addAnnotation(Comparator<J.Annotation> idealOrdering) {
            return new JavaCoordinates(this.tree, Space.Location.ANNOTATIONS, JavaCoordinates.Mode.INSERTION, idealOrdering);
        }

        public JavaCoordinates replaceAnnotations() {
            return this.replace(Space.Location.ANNOTATIONS);
        }

        public JavaCoordinates replaceTypeParameters() {
            return this.replace(Space.Location.TYPE_PARAMETERS);
        }

        public JavaCoordinates replaceExtendsClause() {
            return this.replace(Space.Location.EXTENDS);
        }

        public JavaCoordinates replaceImplementsClause() {
            return this.replace(Space.Location.IMPLEMENTS);
        }

        public JavaCoordinates replaceBody() {
            return this.replace(Space.Location.BLOCK_PREFIX);
        }
    }

    public static class Case
    extends Coordinates {
        Case(J.Case tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.CASE_PREFIX);
        }
    }

    public static class Break
    extends Coordinates {
        Break(J.Break tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.BREAK_PREFIX);
        }
    }

    public static class Block
    extends Coordinates {
        Block(J.Block tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.BLOCK_PREFIX);
        }

        public JavaCoordinates lastStatement() {
            return this.insert(Space.Location.BLOCK_END);
        }
    }

    public static class Binary
    extends Coordinates {
        Binary(J.Binary tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.BINARY_PREFIX);
        }
    }

    public static class AssignmentOperation
    extends Coordinates {
        AssignmentOperation(J.AssignmentOperation tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.ASSIGNMENT_OPERATION_PREFIX);
        }
    }

    public static class Assignment
    extends Coordinates {
        Assignment(J.Assignment tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.ASSIGNMENT_PREFIX);
        }
    }

    public static class Assert
    extends Coordinates {
        Assert(J.Assert tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.ASSERT_PREFIX);
        }
    }

    public static class ArrayType
    extends Coordinates {
        ArrayType(J.ArrayType tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.ARRAY_TYPE_PREFIX);
        }
    }

    public static class ArrayDimension
    extends Coordinates {
        ArrayDimension(J.ArrayDimension tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.DIMENSION_PREFIX);
        }
    }

    public static class ArrayAccess
    extends Coordinates {
        ArrayAccess(J.ArrayAccess tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.ARRAY_ACCESS_PREFIX);
        }
    }

    public static class Annotation
    extends Coordinates {
        Annotation(J.Annotation tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.ANNOTATION_PREFIX);
        }
    }

    public static class AnnotatedType
    extends Coordinates {
        AnnotatedType(J.AnnotatedType tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates before() {
            return this.insert(Space.Location.ANNOTATED_TYPE_PREFIX);
        }
    }
}

