/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import org.openrewrite.TreePrinter;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.Space;

public class MethodDeclarationToString {
    private static final JavaPrinter<Void> METHOD_PRINTER = new JavaPrinter<Void>(TreePrinter.identity()){

        @Override
        public J visitMethodDeclaration(J.MethodDeclaration method, Void unused) {
            this.visitModifiers(Space.formatFirstPrefix(method.getModifiers(), Space.EMPTY), unused);
            StringBuilder acc = this.getPrinter();
            if (!method.getModifiers().isEmpty()) {
                acc.append(' ');
            }
            this.visitContainer("<", method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", unused);
            if (method.getReturnTypeExpression() != null) {
                acc.append(method.getReturnTypeExpression().printTrimmed()).append(' ');
            }
            acc.append(method.getSimpleName());
            this.visitContainer("(", method.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", unused);
            this.visitContainer("throws", method.getPadding().getThrows(), JContainer.Location.THROWS, ",", "", unused);
            return method;
        }
    };

    public static String toString(J.MethodDeclaration method) {
        return METHOD_PRINTER.print(method, null);
    }
}

