/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

public class ExtractTrees {
    public static List<J> extract(J.CompilationUnit cu) {
        ExtractionContext extractionContext = new ExtractionContext();
        new ExtractTemplatedCode().visit(cu, extractionContext);
        return extractionContext.getSnippets();
    }

    private static class ExtractTemplatedCode
    extends JavaVisitor<ExtractionContext> {
        public ExtractTemplatedCode() {
            this.setCursoringOn();
        }

        @Override
        public Space visitSpace(Space space, Space.Location loc, ExtractionContext context) {
            Comment startToken;
            long templateDepth = this.getCursor().getPathAsStream().count();
            if (this.findComment(space, "<<<<END>>>>") != null) {
                context.collectElements = false;
                while (context.collectedElements.size() > 1 && this.getCursor().isScopeInPath((Tree)((ExtractionContext.CollectedElement)((ExtractionContext)context).collectedElements.get((int)0)).element)) {
                    context.collectedElements.remove(0);
                }
            }
            if ((startToken = this.findComment(space, "<<<<START>>>>")) != null) {
                context.collectElements = true;
                Object value = this.getCursor().getValue();
                if (!(value instanceof J)) {
                    return space;
                }
                J treeValue = (J)value;
                context.collectedIds.add(treeValue.getId());
                ArrayList<Comment> comments = new ArrayList<Comment>(space.getComments());
                comments.remove(startToken);
                context.collectedElements.add(new ExtractionContext.CollectedElement(templateDepth, (J)treeValue.withPrefix(space.withComments(comments))));
            } else if (context.collectElements && this.getCursor().getValue() instanceof J) {
                J treeValue = (J)this.getCursor().getValue();
                if (!context.collectedIds.contains(treeValue.getId())) {
                    context.collectedElements.add(new ExtractionContext.CollectedElement(templateDepth, treeValue));
                    context.collectedIds.add(treeValue.getId());
                }
            }
            return space;
        }

        @Nullable
        private Comment findComment(@Nullable Space space, String comment) {
            if (space == null) {
                return null;
            }
            return space.getComments().stream().filter(c -> Comment.Style.BLOCK.equals((Object)c.getStyle())).filter(c -> c.getText().equals(comment)).findAny().orElse(null);
        }
    }

    private static class ExtractionContext {
        private boolean collectElements = false;
        private final List<CollectedElement> collectedElements = new ArrayList<CollectedElement>();
        private final Set<UUID> collectedIds = new HashSet<UUID>();

        private ExtractionContext() {
        }

        private <J2 extends J> List<J2> getSnippets() {
            if (this.collectedElements.isEmpty()) {
                return Collections.emptyList();
            }
            long startDepth = this.collectedElements.get((int)0).depth;
            return this.collectedElements.stream().filter(e -> e.depth == startDepth).map(e -> e.element).collect(Collectors.toList());
        }

        private static class CollectedElement {
            final long depth;
            final J element;

            CollectedElement(long depth, J element) {
                this.depth = depth;
                this.element = element;
            }
        }
    }
}

