/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Optional;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.format.BlankLinesVisitor;
import org.openrewrite.java.format.MinimumViableSpacingVisitor;
import org.openrewrite.java.format.NormalizeFormatVisitor;
import org.openrewrite.java.format.RemoveTrailingWhitespaceVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.format.TabsAndIndentsVisitor;
import org.openrewrite.java.format.WrappingAndBracesVisitor;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;

public class AutoFormatVisitor<P>
extends JavaVisitor<P> {
    public J visit(@Nullable Tree tree, P p, Cursor cursor) {
        J.CompilationUnit cu = (J.CompilationUnit)cursor.firstEnclosingOrThrow(J.CompilationUnit.class);
        J t = (J)new NormalizeFormatVisitor().visit(tree, p, cursor);
        t = (J)new MinimumViableSpacingVisitor().visit(t, p, cursor);
        t = (J)new RemoveTrailingWhitespaceVisitor().visit(t, p, cursor);
        t = (J)new BlankLinesVisitor(Optional.ofNullable((BlankLinesStyle)cu.getStyle(BlankLinesStyle.class)).orElse(IntelliJ.blankLines())).visit(t, p, cursor);
        t = (J)new SpacesVisitor(Optional.ofNullable((SpacesStyle)cu.getStyle(SpacesStyle.class)).orElse(IntelliJ.spaces())).visit(t, p, cursor);
        t = (J)new WrappingAndBracesVisitor(Optional.ofNullable((WrappingAndBracesStyle)cu.getStyle(WrappingAndBracesStyle.class)).orElse(IntelliJ.wrappingAndBraces())).visit(t, p, cursor);
        t = new TabsAndIndentsVisitor(Optional.ofNullable((TabsAndIndentsStyle)cu.getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents())).visit((Tree)t, (Object)p, cursor);
        return t;
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        J t = (J)new BlankLinesVisitor(Optional.ofNullable((BlankLinesStyle)cu.getStyle(BlankLinesStyle.class)).orElse(IntelliJ.blankLines())).visit(cu, p);
        t = (J)new SpacesVisitor(Optional.ofNullable((SpacesStyle)cu.getStyle(SpacesStyle.class)).orElse(IntelliJ.spaces())).visit(t, p);
        t = (J)new WrappingAndBracesVisitor(Optional.ofNullable((WrappingAndBracesStyle)cu.getStyle(WrappingAndBracesStyle.class)).orElse(IntelliJ.wrappingAndBraces())).visit(t, p);
        t = (J)new TabsAndIndentsVisitor(Optional.ofNullable((TabsAndIndentsStyle)cu.getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents())).visit(t, p);
        return t;
    }
}

