/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.internal.FormatFirstClassPrefix;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;

public class OrderImports
extends Recipe {
    private boolean removeUnused = true;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new OrderImportsVisitor<ExecutionContext>(this.removeUnused);
    }

    public boolean isRemoveUnused() {
        return this.removeUnused;
    }

    public void setRemoveUnused(boolean removeUnused) {
        this.removeUnused = removeUnused;
    }

    public String toString() {
        return "OrderImports(removeUnused=" + this.isRemoveUnused() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderImports)) {
            return false;
        }
        OrderImports other = (OrderImports)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isRemoveUnused() == other.isRemoveUnused();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderImports;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isRemoveUnused() ? 79 : 97);
        return result;
    }

    public OrderImports(boolean removeUnused) {
        this.removeUnused = removeUnused;
    }

    public OrderImports() {
    }

    static class OrderImportsVisitor<P>
    extends JavaIsoVisitor<P> {
        private final boolean removeUnused;

        OrderImportsVisitor(boolean removeUnused) {
            this.removeUnused = removeUnused;
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P ctx) {
            ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout());
            List<JRightPadded<J.Import>> orderedImports = layoutStyle.orderImports(cu.getPadding().getImports());
            boolean changed = false;
            if (orderedImports.size() != cu.getImports().size()) {
                cu = cu.getPadding().withImports(orderedImports);
                changed = true;
            } else {
                for (int i = 0; i < orderedImports.size(); ++i) {
                    if (orderedImports.get(i) == cu.getPadding().getImports().get(i)) continue;
                    cu = cu.getPadding().withImports(orderedImports);
                    changed = true;
                    break;
                }
            }
            if (this.removeUnused) {
                this.doAfterVisit(new RemoveUnusedImports());
            } else if (changed) {
                this.doAfterVisit(new FormatFirstClassPrefix());
            }
            return cu;
        }
    }
}

