/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.nio.file.Paths;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;

public class ChangePackage
extends Recipe {
    private final String oldFullyQualifiedPackageName;
    private final String newFullyQualifiedPackageName;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final JavaTemplate newPackageExpr;
            {
                this.setCursoringOn();
                this.newPackageExpr = this.template("package " + ChangePackage.this.newFullyQualifiedPackageName).build();
            }

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext context) {
                J c = super.visitCompilationUnit(cu, context);
                Boolean changing = (Boolean)this.getCursor().peekMessage("changing");
                if (changing != null && changing.booleanValue()) {
                    String path = ((J.CompilationUnit)c).getSourcePath().toString();
                    c = ((J.CompilationUnit)c).withSourcePath(Paths.get(path.replaceFirst(ChangePackage.this.oldFullyQualifiedPackageName.replace('.', '/'), ChangePackage.this.newFullyQualifiedPackageName.replace('.', '/')), new String[0]));
                }
                return c;
            }

            @Override
            public J.Package visitPackage(J.Package pkg, ExecutionContext context) {
                if (pkg.getExpression().printTrimmed().replaceAll("\\s", "").equals(ChangePackage.this.oldFullyQualifiedPackageName)) {
                    this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, "changing", (Object)true);
                    return (J.Package)pkg.withTemplate(this.newPackageExpr, pkg.getCoordinates().replace(), new Object[0]);
                }
                return pkg;
            }

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext context) {
                Boolean changing = (Boolean)this.getCursor().peekNearestMessage("changing");
                if (changing != null && changing.booleanValue() && classDecl.getType() != null) {
                    String fqn = classDecl.getType().getFullyQualifiedName();
                    ChangePackage.this.doNext(new ChangeType(fqn, fqn.replaceFirst("^" + ChangePackage.this.oldFullyQualifiedPackageName, ChangePackage.this.newFullyQualifiedPackageName)));
                }
                return super.visitClassDeclaration(classDecl, context);
            }
        };
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePackage)) {
            return false;
        }
        ChangePackage other = (ChangePackage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldFullyQualifiedPackageName = this.getOldFullyQualifiedPackageName();
        String other$oldFullyQualifiedPackageName = other.getOldFullyQualifiedPackageName();
        if (this$oldFullyQualifiedPackageName == null ? other$oldFullyQualifiedPackageName != null : !this$oldFullyQualifiedPackageName.equals(other$oldFullyQualifiedPackageName)) {
            return false;
        }
        String this$newFullyQualifiedPackageName = this.getNewFullyQualifiedPackageName();
        String other$newFullyQualifiedPackageName = other.getNewFullyQualifiedPackageName();
        return !(this$newFullyQualifiedPackageName == null ? other$newFullyQualifiedPackageName != null : !this$newFullyQualifiedPackageName.equals(other$newFullyQualifiedPackageName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChangePackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldFullyQualifiedPackageName = this.getOldFullyQualifiedPackageName();
        result = result * 59 + ($oldFullyQualifiedPackageName == null ? 43 : $oldFullyQualifiedPackageName.hashCode());
        String $newFullyQualifiedPackageName = this.getNewFullyQualifiedPackageName();
        result = result * 59 + ($newFullyQualifiedPackageName == null ? 43 : $newFullyQualifiedPackageName.hashCode());
        return result;
    }

    public ChangePackage(String oldFullyQualifiedPackageName, String newFullyQualifiedPackageName) {
        this.oldFullyQualifiedPackageName = oldFullyQualifiedPackageName;
        this.newFullyQualifiedPackageName = newFullyQualifiedPackageName;
    }

    public String getOldFullyQualifiedPackageName() {
        return this.oldFullyQualifiedPackageName;
    }

    public String getNewFullyQualifiedPackageName() {
        return this.newFullyQualifiedPackageName;
    }

    public String toString() {
        return "ChangePackage(oldFullyQualifiedPackageName=" + this.getOldFullyQualifiedPackageName() + ", newFullyQualifiedPackageName=" + this.getNewFullyQualifiedPackageName() + ")";
    }
}

