/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class FindTypesInNameScope {
    private FindTypesInNameScope() {
    }

    public static Set<JavaType> find(J j) {
        HashSet<JavaType> types = new HashSet<JavaType>();
        new FindReferencedTypesVisitor().visit(j, types);
        return types;
    }

    private static class FindReferencedTypesVisitor
    extends JavaVisitor<Set<JavaType>> {
        private FindReferencedTypesVisitor() {
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method, Set<JavaType> ctx) {
            if (method.getType() != null) {
                ctx.add(method.getType());
            }
            return super.visitMethodInvocation(method, ctx);
        }

        @Override
        public J visitNewClass(J.NewClass newClass, Set<JavaType> ctx) {
            if (newClass.getType() != null) {
                ctx.add(newClass.getType());
            }
            return super.visitNewClass(newClass, ctx);
        }

        @Override
        public J visitVariable(J.VariableDecls.NamedVar variable, Set<JavaType> ctx) {
            if (variable.getType() != null) {
                ctx.add(variable.getType());
            }
            return super.visitVariable(variable, ctx);
        }
    }
}

