/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import java.util.stream.Collectors;
import org.openrewrite.TreePrinter;
import org.openrewrite.java.internal.JavaPrinter;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;

public class VariableDeclsToString {
    private static final JavaPrinter<Void> VARIABLE_PRINTER = new JavaPrinter<Void>(TreePrinter.identity()){

        @Override
        public J visitMultiVariable(J.VariableDecls multiVariable, Void unused) {
            this.visitModifiers(Space.formatFirstPrefix(multiVariable.getModifiers(), Space.EMPTY), unused);
            StringBuilder acc = this.getPrinterAcc();
            if (!multiVariable.getModifiers().isEmpty()) {
                acc.append(' ');
            }
            if (multiVariable.getTypeExpr() != null) {
                acc.append(multiVariable.getTypeExpr().printTrimmed()).append(' ');
            }
            acc.append(multiVariable.getDimensionsBeforeName().stream().map(d -> "[]").collect(Collectors.joining("")));
            if (multiVariable.getVarargs() != null) {
                acc.append("...");
            }
            acc.append(multiVariable.getVars().stream().map(JRightPadded::getElem).map(J.VariableDecls.NamedVar::getSimpleName).collect(Collectors.joining(", ")));
            return multiVariable;
        }
    };

    public static String toString(J.VariableDecls v) {
        return VARIABLE_PRINTER.print(v, null);
    }
}

