/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;

public class JContainer<T> {
    private static final JContainer<?> EMPTY = new JContainer(Space.EMPTY, Collections.emptyList());
    private final Space before;
    private final List<JRightPadded<T>> elem;

    private JContainer(Space before, List<JRightPadded<T>> elem) {
        this.before = before;
        this.elem = elem;
    }

    @JsonCreator
    public static <T> JContainer<T> build(@JsonProperty(value="before") Space before, @JsonProperty(value="elem") List<JRightPadded<T>> elem) {
        if (before.isEmpty() && elem.isEmpty()) {
            return JContainer.empty();
        }
        return new JContainer<T>(before, elem);
    }

    public static <T> JContainer<T> empty() {
        return EMPTY;
    }

    public JContainer<T> withBefore(Space before) {
        return JContainer.build(before, this.elem);
    }

    public JContainer<T> withElem(List<JRightPadded<T>> elem) {
        return JContainer.build(this.getBefore(), elem);
    }

    public List<JRightPadded<T>> getElem() {
        return this.elem;
    }

    public Space getBefore() {
        return this.before;
    }

    public JContainer<T> map(Function<T, T> map) {
        return this.withElem(ListUtils.map(this.elem, t -> t.map(map)));
    }
}

