/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.Cursor;
import org.openrewrite.java.JavaProcessor;
import org.openrewrite.java.tree.J;

public class UnwrapParentheses<P>
extends JavaProcessor<P> {
    private final J.Parentheses<?> scope;

    public UnwrapParentheses(J.Parentheses<?> scope) {
        this.scope = scope;
        this.setCursoringOn();
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, P p) {
        return this.scope.isScope(parens) && UnwrapParentheses.isUnwrappable(this.getCursor()) ? ((J)parens.getTree().getElem()).withPrefix(parens.getPrefix()) : super.visitParentheses((J.Parentheses)parens, (Object)p);
    }

    public static boolean isUnwrappable(Cursor parensScope) {
        if (!(parensScope.getTree() instanceof J.Parentheses)) {
            return false;
        }
        J parent = (J)parensScope.getParentOrThrow().getTree();
        if (parent instanceof J.If || parent instanceof J.Switch || parent instanceof J.Synchronized || parent instanceof J.Try.Catch || parent instanceof J.TypeCast || parent instanceof J.WhileLoop) {
            return false;
        }
        if (parent instanceof J.DoWhileLoop) {
            return parensScope.getTree() != ((J.DoWhileLoop)parent).getWhileCondition().getElem();
        }
        return true;
    }
}

