/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaProcessor;
import org.openrewrite.java.internal.JavaPrinter;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating(since="7.0.0")
public class JavaTemplate {
    private static final Logger logger = LoggerFactory.getLogger(JavaTemplate.class);
    private static final String SNIPPET_MARKER_START = "<<<<START>>>>";
    private static final String SNIPPET_MARKER_END = "<<<<END>>>>";
    private final JavaParser parser;
    private final String code;
    private final int parameterCount;
    private final Set<String> imports;
    private final String parameterMarker;

    private JavaTemplate(JavaParser parser, String code, Set<String> imports, String parameterMarker) {
        this.parser = parser;
        this.code = code;
        this.parameterCount = StringUtils.countOccurrences((String)code, (String)parameterMarker);
        this.imports = imports;
        this.parameterMarker = parameterMarker;
    }

    public static Builder builder(String code) {
        return new Builder(code);
    }

    public <J2 extends J> List<J2> generateBefore(Cursor insertionScope, Object ... parameters) {
        return this.generate(false, insertionScope, parameters);
    }

    public <J2 extends J> List<J2> generateAfter(Cursor insertionScope, Object ... parameters) {
        return this.generate(true, insertionScope, parameters);
    }

    private <J2 extends J> List<J2> generate(boolean after, Cursor insertionScope, Object ... parameters) {
        if (parameters.length != this.parameterCount) {
            throw new IllegalArgumentException("This template requires " + this.parameterCount + " parameters.");
        }
        String printedTemplate = this.substituteParameters(parameters);
        J.CompilationUnit cu = (J.CompilationUnit)insertionScope.firstEnclosing(J.CompilationUnit.class);
        assert (cu != null);
        boolean memberVariableInitializer = false;
        while (insertionScope.getParent() != null && !(insertionScope.getParent().getTree() instanceof J.CompilationUnit) && !(insertionScope.getParent().getTree() instanceof J.Block)) {
            if (insertionScope.getParent().getTree() instanceof J.VariableDecls.NamedVar) {
                Iterator index = insertionScope.getPath();
                while (index.hasNext()) {
                    if (!(index.next() instanceof J.Block) || !index.hasNext() || !(index.next() instanceof J.ClassDecl)) continue;
                    memberVariableInitializer = true;
                }
            }
            insertionScope = insertionScope.getParent();
        }
        J pruned = new TemplateProcessor().visitCompilationUnit(cu, insertionScope);
        Object generatedSource = new TemplatePrinter(after, memberVariableInitializer, insertionScope, this.imports).visit((Tree)pruned, printedTemplate);
        logger.trace("Generated Source:\n-------------------\n{}\n-------------------", generatedSource);
        this.parser.reset();
        J.CompilationUnit synthetic = this.parser.parse(new String[]{generatedSource}).iterator().next();
        ExtractionContext extractionContext = new ExtractionContext();
        new ExtractTemplatedCode().visit(synthetic, extractionContext);
        return extractionContext.getSnippets();
    }

    private String substituteParameters(Object ... parameters) {
        String codeInstance = this.code;
        for (Object parameter : parameters) {
            codeInstance = StringUtils.replaceFirst((String)codeInstance, (String)this.parameterMarker, (String)this.substituteParameter(parameter));
        }
        return codeInstance;
    }

    private String substituteParameter(Object parameter) {
        if (parameter instanceof Tree) {
            return ((Tree)parameter).printTrimmed();
        }
        if (parameter instanceof JRightPadded) {
            return this.substituteParameter(((JRightPadded)parameter).getElem());
        }
        if (parameter instanceof JLeftPadded) {
            return this.substituteParameter(((JLeftPadded)parameter).getElem());
        }
        return parameter.toString();
    }

    public static class Builder {
        private final String code;
        private final Set<String> imports = new HashSet<String>();
        private JavaParser javaParser = ((JavaParser.Builder)JavaParser.fromJavaVersion().logCompilationWarningsAndErrors(false)).build();
        private String parameterMarker = "#{}";

        Builder(String code) {
            this.code = code.trim();
        }

        public Builder imports(String ... fullyQualifiedTypeNames) {
            for (String typeName : fullyQualifiedTypeNames) {
                if (typeName.startsWith("import ") || typeName.startsWith("static ")) {
                    throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include an \"import \" or \"static \" prefix");
                }
                if (typeName.endsWith(";") || typeName.endsWith("\n")) {
                    throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include a suffixed terminator");
                }
                this.imports.add("import " + typeName + ";\n");
            }
            return this;
        }

        public Builder staticImports(String ... fullyQualifiedMemberTypeNames) {
            for (String typeName : fullyQualifiedMemberTypeNames) {
                if (typeName.startsWith("import ") || typeName.startsWith("static ")) {
                    throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include an \"import \" or \"static \" prefix");
                }
                if (typeName.endsWith(";") || typeName.endsWith("\n")) {
                    throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include a suffixed terminator");
                }
                this.imports.add("static import " + typeName + ";\n");
            }
            return this;
        }

        public Builder javaParser(JavaParser javaParser) {
            this.javaParser = javaParser;
            return this;
        }

        public Builder parameterMarker(String parameterMarker) {
            this.parameterMarker = parameterMarker;
            return this;
        }

        public JavaTemplate build() {
            if (this.javaParser == null) {
                this.javaParser = ((JavaParser.Builder)JavaParser.fromJavaVersion().logCompilationWarningsAndErrors(false)).build();
            }
            return new JavaTemplate(this.javaParser, this.code, this.imports, this.parameterMarker);
        }
    }

    private static class ExtractTemplatedCode
    extends JavaProcessor<ExtractionContext> {
        public ExtractTemplatedCode() {
            this.setCursoringOn();
        }

        @Override
        public Space visitSpace(Space space, ExtractionContext context) {
            Comment startToken;
            long templateDepth = this.getCursor().getPathAsStream().count();
            if (this.findMarker(space, JavaTemplate.SNIPPET_MARKER_END) != null) {
                context.collectElements = false;
                if (context.collectedElements.size() > 1 && this.getCursor().isScopeInPath((Tree)context.collectedElements.get((int)0).element)) {
                    context.collectedElements.remove(0);
                    ++context.startDepth;
                }
            }
            if ((startToken = this.findMarker(space, JavaTemplate.SNIPPET_MARKER_START)) != null) {
                context.collectElements = true;
                context.collectedIds.add(this.getCursor().getTree().getId());
                context.startDepth = templateDepth;
                if (this.getCursor().getTree() instanceof J.CompilationUnit) {
                    ++context.startDepth;
                    return space;
                }
                ArrayList<Comment> comments = new ArrayList<Comment>(space.getComments());
                comments.remove(startToken);
                context.collectedElements.add(new ExtractionContext.CollectedElement(templateDepth, (J)((J)this.getCursor().getTree()).withPrefix(space.withComments(comments))));
            } else if (context.collectElements && !context.collectedIds.contains(this.getCursor().getTree().getId())) {
                context.collectedElements.add(new ExtractionContext.CollectedElement(templateDepth, (J)this.getCursor().getTree()));
                context.collectedIds.add(this.getCursor().getTree().getId());
            }
            return space;
        }

        @Nullable
        private Comment findMarker(@Nullable Space space, String marker) {
            if (space == null) {
                return null;
            }
            return space.getComments().stream().filter(c -> Comment.Style.BLOCK.equals((Object)c.getStyle())).filter(c -> c.getText().equals(marker)).findAny().orElse(null);
        }
    }

    private static class ExtractionContext {
        boolean collectElements = false;
        List<CollectedElement> collectedElements = new ArrayList<CollectedElement>();
        Set<UUID> collectedIds = new HashSet<UUID>();
        long startDepth = 0L;

        private ExtractionContext() {
        }

        public <J2 extends J> List<J2> getSnippets() {
            return this.collectedElements.stream().filter(e -> e.depth == this.startDepth).map(e -> e.element).collect(Collectors.toList());
        }

        private static class CollectedElement {
            final long depth;
            final J element;

            CollectedElement(long depth, J element) {
                this.depth = depth;
                this.element = element;
            }
        }
    }

    private static class TemplatePrinter
    extends JavaPrinter<String> {
        private final Set<String> imports;

        TemplatePrinter(final boolean after, final boolean memberVariableInitializer, final Cursor insertionScope, Set<String> imports) {
            super(new TreePrinter<String>(){

                public String doLast(Tree tree, String printed, String printedTemplate) {
                    String blockEnd;
                    String blockStart = memberVariableInitializer ? "{" : "";
                    String string = blockEnd = memberVariableInitializer ? "}" : "";
                    if (insertionScope.getTree().getId().equals(tree.getId())) {
                        String templateCode = blockStart + "/*" + JavaTemplate.SNIPPET_MARKER_START + "*/" + printedTemplate + "/*" + JavaTemplate.SNIPPET_MARKER_END + "*/" + blockEnd;
                        printed = after ? printed + (insertionScope.getParentOrThrow().getTree() instanceof J.Block ? ";" : "") + templateCode : templateCode + printed;
                    }
                    return printed;
                }
            });
            this.imports = imports;
        }

        @Override
        public String visitCompilationUnit(J.CompilationUnit cu, String acc) {
            String originalImports = super.visit(cu.getImports(), ";", acc);
            StringBuilder output = new StringBuilder(originalImports.length() + acc.length() + 1024);
            output.append(originalImports);
            if (!cu.getImports().isEmpty()) {
                output.append(";\n");
            }
            for (String i : this.imports) {
                output.append(i);
            }
            return output.append(this.visit(cu.getClasses(), acc)).append(this.visit(cu.getEof())).toString();
        }
    }

    private static class TemplateProcessor
    extends JavaIsoProcessor<Cursor> {
        TemplateProcessor() {
            this.setCursoringOn();
        }

        @Override
        public J.Block visitBlock(J.Block block, Cursor insertionScope) {
            Cursor parent = this.getCursor().getParent();
            if (parent != null && !(parent.getTree() instanceof J.ClassDecl) && insertionScope.isScopeInPath((Tree)block)) {
                J.Block b;
                b = b.withStatik((b = (J.Block)this.call(block, insertionScope, (arg_0, arg_1) -> ((TemplateProcessor)this).visitEach(arg_0, arg_1))).getStatic() != null ? this.visitSpace(b.getStatic(), insertionScope) : null);
                b = b.withPrefix(this.visitSpace(b.getPrefix(), insertionScope));
                if ((b = (J.Block)this.call(b, insertionScope, this::visitStatement)).getStatements().stream().anyMatch(s -> insertionScope.isScopeInPath((Tree)s.getElem()))) {
                    ArrayList<JRightPadded<Statement>> statementsInScope = new ArrayList<JRightPadded<Statement>>();
                    for (JRightPadded<Statement> statement : b.getStatements()) {
                        statementsInScope.add(this.call(statement, insertionScope));
                        if (!insertionScope.isScopeInPath((Tree)statement.getElem())) continue;
                        break;
                    }
                    return b.withStatements(statementsInScope);
                }
            } else if (parent != null && parent.getTree() instanceof J.ClassDecl) {
                return super.visitBlock(block, insertionScope);
            }
            return block.withStatements(Collections.emptyList());
        }

        @Override
        public J.MethodDecl visitMethod(J.MethodDecl method, Cursor insertionScope) {
            if (insertionScope.isScopeInPath((Tree)method)) {
                return super.visitMethod(method, insertionScope);
            }
            return method.withAnnotations(Collections.emptyList()).withBody(null);
        }

        @Override
        public J.VariableDecls.NamedVar visitVariable(J.VariableDecls.NamedVar variable, Cursor insertionScope) {
            variable = !insertionScope.isScopeInPath((Tree)variable) ? variable.withInitializer(null) : variable.withName(variable.getName().withName("_" + variable.getSimpleName()));
            return super.visitVariable(variable, insertionScope);
        }
    }
}

