/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class ImplementInterface<P>
extends JavaIsoProcessor<P> {
    private final J.ClassDecl scope;
    private final JavaType.FullyQualified interfaceType;

    public ImplementInterface(J.ClassDecl scope, JavaType.FullyQualified interfaceType) {
        this.scope = scope;
        this.interfaceType = interfaceType;
    }

    public ImplementInterface(J.ClassDecl scope, String interfaze) {
        this(scope, JavaType.Class.build(interfaze));
    }

    @Override
    public J.ClassDecl visitClassDecl(J.ClassDecl classDecl, P p) {
        J c = super.visitClassDecl(classDecl, (Object)p);
        if (c.isScope(this.scope) && (((J.ClassDecl)c).getImplements() == null || ((J.ClassDecl)c).getImplements().getElem().stream().noneMatch(f -> this.interfaceType.equals(((TypeTree)f.getElem()).getType())))) {
            this.maybeAddImport(this.interfaceType);
            JRightPadded<J.Ident> lifeCycle = new JRightPadded<J.Ident>(J.Ident.build(Tree.randomId(), Space.format(" "), Markers.EMPTY, this.interfaceType.getClassName(), this.interfaceType), Space.EMPTY);
            if (((J.ClassDecl)c).getImplements() == null) {
                c = ((J.ClassDecl)c).withImplements(JContainer.build(Space.format(" "), Collections.singletonList(lifeCycle)));
            } else {
                ArrayList implementings = new ArrayList(((J.ClassDecl)c).getImplements().getElem());
                implementings.add(0, lifeCycle);
                c = ((J.ClassDecl)c).withImplements(((J.ClassDecl)c).getImplements().withElem(implementings));
            }
        }
        return c;
    }
}

