/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class ShiftFormatRightVisitor
extends JavaIsoRefactorVisitor {
    private final Tree scope;
    private final String shift;

    public ShiftFormatRightVisitor(Tree scope, int shift, boolean isIndentedWithSpaces) {
        this.scope = scope;
        this.shift = IntStream.range(0, shift).mapToObj(n -> isIndentedWithSpaces ? " " : "\t").collect(Collectors.joining(""));
        this.setCursoringOn();
    }

    @Override
    public J.MethodDecl visitMethod(J.MethodDecl method) {
        J.MethodDecl m = super.visitMethod(method);
        if (this.getCursor().isScopeInPath(this.scope)) {
            m = (J.MethodDecl)m.withPrefix(m.getPrefix() + this.shift);
        }
        return m;
    }

    @Override
    public J.If.Else visitElse(J.If.Else elze) {
        J.If.Else e = super.visitElse(elze);
        if (this.getCursor().isScopeInPath(this.scope) && this.isOnOwnLine(elze)) {
            e = (J.If.Else)e.withPrefix(e.getPrefix() + this.shift);
        }
        return e;
    }

    @Override
    public Statement visitStatement(Statement statement) {
        Statement s = super.visitStatement(statement);
        if (this.getCursor().isScopeInPath(this.scope) && this.isOnOwnLine(statement)) {
            s = (Statement)s.withPrefix(s.getPrefix() + this.shift);
        }
        return s;
    }

    @Override
    public J.Block<J> visitBlock(J.Block<J> block) {
        J.Block b = super.visitBlock((J.Block)block);
        if (this.getCursor().isScopeInPath(this.scope)) {
            J.Block.End end = b.getEnd();
            b = b.withEnd(end.withFormatting(end.getFormatting().withPrefix(end.getPrefix() + this.shift)));
        }
        return b;
    }

    @Override
    public J.NewArray visitNewArray(J.NewArray newArray) {
        String suffix;
        J.NewArray n = super.visitNewArray(newArray);
        if (n.getInitializer() != null && (suffix = Formatting.lastSuffix(n.getInitializer().getElements())).contains("\n")) {
            List elements = Formatting.formatLastSuffix(n.getInitializer().getElements(), (String)(suffix + this.shift));
            n = n.withInitializer(n.getInitializer().withElements(elements.stream().map(e -> (Expression)e.withPrefix(e.getPrefix() + this.shift)).collect(Collectors.toList())));
        }
        return n;
    }

    private boolean isOnOwnLine(Tree tree) {
        AtomicBoolean takeWhile = new AtomicBoolean(true);
        return tree.getPrefix().chars().filter(c -> {
            takeWhile.set(takeWhile.get() && (c == 10 || c == 13));
            return takeWhile.get();
        }).count() > 0L;
    }
}

