/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

public final class AddAnnotation {
    private AddAnnotation() {
    }

    public static class Scoped
    extends JavaIsoRefactorVisitor {
        private final Tree scope;
        private final JavaType.Class annotationType;
        private final List<Expression> arguments;

        public Scoped(Tree scope, String annotationTypeName, Expression ... arguments) {
            this.scope = scope;
            this.annotationType = JavaType.Class.build(annotationTypeName);
            this.arguments = Arrays.asList(arguments);
            this.setCursoringOn();
        }

        public Iterable<Tag> getTags() {
            return Tags.of((String)"annotation.type", (String)this.annotationType.getFullyQualifiedName());
        }

        @Override
        public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl c = super.visitClassDecl(classDecl);
            if (this.scope.isScope((Tree)classDecl)) {
                String prefix = c.getAnnotations().isEmpty() ? (c.getModifiers().isEmpty() ? c.getKind().getPrefix() : Formatting.firstPrefix(c.getModifiers())) : Formatting.firstPrefix(c.getAnnotations());
                J.Annotation newAnnot = this.buildAnnotation(Formatting.format((String)prefix));
                ArrayList<J.Annotation> annots = new ArrayList<J.Annotation>(c.getAnnotations());
                if (annots.stream().noneMatch(ann -> (Boolean)new SemanticallyEqual(newAnnot).visit((Tree)ann))) {
                    annots.add(newAnnot);
                    c = c.withAnnotations(annots);
                }
                this.maybeAddImport(this.annotationType.getFullyQualifiedName());
                this.andThen((RefactorVisitor)new AutoFormat(c));
            }
            return c;
        }

        @Override
        public J.VariableDecls visitMultiVariable(J.VariableDecls multiVariable) {
            J.VariableDecls v = super.visitMultiVariable(multiVariable);
            if (this.scope.isScope((Tree)multiVariable)) {
                List<J.Modifier> modifiers;
                Formatting formatting = !v.getAnnotations().isEmpty() ? v.getAnnotations().get(0).getFormatting() : (!v.getModifiers().isEmpty() ? v.getModifiers().get(0).getFormatting() : Formatting.EMPTY);
                J.Annotation newAnnot = this.buildAnnotation(formatting);
                ArrayList<J.Annotation> annots = new ArrayList<J.Annotation>(v.getAnnotations());
                if (annots.stream().noneMatch(ann -> (Boolean)new SemanticallyEqual(newAnnot).visit((Tree)ann))) {
                    annots.add(newAnnot);
                    v = v.withAnnotations(annots);
                }
                if (!(modifiers = v.getModifiers()).isEmpty() && modifiers.get(0).getPrefix().isEmpty()) {
                    modifiers.set(0, (J.Modifier)modifiers.get(0).withPrefix(" "));
                    v = v.withModifiers(modifiers);
                } else if (v.getTypeExpr().getPrefix().isEmpty()) {
                    v = v.withTypeExpr((TypeTree)v.getTypeExpr().withPrefix(" "));
                }
                this.maybeAddImport(this.annotationType.getFullyQualifiedName());
                this.andThen((RefactorVisitor)new AutoFormat(v));
            }
            return v;
        }

        @Override
        public J.MethodDecl visitMethod(J.MethodDecl method) {
            J.MethodDecl m = super.visitMethod(method);
            if (this.scope.isScope((Tree)method)) {
                String prefix = m.getAnnotations().isEmpty() ? (m.getTypeParameters() == null ? (m.getModifiers().isEmpty() ? (m.getReturnTypeExpr() == null ? m.getName() : m.getReturnTypeExpr()).getPrefix() : Formatting.firstPrefix(m.getModifiers())) : m.getTypeParameters().getPrefix()) : Formatting.firstPrefix(m.getAnnotations());
                J.Annotation newAnnot = this.buildAnnotation(Formatting.format((String)prefix));
                ArrayList<J.Annotation> annots = new ArrayList<J.Annotation>(m.getAnnotations());
                if (annots.stream().noneMatch(ann -> (Boolean)new SemanticallyEqual(newAnnot).visit((Tree)ann))) {
                    annots.add(newAnnot);
                    m = m.withAnnotations(annots);
                }
                this.maybeAddImport(this.annotationType.getFullyQualifiedName());
                this.andThen((RefactorVisitor)new AutoFormat(m));
            }
            return m;
        }

        private J.Annotation buildAnnotation(Formatting formatting) {
            return J.Annotation.buildAnnotation(formatting, this.annotationType, this.arguments);
        }
    }
}

