/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.Optional;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.tree.J;

public class OrderImports
extends JavaIsoRefactorVisitor {
    private boolean removeUnused = true;

    public void setRemoveUnused(boolean removeUnused) {
        this.removeUnused = removeUnused;
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu) {
        ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(ImportLayoutStyle.getDefaultImportLayoutStyle());
        List<J.Import> orderedImports = layoutStyle.orderImports(cu.getImports());
        if (orderedImports.size() != cu.getImports().size()) {
            return cu.withImports(orderedImports);
        }
        for (int i = 0; i < orderedImports.size(); ++i) {
            if (orderedImports.get(i) == cu.getImports().get(i)) continue;
            return cu.withImports(orderedImports);
        }
        if (this.removeUnused) {
            this.andThen((RefactorVisitor)new RemoveUnusedImports());
        }
        return cu;
    }
}

