/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaStyle;
import org.openrewrite.java.style.ModifierComparator;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class DeclarationOrderStyle
implements JavaStyle {
    private Map<String, Object> layout;

    @JsonProperty(value="layout")
    public void setLayout(Map<String, Object> layout) {
        this.layout = layout;
    }

    public Layout getLayout() {
        Layout.Builder builder = Layout.builder();
        for (String block : (List)this.layout.get("blocks")) {
            String[] modifiers;
            if ((block = block.trim()).equals("<blank line>")) {
                builder = builder.blankLine();
                continue;
            }
            if (block.endsWith("fields")) {
                if (block.equals("all other fields")) {
                    builder = builder.allOtherFields();
                    continue;
                }
                modifiers = block.substring(0, block.length() - "fields".length()).split("\\s+");
                builder = builder.fields(modifiers);
                continue;
            }
            if (block.endsWith("classes")) {
                if (block.equals("all other classes")) {
                    builder = builder.allOtherClasses();
                    continue;
                }
                modifiers = block.substring(0, block.length() - "classes".length()).split("\\s+");
                builder = builder.classes(modifiers);
                continue;
            }
            if (block.endsWith("methods")) {
                if (block.equals("all other methods")) {
                    builder = builder.allOtherMethods();
                    continue;
                }
                modifiers = block.substring(0, block.length() - "methods".length()).split("\\s+");
                builder = builder.methods(modifiers);
                continue;
            }
            if (block.endsWith("constructors")) {
                if (block.equals("all other constructors")) {
                    builder = builder.allOtherConstructors();
                    continue;
                }
                modifiers = block.substring(0, block.length() - "constructors".length()).split("\\s+");
                builder = builder.constructors(modifiers);
                continue;
            }
            if (block.equals("all getters")) {
                builder = builder.allGetters();
                continue;
            }
            if (block.equals("all setters")) {
                builder = builder.allSetters();
                continue;
            }
            if (block.equals("all withs")) {
                builder = builder.allWiths();
                continue;
            }
            if (block.equals("all accessors")) {
                builder = builder.allAccessors();
                continue;
            }
            if (block.equals("equals")) {
                builder = builder.equals();
                continue;
            }
            if (block.equals("hashCode")) {
                builder = builder.hashCoding();
                continue;
            }
            if (!block.equals("toString")) continue;
            builder = builder.toStringing();
        }
        return builder.build();
    }

    public static class Layout {
        public static Layout DEFAULT = Layout.builder().fields("public", "static").blankLine().fields("private", "static").blankLine().fields("final").blankLine().allOtherFields().blankLine().allOtherConstructors().blankLine().allOtherMethods().blankLine().allAccessors().blankLine().equals().blankLine().hashCoding().blankLine().toStringing().blankLine().allOtherClasses().build();
        private final List<Block<?>> blocks;
        private final List<Block<?>> blocksByPrecedence;

        Layout(List<Block<?>> blocks) {
            this.blocks = blocks;
            this.blocksByPrecedence = new ArrayList();
            blocks.stream().filter(b -> !(b instanceof Block.BlankLines)).forEach(this.blocksByPrecedence::add);
            this.blocksByPrecedence.sort(new Comparator<Block<?>>(){

                @Override
                public int compare(Block<?> b1, Block<?> b2) {
                    if (b1 instanceof Block.Methods) {
                        if (b2 instanceof Block.Methods) {
                            return this.methodTypeRank(b1) - this.methodTypeRank(b2);
                        }
                        return 1;
                    }
                    return ModifierComparator.BY_STRING.compare(b1.requiredModifiers, b2.requiredModifiers);
                }

                private int methodTypeRank(Block<?> b) {
                    if (b instanceof Block.Getters) {
                        return 1;
                    }
                    if (b instanceof Block.Setters) {
                        return 2;
                    }
                    if (b instanceof Block.Withs) {
                        return 3;
                    }
                    if (b instanceof Block.Accessors) {
                        return 4;
                    }
                    if (b instanceof Block.ToString) {
                        return 5;
                    }
                    if (b instanceof Block.HashCode) {
                        return 6;
                    }
                    if (b instanceof Block.Equals) {
                        return 7;
                    }
                    return 8;
                }
            });
        }

        public void reset() {
            for (Block<?> block : this.blocks) {
                block.reset();
            }
        }

        public void accept(J declaration) {
            for (Block<?> block : this.blocksByPrecedence) {
                if (!block.accept(declaration)) continue;
                return;
            }
        }

        public List<J> orderedDeclarations() {
            ArrayList<J> orderedDeclarations = new ArrayList<J>();
            AtomicInteger blankLines = new AtomicInteger(0);
            for (Block<?> block : this.blocks) {
                System.out.println(block);
                if (block instanceof Block.BlankLines) {
                    blankLines.addAndGet(((Block.BlankLines)block).count);
                    continue;
                }
                AtomicBoolean first = new AtomicBoolean(true);
                orderedDeclarations.addAll(block.orderedDeclarations().stream().peek(declaration -> System.out.println("  " + declaration.toString())).map(declaration -> {
                    if (first.getAndSet(false)) {
                        return (J)declaration.withFormatting(declaration.getFormatting().withMinimumBlankLines(blankLines.getAndSet(0)));
                    }
                    if (declaration instanceof J.MethodDecl) {
                        return (J)declaration.withFormatting(declaration.getFormatting().withMinimumBlankLines(1));
                    }
                    return declaration;
                }).collect(Collectors.toList()));
                blankLines.set(0);
            }
            return orderedDeclarations;
        }

        public Validated validate() {
            return Validated.test((String)"accessors", (String)"'all accessors' can only be used when 'all getters', 'all setters', or 'all with' are not", this.blocks, blocks2 -> blocks2.stream().filter(b -> b instanceof Block.Getters || b instanceof Block.Setters || b instanceof Block.Withs).findAny().map(conflicting -> this.blocks.stream().noneMatch(b -> b instanceof Block.Accessors)).orElse(true)).and(Validated.test((String)"accessors", (String)"only one 'all accessors' permitted", this.blocks, blocks2 -> blocks2.stream().filter(b -> b instanceof Block.Accessors).count() == 1L)).and(Validated.test((String)"getters", (String)"only one 'all getters' permitted", this.blocks, blocks2 -> blocks2.stream().filter(b -> b instanceof Block.Getters).count() == 1L)).and(Validated.test((String)"setters", (String)"only one 'all setters' permitted", this.blocks, blocks2 -> blocks2.stream().filter(b -> b instanceof Block.Setters).count() == 1L)).and(Validated.test((String)"withs", (String)"only one 'all withs' permitted", this.blocks, blocks2 -> blocks2.stream().filter(b -> b instanceof Block.Withs).count() == 1L));
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private final List<Block<? extends J>> blocks = new ArrayList<Block<? extends J>>();

            public Builder fields(String ... modifiers) {
                this.blocks.add(new Block.Fields(Arrays.asList(modifiers)));
                return this;
            }

            public Builder allOtherFields() {
                this.blocks.add(new Block.Fields(Collections.emptyList()));
                return this;
            }

            public Builder classes(String ... modifiers) {
                this.blocks.add(new Block.Classes(Arrays.asList(modifiers)));
                return this;
            }

            public Builder allOtherClasses() {
                this.blocks.add(new Block.Classes(Collections.emptyList()));
                return this;
            }

            public Builder methods(String ... modifiers) {
                this.blocks.add(new Block.Methods(Arrays.asList(modifiers)));
                return this;
            }

            public Builder allOtherMethods() {
                this.blocks.add(new Block.Methods(Collections.emptyList()));
                return this;
            }

            public Builder constructors(String ... modifiers) {
                this.blocks.add(new Block.Constructors(Arrays.asList(modifiers)));
                return this;
            }

            public Builder allOtherConstructors() {
                this.blocks.add(new Block.Constructors(Collections.emptyList()));
                return this;
            }

            public Builder allGetters() {
                this.blocks.add(new Block.Getters());
                return this;
            }

            public Builder allSetters() {
                this.blocks.add(new Block.Setters());
                return this;
            }

            public Builder allWiths() {
                this.blocks.add(new Block.Withs());
                return this;
            }

            public Builder allAccessors() {
                this.blocks.add(new Block.Accessors());
                return this;
            }

            public Builder equals() {
                this.blocks.add(new Block.Equals());
                return this;
            }

            public Builder hashCoding() {
                this.blocks.add(new Block.HashCode());
                return this;
            }

            public Builder toStringing() {
                this.blocks.add(new Block.ToString());
                return this;
            }

            public Builder blankLine() {
                if (!this.blocks.isEmpty() && this.blocks.get(this.blocks.size() - 1) instanceof Block.BlankLines) {
                    ((Block.BlankLines)this.blocks.get(this.blocks.size() - 1)).count++;
                } else {
                    this.blocks.add(new Block.BlankLines());
                }
                return this;
            }

            public Layout build() {
                return new Layout(this.blocks);
            }
        }

        private static abstract class Block<T extends J> {
            final List<String> requiredModifiers;
            @Nullable
            final Comparator<T> comparator;
            final List<T> matched = new ArrayList<T>();

            protected Block(List<String> requiredModifiers, @Nullable Comparator<T> comparator) {
                this.requiredModifiers = requiredModifiers;
                this.comparator = comparator;
            }

            abstract boolean accept(J var1);

            final void reset() {
                this.matched.clear();
            }

            List<? extends J> orderedDeclarations() {
                if (this.comparator != null) {
                    this.matched.sort(this.comparator);
                }
                return this.matched;
            }

            static class HashCode
            extends Methods {
                public HashCode() {
                    super(Collections.singletonList("public"));
                }

                @Override
                public boolean test(J declaration) {
                    if (!super.test(declaration)) {
                        return false;
                    }
                    J.MethodDecl method = (J.MethodDecl)declaration;
                    return method.getSimpleName().equals("hashCode") && method.getParams().isEmpty();
                }

                @Override
                public String toString() {
                    return "hashCode";
                }
            }

            static class ToString
            extends Methods {
                public ToString() {
                    super(Collections.singletonList("public"));
                }

                @Override
                public boolean test(J declaration) {
                    if (!super.test(declaration)) {
                        return false;
                    }
                    J.MethodDecl method = (J.MethodDecl)declaration;
                    return method.getSimpleName().equals("toString") && method.getParams().isEmpty();
                }

                @Override
                public String toString() {
                    return "toString";
                }
            }

            static class Equals
            extends Methods {
                public Equals() {
                    super(Collections.singletonList("public"));
                }

                @Override
                public boolean test(J declaration) {
                    if (!super.test(declaration)) {
                        return false;
                    }
                    J.MethodDecl method = (J.MethodDecl)declaration;
                    if (!method.getSimpleName().equals("equals")) {
                        return false;
                    }
                    List<Statement> params = method.getParams().getParams();
                    return params.size() == 1;
                }

                @Override
                List<? extends J> orderedDeclarations() {
                    return super.orderedDeclarations();
                }

                @Override
                public String toString() {
                    return "equals";
                }
            }

            static class Accessors
            extends Methods {
                private final Getters getters = new Getters();
                private final Setters setters = new Setters();
                private final Withs withs = new Withs();

                public Accessors() {
                    super(Collections.emptyList());
                }

                @Override
                public boolean test(J declaration) {
                    return this.getters.test(declaration) || this.setters.test(declaration) || this.withs.test(declaration);
                }

                @Override
                public String toString() {
                    return "all accessors";
                }
            }

            static class Withs
            extends Methods {
                public Withs() {
                    super(Collections.singletonList("public"));
                }

                @Override
                public boolean test(J declaration) {
                    return super.test(declaration) && ((J.MethodDecl)declaration).getSimpleName().startsWith("with");
                }

                @Override
                public String toString() {
                    return "all withs";
                }
            }

            static class Setters
            extends Methods {
                public Setters() {
                    super(Collections.singletonList("public"));
                }

                @Override
                public boolean test(J declaration) {
                    return super.test(declaration) && ((J.MethodDecl)declaration).getSimpleName().startsWith("set");
                }

                @Override
                public String toString() {
                    return "all setters";
                }
            }

            static class Getters
            extends Methods {
                public Getters() {
                    super(Collections.singletonList("public"));
                }

                @Override
                public boolean test(J declaration) {
                    return super.test(declaration) && ((J.MethodDecl)declaration).getSimpleName().startsWith("get");
                }

                @Override
                public String toString() {
                    return "all getters";
                }
            }

            static class Constructors
            extends Block<J.MethodDecl> {
                public Constructors(List<String> requiredModifiers) {
                    super(requiredModifiers, (m1, m2) -> {
                        int modComp = ModifierComparator.BY_AST.compare(m1.getModifiers(), m2.getModifiers());
                        if (modComp != 0) {
                            return modComp;
                        }
                        return m1.getSimpleName().compareTo(m2.getSimpleName());
                    });
                }

                @Override
                public boolean accept(J declaration) {
                    if (declaration instanceof J.MethodDecl) {
                        if (this.requiredModifiers.stream().allMatch(((J.MethodDecl)declaration)::hasModifier) && ((J.MethodDecl)declaration).isConstructor()) {
                            this.matched.add((J.MethodDecl)declaration);
                            return true;
                        }
                    }
                    return false;
                }

                public String toString() {
                    return (this.requiredModifiers.isEmpty() ? "all other" : String.join((CharSequence)" ", this.requiredModifiers)) + " constructors";
                }
            }

            static class Methods
            extends Block<J.MethodDecl> {
                public Methods(List<String> requiredModifiers) {
                    super(requiredModifiers, (m1, m2) -> {
                        int modComp = ModifierComparator.BY_AST.compare(m1.getModifiers(), m2.getModifiers());
                        if (modComp != 0) {
                            return modComp;
                        }
                        return m1.getSimpleName().compareTo(m2.getSimpleName());
                    });
                }

                @Override
                public boolean accept(J declaration) {
                    if (this.test(declaration)) {
                        this.matched.add((J.MethodDecl)declaration);
                        return true;
                    }
                    return false;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean test(J declaration) {
                    if (!(declaration instanceof J.MethodDecl)) return false;
                    if (((J.MethodDecl)declaration).isConstructor()) return false;
                    if (!this.requiredModifiers.stream().allMatch(((J.MethodDecl)declaration)::hasModifier)) return false;
                    return true;
                }

                public String toString() {
                    return (this.requiredModifiers.isEmpty() ? "all other" : String.join((CharSequence)" ", this.requiredModifiers)) + " methods";
                }
            }

            static class Classes
            extends Block<J.ClassDecl> {
                public Classes(List<String> requiredModifiers) {
                    super(requiredModifiers, (c1, c2) -> {
                        int modComp = ModifierComparator.BY_AST.compare(c1.getModifiers(), c2.getModifiers());
                        if (modComp != 0) {
                            return modComp;
                        }
                        return c1.getSimpleName().compareTo(c2.getSimpleName());
                    });
                }

                @Override
                public boolean accept(J declaration) {
                    if (declaration instanceof J.ClassDecl) {
                        if (this.requiredModifiers.stream().allMatch(((J.ClassDecl)declaration)::hasModifier)) {
                            this.matched.add((J.ClassDecl)declaration);
                            return true;
                        }
                    }
                    return false;
                }

                public String toString() {
                    return (this.requiredModifiers.isEmpty() ? "all other" : String.join((CharSequence)" ", this.requiredModifiers)) + " classes";
                }
            }

            static class Fields
            extends Block<J.VariableDecls> {
                public Fields(List<String> requiredModifiers) {
                    super(requiredModifiers, (f1, f2) -> {
                        int modComp = ModifierComparator.BY_AST.compare(f1.getModifiers(), f2.getModifiers());
                        if (modComp != 0) {
                            return modComp;
                        }
                        return f1.getVars().get(0).getSimpleName().compareTo(f2.getVars().get(0).getSimpleName());
                    });
                }

                @Override
                public boolean accept(J declaration) {
                    if (declaration instanceof J.VariableDecls) {
                        if (this.requiredModifiers.stream().allMatch(((J.VariableDecls)declaration)::hasModifier)) {
                            this.matched.add((J.VariableDecls)declaration);
                            return true;
                        }
                    }
                    return false;
                }

                public String toString() {
                    return (this.requiredModifiers.isEmpty() ? "all other" : String.join((CharSequence)" ", this.requiredModifiers)) + " fields";
                }
            }

            static class BlankLines
            extends Block<J> {
                private int count = 1;

                BlankLines() {
                    super(Collections.emptyList(), null);
                }

                @Override
                public boolean accept(J declaration) {
                    return false;
                }

                public String toString() {
                    return "<blank line>";
                }
            }
        }
    }
}

