/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.AbstractRefactorVisitor;
import org.openrewrite.Cursor;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaFormatter;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.UnwrapParentheses;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeTree;

public class JavaRefactorVisitor
extends AbstractRefactorVisitor<J>
implements JavaSourceVisitor<J> {
    protected JavaFormatter formatter;
    protected TreeBuilder treeBuilder;

    @Override
    public J visitStatement(Statement statement) {
        return statement;
    }

    @Override
    public J visitTypeName(NameTree name) {
        return name;
    }

    @Override
    public J visitAnnotatedType(J.AnnotatedType annotatedType) {
        J.AnnotatedType a = (J.AnnotatedType)this.refactor(annotatedType, this::visitExpression);
        a = a.withAnnotations(this.refactor(a.getAnnotations()));
        return a.withTypeExpr((TypeTree)this.refactor(a.getTypeExpr()));
    }

    @Override
    public J visitAnnotation(J.Annotation annotation) {
        J.Annotation a;
        a = a.withArgs((J.Annotation.Arguments)this.refactor((a = (J.Annotation)this.refactor(annotation, this::visitExpression)).getArgs() == null ? null : a.getArgs().withArgs(this.refactor(a.getArgs().getArgs()))));
        return a.withAnnotationType((NameTree)this.refactor(a.getAnnotationType()));
    }

    @Override
    public J visitArrayAccess(J.ArrayAccess arrayAccess) {
        J.ArrayAccess a = (J.ArrayAccess)this.refactor(arrayAccess, this::visitExpression);
        a = a.withIndexed((Expression)this.refactor(a.getIndexed()));
        return a.withDimension(a.getDimension().withIndex((Expression)this.refactor(a.getDimension().getIndex())));
    }

    @Override
    public J visitArrayType(J.ArrayType arrayType) {
        J.ArrayType a = arrayType;
        a = a.withDimensions(this.refactor(a.getDimensions()));
        return a.withElementType((TypeTree)this.refactor(a.getElementType()));
    }

    @Override
    public J visitAssert(J.Assert azzert) {
        J.Assert a = (J.Assert)this.refactor(azzert, this::visitStatement);
        return a.withCondition((Expression)this.refactor(a.getCondition()));
    }

    @Override
    public J visitAssign(J.Assign assign) {
        J.Assign a = (J.Assign)this.refactor(assign, this::visitStatement);
        a = (J.Assign)this.refactor(a, this::visitExpression);
        a = a.withVariable((Expression)this.refactor(a.getVariable()));
        return a.withAssignment((Expression)this.refactor(a.getAssignment()));
    }

    @Override
    public J visitAssignOp(J.AssignOp assignOp) {
        J.AssignOp a = (J.AssignOp)this.refactor(assignOp, this::visitStatement);
        a = (J.AssignOp)this.refactor(a, this::visitExpression);
        a = a.withVariable((Expression)this.refactor(a.getVariable()));
        return a.withAssignment((Expression)this.refactor(a.getAssignment()));
    }

    @Override
    public J visitBinary(J.Binary binary) {
        J.Binary b = (J.Binary)this.refactor(binary, this::visitExpression);
        b = b.withLeft((Expression)this.refactor(b.getLeft()));
        return b.withRight((Expression)this.refactor(b.getRight()));
    }

    @Override
    public J visitBlock(J.Block<J> block) {
        J.Block b = (J.Block)this.refactor(block, this::visitStatement);
        b = b.withStatements(this.refactor(b.getStatements()));
        return b.withEnd((J.Block.End)this.refactor(b.getEnd()));
    }

    @Override
    public J visitBreak(J.Break breakStatement) {
        J.Break b = (J.Break)this.refactor(breakStatement, this::visitStatement);
        return b.withLabel((J.Ident)this.refactor(b.getLabel()));
    }

    @Override
    public J visitCase(J.Case caze) {
        J.Case c = (J.Case)this.refactor(caze, this::visitStatement);
        c = c.withPattern((Expression)this.refactor(c.getPattern()));
        return c.withStatements(this.refactor(c.getStatements()));
    }

    @Override
    public J visitCatch(J.Try.Catch catzh) {
        J.Try.Catch c = catzh;
        c = c.withParam((J.Parentheses)this.refactor(c.getParam()));
        return c.withBody((J.Block)this.refactor(c.getBody()));
    }

    @Override
    public J visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl c = (J.ClassDecl)this.refactor(classDecl, this::visitStatement);
        c = c.withAnnotations(this.refactor(c.getAnnotations()));
        c = c.withModifiers(this.refactor(c.getModifiers()));
        c = c.withTypeParameters((J.TypeParameters)this.refactor(c.getTypeParameters()));
        c = c.withKind((J.ClassDecl.Kind)this.refactor(c.getKind()));
        c = c.withName((J.Ident)this.refactor(c.getName()));
        if ((c = c.withExtends((J.ClassDecl.Extends)this.refactor(c.getExtends()))).getExtends() != null) {
            c = c.withExtends(c.getExtends().withFrom((TypeTree)this.refactor(c.getExtends().getFrom())));
        }
        if ((c = c.withImplements((J.ClassDecl.Implements)this.refactor(c.getImplements()))).getImplements() != null) {
            c = c.withImplements(c.getImplements().withFrom(this.refactor(c.getImplements().getFrom())));
        }
        return c.withBody((J.Block)this.refactor(c.getBody()));
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu) {
        this.formatter = new JavaFormatter(cu);
        this.treeBuilder = new TreeBuilder(cu);
        J.CompilationUnit c = cu;
        c = c.withPackageDecl((J.Package)this.refactor(c.getPackageDecl()));
        c = c.withImports(this.refactor(c.getImports()));
        return c.withClasses(this.refactor(c.getClasses()));
    }

    @Override
    public J visitContinue(J.Continue continueStatement) {
        J.Continue c = (J.Continue)this.refactor(continueStatement, this::visitStatement);
        return c.withLabel((J.Ident)this.refactor(c.getLabel()));
    }

    @Override
    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop) {
        J.DoWhileLoop d = (J.DoWhileLoop)this.refactor(doWhileLoop, this::visitStatement);
        d = d.withWhileCondition((J.DoWhileLoop.While)this.refactor(d.getWhileCondition()));
        return d.withBody((Statement)this.refactor(d.getBody()));
    }

    @Override
    public J visitEmpty(J.Empty empty) {
        J.Empty e = (J.Empty)this.refactor(empty, this::visitStatement);
        e = (J.Empty)this.refactor(e, this::visitExpression);
        return e;
    }

    @Override
    public J visitEnumValue(J.EnumValue enoom) {
        J.EnumValue e = (J.EnumValue)this.refactor(enoom, this::visitStatement);
        e = e.withName((J.Ident)this.refactor(e.getName()));
        return e.withInitializer((J.NewClass)this.refactor(e.getInitializer()));
    }

    @Override
    public J visitEnumValueSet(J.EnumValueSet enums) {
        J.EnumValueSet e = (J.EnumValueSet)this.refactor(enums, this::visitStatement);
        return e.withEnums(this.refactor(e.getEnums()));
    }

    @Override
    public J visitFieldAccess(J.FieldAccess fieldAccess) {
        J.FieldAccess f = (J.FieldAccess)this.refactor(fieldAccess, this::visitExpression);
        f = f.withTarget((Expression)this.refactor(f.getTarget()));
        return f.withName((J.Ident)this.refactor(f.getName()));
    }

    @Override
    public J visitFinally(J.Try.Finally finallie) {
        return finallie.withBody((J.Block)this.refactor(finallie.getBody()));
    }

    @Override
    public J visitForEachLoop(J.ForEachLoop forLoop) {
        J.ForEachLoop f = (J.ForEachLoop)this.refactor(forLoop, this::visitStatement);
        f = f.withControl(f.getControl().withVariable((J.VariableDecls)this.refactor(f.getControl().getVariable())));
        f = f.withControl(f.getControl().withIterable((Expression)this.refactor(f.getControl().getIterable())));
        return f.withBody((Statement)this.refactor(f.getBody()));
    }

    @Override
    public J visitForLoop(J.ForLoop forLoop) {
        J.ForLoop f = (J.ForLoop)this.refactor(forLoop, this::visitStatement);
        f = f.withControl(f.getControl().withInit((Statement)this.refactor(f.getControl().getInit())));
        f = f.withControl(f.getControl().withCondition((Expression)this.refactor(f.getControl().getCondition())));
        f = f.withControl(f.getControl().withUpdate(this.refactor(f.getControl().getUpdate())));
        return f.withBody((Statement)this.refactor(f.getBody()));
    }

    @Override
    public J visitIdentifier(J.Ident ident) {
        return (J)this.refactor(ident, this::visitExpression);
    }

    @Override
    public J visitIf(J.If iff) {
        J.If i = (J.If)this.refactor(iff, this::visitStatement);
        i = i.withIfCondition((J.Parentheses)this.refactor(i.getIfCondition()));
        i = i.withThenPart((Statement)this.refactor(i.getThenPart()));
        return i.withElsePart((J.If.Else)this.refactor(i.getElsePart()));
    }

    @Override
    public J visitElse(J.If.Else elze) {
        return elze.withStatement((Statement)this.refactor(elze.getStatement()));
    }

    @Override
    public J visitImport(J.Import impoort) {
        return impoort.withQualid((J.FieldAccess)this.refactor(impoort.getQualid()));
    }

    @Override
    public J visitInstanceOf(J.InstanceOf instanceOf) {
        J.InstanceOf i = (J.InstanceOf)this.refactor(instanceOf, this::visitExpression);
        i = i.withExpr((Expression)this.refactor(i.getExpr()));
        return i.withClazz(this.refactor(i.getClazz()));
    }

    @Override
    public J visitLabel(J.Label label) {
        J.Label l = (J.Label)this.refactor(label, this::visitStatement);
        return l.withStatement((Statement)this.refactor(l.getStatement()));
    }

    @Override
    public J visitLambda(J.Lambda lambda) {
        J.Lambda l = (J.Lambda)this.refactor(lambda, this::visitExpression);
        l = l.withParamSet((J.Lambda.Parameters)this.refactor(l.getParamSet()));
        l = l.withArrow((J.Lambda.Arrow)this.refactor(l.getArrow()));
        return l.withBody(this.refactor(l.getBody()));
    }

    @Override
    public J visitLiteral(J.Literal literal) {
        return (J)this.refactor(literal, this::visitExpression);
    }

    @Override
    public J visitMemberReference(J.MemberReference memberRef) {
        J.MemberReference m = memberRef;
        m = m.withContaining((Expression)this.refactor(m.getContaining()));
        m = m.withTypeParameters((J.TypeParameters)this.refactor(m.getTypeParameters()));
        return m.withReference((J.Ident)this.refactor(m.getReference()));
    }

    @Override
    public J visitMethod(J.MethodDecl method) {
        J.MethodDecl m = method;
        m = m.withAnnotations(this.refactor(m.getAnnotations()));
        m = m.withModifiers(this.refactor(m.getModifiers()));
        m = m.withTypeParameters((J.TypeParameters)this.refactor(m.getTypeParameters()));
        m = m.withReturnTypeExpr((TypeTree)this.refactor(m.getReturnTypeExpr()));
        m = m.withName((J.Ident)this.refactor(m.getName()));
        m = m.withParams((J.MethodDecl.Parameters)this.refactor(m.getParams()));
        m = m.withParams(m.getParams().withParams(this.refactor(m.getParams().getParams())));
        m = m.withThrows((J.MethodDecl.Throws)this.refactor(m.getThrows()));
        return m.withBody((J.Block)this.refactor(m.getBody()));
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method) {
        J.MethodInvocation m = (J.MethodInvocation)this.refactor(method, this::visitStatement);
        m = (J.MethodInvocation)this.refactor(m, this::visitExpression);
        m = m.withSelect((Expression)this.refactor(m.getSelect()));
        m = m.withTypeParameters((J.TypeParameters)this.refactor(m.getTypeParameters()));
        m = m.withName((J.Ident)this.refactor(m.getName()));
        m = m.withArgs((J.MethodInvocation.Arguments)this.refactor(m.getArgs()));
        return m.withArgs(m.getArgs().withArgs(this.refactor(m.getArgs().getArgs())));
    }

    @Override
    public J visitMultiCatch(J.MultiCatch multiCatch) {
        return multiCatch.withAlternatives(this.refactor(multiCatch.getAlternatives()));
    }

    @Override
    public J visitMultiVariable(J.VariableDecls multiVariable) {
        J.VariableDecls m = (J.VariableDecls)this.refactor(multiVariable, this::visitStatement);
        m = m.withModifiers(this.refactor(m.getModifiers()));
        m = m.withAnnotations(this.refactor(m.getAnnotations()));
        m = m.withTypeExpr((TypeTree)this.refactor(m.getTypeExpr()));
        m = m.withVars(this.refactor(m.getVars()));
        return m.withVarargs((J.VariableDecls.Varargs)this.refactor(m.getVarargs()));
    }

    @Override
    public J visitNewArray(J.NewArray newArray) {
        J.NewArray n = (J.NewArray)this.refactor(newArray, this::visitExpression);
        n = n.withTypeExpr((TypeTree)this.refactor(n.getTypeExpr()));
        return n.withInitializer((J.NewArray.Initializer)this.refactor(n.getInitializer()));
    }

    @Override
    public J visitNewClass(J.NewClass newClass) {
        J.NewClass n = (J.NewClass)this.refactor(newClass, this::visitStatement);
        n = (J.NewClass)this.refactor(n, this::visitExpression);
        n = n.withClazz((TypeTree)this.refactor(n.getClazz()));
        n = n.withArgs((J.NewClass.Arguments)this.refactor(n.getArgs()));
        return n.withBody((J.Block)this.refactor(n.getBody()));
    }

    @Override
    public J visitPackage(J.Package pkg) {
        return pkg.withExpr((Expression)this.refactor(pkg.getExpr()));
    }

    @Override
    public J visitParameterizedType(J.ParameterizedType type) {
        J.ParameterizedType p = (J.ParameterizedType)this.refactor(type, this::visitExpression);
        p = p.withClazz((NameTree)this.refactor(p.getClazz()));
        return p.withTypeParameters((J.TypeParameters)this.refactor(p.getTypeParameters()));
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens) {
        J.Parentheses p = (J.Parentheses)this.refactor(parens, this::visitExpression);
        return p.withTree((J)this.refactor((Tree)p.getTree()));
    }

    @Override
    public J visitPrimitive(J.Primitive primitive) {
        return (J)this.refactor(primitive, this::visitExpression);
    }

    @Override
    public J visitReturn(J.Return retrn) {
        J.Return r = (J.Return)this.refactor(retrn, this::visitStatement);
        return r.withExpr((Expression)this.refactor(r.getExpr()));
    }

    @Override
    public J visitSwitch(J.Switch switzh) {
        J.Switch s = (J.Switch)this.refactor(switzh, this::visitStatement);
        s = s.withSelector((J.Parentheses)this.refactor(s.getSelector()));
        return s.withCases((J.Block)this.refactor(s.getCases()));
    }

    @Override
    public J visitSynchronized(J.Synchronized synch) {
        J.Synchronized s = (J.Synchronized)this.refactor(synch, this::visitStatement);
        s = s.withLock((J.Parentheses)this.refactor(s.getLock()));
        return s.withBody((J.Block)this.refactor(s.getBody()));
    }

    @Override
    public J visitTernary(J.Ternary ternary) {
        J.Ternary t = (J.Ternary)this.refactor(ternary, this::visitExpression);
        t = t.withCondition((Expression)this.refactor(t.getCondition()));
        t = t.withTruePart((Expression)this.refactor(t.getTruePart()));
        return t.withFalsePart((Expression)this.refactor(t.getFalsePart()));
    }

    @Override
    public J visitThrow(J.Throw thrown) {
        J.Throw t = (J.Throw)this.refactor(thrown, this::visitStatement);
        return t.withException((Expression)this.refactor(t.getException()));
    }

    @Override
    public J visitTry(J.Try tryable) {
        J.Try t;
        t = t.withResources((t = (J.Try)this.refactor(tryable, this::visitStatement)).getResources() == null ? null : t.getResources().withDecls(this.refactor(t.getResources().getDecls())));
        t = t.withBody((J.Block)this.refactor(t.getBody()));
        t = t.withCatches(this.refactor(t.getCatches()));
        return t.withFinally((J.Try.Finally)this.refactor(t.getFinally()));
    }

    @Override
    public J visitTypeCast(J.TypeCast typeCast) {
        J.TypeCast t = (J.TypeCast)this.refactor(typeCast, this::visitExpression);
        t = t.withClazz((J.Parentheses)this.refactor(t.getClazz()));
        return t.withExpr((Expression)this.refactor(t.getExpr()));
    }

    @Override
    public J visitTypeParameter(J.TypeParameter typeParam) {
        J.TypeParameter t = typeParam;
        t = t.withAnnotations(this.refactor(t.getAnnotations()));
        return t.withBounds((t = t.withName((Expression)this.refactor(t.getName()))).getBounds() == null ? null : t.getBounds().withTypes(this.refactor(t.getBounds().getTypes())));
    }

    @Override
    public J visitTypeParameters(J.TypeParameters typeParams) {
        return typeParams.withParams(this.refactor(typeParams.getParams()));
    }

    @Override
    public J visitUnary(J.Unary unary) {
        J.Unary u = (J.Unary)this.refactor(unary, this::visitStatement);
        u = (J.Unary)this.refactor(u, this::visitExpression);
        return u.withExpr((Expression)this.refactor(u.getExpr()));
    }

    @Override
    public J visitUnparsedSource(J.UnparsedSource unparsed) {
        J.UnparsedSource u = (J.UnparsedSource)this.refactor(unparsed, this::visitStatement);
        u = (J.UnparsedSource)this.refactor(u, this::visitExpression);
        return u;
    }

    @Override
    public J visitVariable(J.VariableDecls.NamedVar variable) {
        J.VariableDecls.NamedVar v = variable;
        v = v.withName((J.Ident)this.refactor(v.getName()));
        return v.withInitializer((Expression)this.refactor(v.getInitializer()));
    }

    @Override
    public J visitWhileLoop(J.WhileLoop whileLoop) {
        J.WhileLoop w = (J.WhileLoop)this.refactor(whileLoop, this::visitStatement);
        w = w.withCondition((J.Parentheses)this.refactor(w.getCondition()));
        return w.withBody((Statement)this.refactor(w.getBody()));
    }

    @Override
    public J visitWildcard(J.Wildcard wildcard) {
        J.Wildcard w = (J.Wildcard)this.refactor(wildcard, this::visitExpression);
        return w.withBoundedType((NameTree)this.refactor(w.getBoundedType()));
    }

    public void maybeAddImport(@Nullable JavaType.FullyQualified clazz) {
        if (clazz != null) {
            this.maybeAddImport(clazz.getFullyQualifiedName());
        }
    }

    public void addImport(String fullyQualifiedName) {
        AddImport op = new AddImport();
        op.setType(fullyQualifiedName);
        op.setOnlyIfReferenced(false);
        if (!this.andThen().contains(op)) {
            this.andThen((RefactorVisitor)op);
        }
    }

    public void maybeAddImport(String fullyQualifiedName) {
        AddImport op = new AddImport();
        op.setType(fullyQualifiedName);
        if (!this.andThen().contains(op)) {
            this.andThen((RefactorVisitor)op);
        }
    }

    public void maybeRemoveImport(@Nullable JavaType.FullyQualified clazz) {
        if (clazz != null) {
            this.maybeRemoveImport(clazz.getFullyQualifiedName());
        }
    }

    public void maybeRemoveImport(String fullyQualifiedName) {
        RemoveImport op = new RemoveImport();
        op.setType(fullyQualifiedName);
        if (!this.andThen().contains(op)) {
            this.andThen((RefactorVisitor)op);
        }
    }

    public void maybeUnwrapParentheses(Cursor parensCursor) {
        if (UnwrapParentheses.Scoped.isUnwrappable(parensCursor)) {
            this.andThen((RefactorVisitor)new UnwrapParentheses.Scoped((J.Parentheses)parensCursor.getTree()));
        }
    }
}

