/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class GenerateNewBeanUsingProperties {

    public static class Scoped
    extends JavaIsoRefactorVisitor {
        private final J.Block<? extends J> scope;
        @Nullable
        private final J before;
        private final JavaType.FullyQualified beanType;
        @Nullable
        private final String beanName;
        private final Object[] properties;

        public Scoped(J.Block<? extends J> scope, @Nullable J before, String beanType, @Nullable String beanName, Object ... properties) {
            this.scope = scope;
            this.before = before;
            this.beanType = JavaType.Class.build(beanType);
            this.beanName = beanName;
            this.properties = properties;
            this.setCursoringOn();
        }

        public boolean isIdempotent() {
            return false;
        }

        @Override
        public J.Block visitBlock(J.Block<J> block) {
            J.Block b = super.visitBlock((J.Block)block);
            if (b.isScope(this.scope)) {
                ArrayList statements = new ArrayList(b.getStatements());
                if (this.before == null) {
                    statements.addAll(0, this.buildBeanStatements());
                } else {
                    for (int i = 0; i < statements.size(); ++i) {
                        J statement = (J)statements.get(i);
                        if (!statement.isScope(this.before)) continue;
                        statements.addAll(i, this.buildBeanStatements());
                        break;
                    }
                }
                b = b.withStatements(statements);
            }
            return b;
        }

        private List<J> buildBeanStatements() {
            String name = this.beanName == null ? StringUtils.uncapitalize((String)this.beanType.getClassName()) : this.beanName;
            StringBuilder snippet = new StringBuilder(this.beanType.getClassName() + " " + name + " = new " + this.beanType.getClassName() + "();\n");
            if (this.properties.length % 2 != 0) {
                throw new IllegalStateException("Properties must an array of key/value property pairs.");
            }
            int propertiesLength = this.properties.length;
            for (int i = 0; i < propertiesLength; i += 2) {
                snippet.append(name).append(".set").append(StringUtils.capitalize((String)this.properties[i].toString())).append("(").append(((J)this.properties[i + 1]).printTrimmed()).append(");\n");
            }
            List<J> beanStatements = this.treeBuilder.buildSnippet(this.getCursor(), snippet.toString(), new JavaType[0]);
            this.andThen((RefactorVisitor)new AutoFormat(beanStatements.toArray(new J[0])));
            return beanStatements;
        }
    }
}

