/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Arrays;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;

public class FillTypeAttributions
extends JavaRefactorVisitor {
    private final JavaType.Class[] types;

    public FillTypeAttributions(JavaType.Class[] types) {
        this.types = types;
    }

    public J reduce(J r1, J r2) {
        J j = (J)super.reduce((Object)r1, (Object)r2);
        if (r2 != null && j instanceof NameTree) {
            j = (J)((NameTree)j).withType(((NameTree)r2).getType());
        }
        return j;
    }

    public J visitTree(Tree tree) {
        if (tree instanceof NameTree) {
            NameTree n = (NameTree)super.visitTree(tree);
            if (n.getType() == null) {
                if (n instanceof J.Ident) {
                    J.Ident ident = (J.Ident)n;
                    return Arrays.stream(this.types).filter(im -> im.getClassName().equals(((J.Ident)n).getSimpleName())).findAny().map(im -> ident.withType(JavaType.Class.build(im.getFullyQualifiedName()))).orElse(ident);
                }
                if (n instanceof J.FieldAccess) {
                    J.FieldAccess fieldAccess = (J.FieldAccess)n;
                    return Arrays.stream(this.types).filter(im -> im.getFullyQualifiedName().equals(fieldAccess.printTrimmed())).findAny().map(im -> fieldAccess.withType(JavaType.Class.build(im.getFullyQualifiedName()))).orElse(fieldAccess);
                }
            }
            return n;
        }
        return (J)super.visitTree(tree);
    }
}

