/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openrewrite.AbstractSourceVisitor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.style.TabAndIndentStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.refactor.Formatter;

@Incubating(since="2.1.0")
public class AutoFormat
extends JavaRefactorVisitor {
    private final J scope;
    private Formatter.Result wholeSourceIndent;

    public AutoFormat(J scope) {
        this.scope = scope;
        this.setCursoringOn();
    }

    public boolean isIdempotent() {
        return false;
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu) {
        FindIndentExceptScope findIndent = new FindIndentExceptScope(0);
        findIndent.visit(cu);
        TabAndIndentStyle tabAndIndentStyle = cu.getStyle(TabAndIndentStyle.class).orElse(new TabAndIndentStyle());
        int mostCommonIndent = findIndent.getMostCommonIndent();
        this.wholeSourceIndent = new Formatter.Result(0, mostCommonIndent == 0 ? tabAndIndentStyle.getIndentSize() : mostCommonIndent, mostCommonIndent == 0 ? !tabAndIndentStyle.isUseTabCharacter() : findIndent.isIndentedWithSpaces());
        return super.visitCompilationUnit(cu);
    }

    public J reduce(J r1, J r2) {
        J j = (J)super.reduce((Object)r1, (Object)r2);
        if (r2 != null && r2.getPrefix().startsWith("|")) {
            j = (J)j.withPrefix(r2.getPrefix().substring(1));
        }
        return j;
    }

    public J visitTree(Tree tree) {
        J j = (J)super.visitTree(tree);
        String prefix = tree.getPrefix();
        if (prefix.contains("\n") && this.getCursor().isScopeInPath((Tree)this.scope)) {
            String shiftedPrefix;
            int indentMultiple = (int)this.getCursor().getPathAsStream().filter(J.Block.class::isInstance).count();
            if (tree instanceof J.Block.End) {
                --indentMultiple;
            }
            if (!(shiftedPrefix = "|" + prefix.substring(0, prefix.lastIndexOf(10) + 1) + IntStream.range(0, indentMultiple * this.wholeSourceIndent.getIndentToUse()).mapToObj(n -> this.wholeSourceIndent.isIndentedWithSpaces() ? " " : "\t").collect(Collectors.joining(""))).equals(prefix)) {
                j = (J)j.withPrefix(shiftedPrefix);
            }
        }
        return j;
    }

    private class FindIndentExceptScope
    extends AbstractSourceVisitor<Void> {
        private final SortedMap<Integer, Long> indentFrequencies = new TreeMap<Integer, Long>();
        private final int enclosingIndent;
        private int linesWithSpaceIndents = 0;
        private int linesWithTabIndents = 0;
        private final Pattern SINGLE_LINE_COMMENT = Pattern.compile("//[^\\n]+");
        private final Pattern MULTI_LINE_COMMENT = Pattern.compile("/\\*.*?\\*/", 32);

        public FindIndentExceptScope(int enclosingIndent) {
            this.enclosingIndent = enclosingIndent;
            this.setCursoringOn();
        }

        public Void defaultTo(Tree t) {
            return null;
        }

        public Void visitTree(Tree tree) {
            if (this.getCursor().isScopeInPath((Tree)AutoFormat.this.scope)) {
                return null;
            }
            String prefix = tree.getPrefix();
            AtomicBoolean takeWhile = new AtomicBoolean(true);
            if (prefix.chars().filter(c -> {
                takeWhile.set(takeWhile.get() && (c == 10 || c == 13));
                return takeWhile.get();
            }).count() > 0L) {
                char[] chars;
                int indent = 0;
                for (char c2 : chars = this.MULTI_LINE_COMMENT.matcher(this.SINGLE_LINE_COMMENT.matcher(prefix).replaceAll("")).replaceAll("").toCharArray()) {
                    if (c2 == '\n' || c2 == '\r') {
                        indent = 0;
                        continue;
                    }
                    if (!Character.isWhitespace(c2)) continue;
                    ++indent;
                }
                this.indentFrequencies.merge(indent - this.enclosingIndent, 1L, Long::sum);
                AtomicBoolean dropWhile = new AtomicBoolean(false);
                takeWhile.set(true);
                Map indentTypeCounts = prefix.chars().filter(c -> {
                    dropWhile.set(dropWhile.get() || c != 10 && c != 13);
                    return dropWhile.get();
                }).filter(c -> {
                    takeWhile.set(takeWhile.get() && Character.isWhitespace(c));
                    return takeWhile.get();
                }).mapToObj(c -> c == 32).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                if (indentTypeCounts.getOrDefault(true, 0L) >= indentTypeCounts.getOrDefault(false, 0L)) {
                    ++this.linesWithSpaceIndents;
                } else {
                    ++this.linesWithTabIndents;
                }
            }
            return (Void)super.visitTree(tree);
        }

        public boolean isIndentedWithSpaces() {
            return this.linesWithSpaceIndents >= this.linesWithTabIndents;
        }

        public int getMostCommonIndent() {
            this.indentFrequencies.remove(0);
            return StringUtils.mostCommonIndent(this.indentFrequencies);
        }
    }
}

