/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public final class AddAnnotation {
    private AddAnnotation() {
    }

    public static class Scoped
    extends JavaRefactorVisitor {
        private final Tree scope;
        private final JavaType.Class annotationType;
        private final List<Expression> arguments;

        public Scoped(Tree scope, String annotationTypeName, Expression ... arguments) {
            this.scope = scope;
            this.annotationType = JavaType.Class.build(annotationTypeName);
            this.arguments = Arrays.asList(arguments);
            this.setCursoringOn();
        }

        public Iterable<Tag> getTags() {
            return Tags.of((String)"annotation.type", (String)this.annotationType.getFullyQualifiedName());
        }

        @Override
        public J visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl c = (J.ClassDecl)this.refactor(classDecl, x$0 -> super.visitClassDecl((J.ClassDecl)x$0));
            if (this.scope.isScope((Tree)classDecl)) {
                this.maybeAddImport(this.annotationType.getFullyQualifiedName());
                if (c.getAnnotations().stream().noneMatch(ann -> TypeUtils.isOfClassType(ann.getType(), this.annotationType.getFullyQualifiedName()))) {
                    ArrayList<J.Annotation> fixedAnnotations = new ArrayList<J.Annotation>(c.getAnnotations());
                    Formatting annotationFormatting = classDecl.getModifiers().isEmpty() ? (classDecl.getTypeParameters() == null ? classDecl.getKind().getFormatting() : classDecl.getTypeParameters().getFormatting()) : Formatting.format((String)Formatting.firstPrefix(classDecl.getModifiers()));
                    fixedAnnotations.add(this.buildAnnotation(annotationFormatting));
                    c = c.withAnnotations(fixedAnnotations);
                    if (classDecl.getAnnotations().isEmpty()) {
                        String prefix = this.formatter.findIndent(0, new Tree[]{c}).getPrefix();
                        String cdPrefix = c.getPrefix();
                        if (this.getCursor().getParentOrThrow().getTree() instanceof J.CompilationUnit && cdPrefix.substring(Math.max(cdPrefix.lastIndexOf(10), 0)).chars().noneMatch(p -> p == 32 || p == 9)) {
                            prefix = "\n";
                        }
                        c = !c.getModifiers().isEmpty() ? c.withModifiers(Formatting.formatFirstPrefix(c.getModifiers(), (String)prefix)) : (c.getTypeParameters() != null ? c.withTypeParameters((J.TypeParameters)c.getTypeParameters().withPrefix(prefix)) : c.withKind((J.ClassDecl.Kind)c.getKind().withPrefix(prefix)));
                    }
                }
            }
            return c;
        }

        @Override
        public J visitMultiVariable(J.VariableDecls multiVariable) {
            J.VariableDecls v = (J.VariableDecls)this.refactor(multiVariable, x$0 -> super.visitMultiVariable((J.VariableDecls)x$0));
            if (this.scope.isScope((Tree)multiVariable)) {
                Tree parent = this.getCursor().getParentOrThrow().getTree();
                boolean isMethodOrLambdaParameter = parent instanceof J.MethodDecl || parent instanceof J.Lambda;
                this.maybeAddImport(this.annotationType.getFullyQualifiedName());
                if (v.getAnnotations().stream().noneMatch(ann -> TypeUtils.isOfClassType(ann.getType(), this.annotationType.getFullyQualifiedName()))) {
                    ArrayList<J.Annotation> fixedAnnotations = new ArrayList<J.Annotation>(v.getAnnotations());
                    if (!isMethodOrLambdaParameter && multiVariable.getPrefix().chars().filter(c -> c == 10).count() < 2L) {
                        List statements = this.enclosingBlock().getStatements();
                        for (int i = 1; i < statements.size(); ++i) {
                            if (statements.get(i) != multiVariable) continue;
                            v = (J.VariableDecls)v.withPrefix("\n" + v.getPrefix());
                            break;
                        }
                    }
                    fixedAnnotations.add(this.buildAnnotation(Formatting.EMPTY));
                    v = v.withAnnotations(fixedAnnotations);
                    if (multiVariable.getAnnotations().isEmpty()) {
                        String prefix = isMethodOrLambdaParameter ? " " : this.formatter.format(this.enclosingBlock()).getPrefix();
                        v = !v.getModifiers().isEmpty() ? v.withModifiers(Formatting.formatFirstPrefix(v.getModifiers(), (String)prefix)) : v.withTypeExpr((TypeTree)v.getTypeExpr().withPrefix(prefix));
                    }
                }
            }
            return v;
        }

        @Override
        public J visitMethod(J.MethodDecl method) {
            J.MethodDecl m = (J.MethodDecl)this.refactor(method, x$0 -> super.visitMethod((J.MethodDecl)x$0));
            if (this.scope.isScope((Tree)method)) {
                this.maybeAddImport(this.annotationType.getFullyQualifiedName());
                if (m.getAnnotations().stream().noneMatch(ann -> TypeUtils.isOfClassType(ann.getType(), this.annotationType.getFullyQualifiedName()))) {
                    ArrayList<J.Annotation> fixedAnnotations = new ArrayList<J.Annotation>(m.getAnnotations());
                    fixedAnnotations.add(this.buildAnnotation(Formatting.EMPTY));
                    m = m.withAnnotations(fixedAnnotations);
                    if (method.getAnnotations().isEmpty()) {
                        String prefix = this.formatter.findIndent(0, new Tree[]{method}).getPrefix();
                        m = !m.getModifiers().isEmpty() ? m.withModifiers(Formatting.formatFirstPrefix(m.getModifiers(), (String)prefix)) : (m.getTypeParameters() != null ? m.withTypeParameters((J.TypeParameters)m.getTypeParameters().withPrefix(prefix)) : (m.getReturnTypeExpr() != null ? m.withReturnTypeExpr((TypeTree)m.getReturnTypeExpr().withPrefix(prefix)) : m.withName((J.Ident)m.getName().withPrefix(prefix))));
                    }
                }
            }
            return m;
        }

        private J.Annotation buildAnnotation(Formatting formatting) {
            return new J.Annotation(Tree.randomId(), J.Ident.build(Tree.randomId(), this.annotationType.getClassName(), this.annotationType, Formatting.EMPTY), this.arguments.isEmpty() ? null : new J.Annotation.Arguments(Tree.randomId(), this.arguments, Formatting.EMPTY), formatting);
        }
    }
}

