/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.koloboke.collect.map.hash.HashObjObjMaps;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Formatting;
import org.openrewrite.Metadata;
import org.openrewrite.Refactor;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.internal.PrintJava;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.FindFields;
import org.openrewrite.java.search.FindInheritedFields;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.search.FindType;
import org.openrewrite.java.search.HasImport;
import org.openrewrite.java.search.HasType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public interface J
extends Serializable,
Tree {
    default public <R> R accept(SourceVisitor<R> v) {
        return (R)(v instanceof JavaSourceVisitor ? this.acceptJava((JavaSourceVisitor)v) : v.defaultTo(null));
    }

    default public <R> R acceptJava(JavaSourceVisitor<R> v) {
        return (R)v.defaultTo(null);
    }

    default public String print() {
        return (String)new PrintJava().visit(this);
    }

    @JsonIgnore
    default public String getTreeType() {
        return "java";
    }

    public static class Wildcard
    implements J,
    Expression {
        private final UUID id;
        @Nullable
        private final Bound bound;
        @Nullable
        private final NameTree boundedType;
        private final Formatting formatting;

        @Override
        public JavaType getType() {
            return null;
        }

        public Wildcard withType(JavaType type) {
            return this;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitWildcard(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Wildcard)) {
                return false;
            }
            Wildcard other = (Wildcard)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Wildcard;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "bound", "boundedType", "formatting"})
        public Wildcard(UUID id, Bound bound, NameTree boundedType, Formatting formatting) {
            this.id = id;
            this.bound = bound;
            this.boundedType = boundedType;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Bound getBound() {
            return this.bound;
        }

        public NameTree getBoundedType() {
            return this.boundedType;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Wildcard(id=" + this.getId() + ", bound=" + this.getBound() + ", boundedType=" + this.getBoundedType() + ", formatting=" + this.getFormatting() + ")";
        }

        public Wildcard withBound(Bound bound) {
            return this.bound == bound ? this : new Wildcard(this.id, bound, this.boundedType, this.formatting);
        }

        public Wildcard withBoundedType(NameTree boundedType) {
            return this.boundedType == boundedType ? this : new Wildcard(this.id, this.bound, boundedType, this.formatting);
        }

        public Wildcard withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Wildcard(this.id, this.bound, this.boundedType, formatting);
        }

        public static abstract class Bound
        implements J {
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bound)) {
                    return false;
                }
                Bound other = (Bound)o;
                return other.canEqual(this);
            }

            protected boolean canEqual(Object other) {
                return other instanceof Bound;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public static class Super
            extends Bound {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Super)) {
                        return false;
                    }
                    Super other = (Super)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Super;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Super(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Wildcard.Bound.Super(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Super withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Super(this.id, formatting);
                }
            }

            public static class Extends
            extends Bound {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Extends)) {
                        return false;
                    }
                    Extends other = (Extends)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Extends;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Extends(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Wildcard.Bound.Extends(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Extends withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Extends(this.id, formatting);
                }
            }
        }
    }

    public static class WhileLoop
    implements J,
    Statement {
        private final UUID id;
        private final Parentheses<Expression> condition;
        private final Statement body;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitWhileLoop(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WhileLoop)) {
                return false;
            }
            WhileLoop other = (WhileLoop)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WhileLoop;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "condition", "body", "formatting"})
        public WhileLoop(UUID id, Parentheses<Expression> condition, Statement body, Formatting formatting) {
            this.id = id;
            this.condition = condition;
            this.body = body;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Parentheses<Expression> getCondition() {
            return this.condition;
        }

        public Statement getBody() {
            return this.body;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.WhileLoop(id=" + this.getId() + ", condition=" + this.getCondition() + ", body=" + this.getBody() + ", formatting=" + this.getFormatting() + ")";
        }

        public WhileLoop withCondition(Parentheses<Expression> condition) {
            return this.condition == condition ? this : new WhileLoop(this.id, condition, this.body, this.formatting);
        }

        public WhileLoop withBody(Statement body) {
            return this.body == body ? this : new WhileLoop(this.id, this.condition, body, this.formatting);
        }

        public WhileLoop withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new WhileLoop(this.id, this.condition, this.body, formatting);
        }
    }

    public static class VariableDecls
    implements J,
    Statement {
        private final UUID id;
        private final List<Annotation> annotations;
        private final List<Modifier> modifiers;
        @Nullable
        private final TypeTree typeExpr;
        @Nullable
        private final Varargs varargs;
        private final List<Dimension> dimensionsBeforeName;
        private final List<NamedVar> vars;
        private final Formatting formatting;

        public VariableDecls withModifiers(List<Modifier> modifiers) {
            if (modifiers == this.modifiers) {
                return this;
            }
            return new VariableDecls(this.id, this.annotations, modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, this.vars, this.formatting);
        }

        public VariableDecls withModifiers(String ... modifierKeywords) {
            if (this.typeExpr == null) {
                return this;
            }
            List<Modifier> fixedModifiers = Modifier.withModifiers(this.modifiers, modifierKeywords);
            if (fixedModifiers == this.modifiers) {
                return this;
            }
            if (this.modifiers.isEmpty()) {
                return this.withModifiers(Formatting.formatFirstPrefix(fixedModifiers, (String)this.typeExpr.getFormatting().getPrefix())).withTypeExpr((TypeTree)this.typeExpr.withPrefix(" "));
            }
            return this.withModifiers(fixedModifiers);
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitMultiVariable(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public List<Annotation> findAnnotations(String signature) {
            return (List)new FindAnnotations(signature).visit(this);
        }

        @JsonIgnore
        public JavaType.Class getTypeAsClass() {
            return this.typeExpr == null ? null : TypeUtils.asClass(this.typeExpr.getType());
        }

        public boolean hasModifier(String modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableDecls)) {
                return false;
            }
            VariableDecls other = (VariableDecls)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VariableDecls;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "annotations", "modifiers", "typeExpr", "varargs", "dimensionsBeforeName", "vars", "formatting"})
        public VariableDecls(UUID id, List<Annotation> annotations, List<Modifier> modifiers, TypeTree typeExpr, Varargs varargs, List<Dimension> dimensionsBeforeName, List<NamedVar> vars, Formatting formatting) {
            this.id = id;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.typeExpr = typeExpr;
            this.varargs = varargs;
            this.dimensionsBeforeName = dimensionsBeforeName;
            this.vars = vars;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        public TypeTree getTypeExpr() {
            return this.typeExpr;
        }

        public Varargs getVarargs() {
            return this.varargs;
        }

        public List<Dimension> getDimensionsBeforeName() {
            return this.dimensionsBeforeName;
        }

        public List<NamedVar> getVars() {
            return this.vars;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.VariableDecls(id=" + this.getId() + ", annotations=" + this.getAnnotations() + ", modifiers=" + this.getModifiers() + ", typeExpr=" + this.getTypeExpr() + ", varargs=" + this.getVarargs() + ", dimensionsBeforeName=" + this.getDimensionsBeforeName() + ", vars=" + this.getVars() + ", formatting=" + this.getFormatting() + ")";
        }

        public VariableDecls withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new VariableDecls(this.id, annotations, this.modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, this.vars, this.formatting);
        }

        public VariableDecls withTypeExpr(TypeTree typeExpr) {
            return this.typeExpr == typeExpr ? this : new VariableDecls(this.id, this.annotations, this.modifiers, typeExpr, this.varargs, this.dimensionsBeforeName, this.vars, this.formatting);
        }

        public VariableDecls withVarargs(Varargs varargs) {
            return this.varargs == varargs ? this : new VariableDecls(this.id, this.annotations, this.modifiers, this.typeExpr, varargs, this.dimensionsBeforeName, this.vars, this.formatting);
        }

        public VariableDecls withDimensionsBeforeName(List<Dimension> dimensionsBeforeName) {
            return this.dimensionsBeforeName == dimensionsBeforeName ? this : new VariableDecls(this.id, this.annotations, this.modifiers, this.typeExpr, this.varargs, dimensionsBeforeName, this.vars, this.formatting);
        }

        public VariableDecls withVars(List<NamedVar> vars) {
            return this.vars == vars ? this : new VariableDecls(this.id, this.annotations, this.modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, vars, this.formatting);
        }

        public VariableDecls withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new VariableDecls(this.id, this.annotations, this.modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, this.vars, formatting);
        }

        public static class NamedVar
        implements J,
        NameTree {
            private final UUID id;
            private final Ident name;
            private final List<Dimension> dimensionsAfterName;
            @Nullable
            private final Expression initializer;
            @Nullable
            private final JavaType type;
            private final Formatting formatting;

            @JsonIgnore
            public String getSimpleName() {
                return this.name.getSimpleName();
            }

            @Override
            public <R> R acceptJava(JavaSourceVisitor<R> v) {
                return v.visitVariable(this);
            }

            @JsonIgnore
            public boolean isField(Cursor cursor) {
                return cursor.getParentOrThrow().getParentOrThrow().getParentOrThrow().getTree() instanceof ClassDecl;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NamedVar)) {
                    return false;
                }
                NamedVar other = (NamedVar)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof NamedVar;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "name", "dimensionsAfterName", "initializer", "type", "formatting"})
            public NamedVar(UUID id, Ident name, List<Dimension> dimensionsAfterName, Expression initializer, JavaType type, Formatting formatting) {
                this.id = id;
                this.name = name;
                this.dimensionsAfterName = dimensionsAfterName;
                this.initializer = initializer;
                this.type = type;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Ident getName() {
                return this.name;
            }

            public List<Dimension> getDimensionsAfterName() {
                return this.dimensionsAfterName;
            }

            public Expression getInitializer() {
                return this.initializer;
            }

            @Override
            public JavaType getType() {
                return this.type;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.VariableDecls.NamedVar(id=" + this.getId() + ", name=" + this.getName() + ", dimensionsAfterName=" + this.getDimensionsAfterName() + ", initializer=" + this.getInitializer() + ", type=" + this.getType() + ", formatting=" + this.getFormatting() + ")";
            }

            public NamedVar withName(Ident name) {
                return this.name == name ? this : new NamedVar(this.id, name, this.dimensionsAfterName, this.initializer, this.type, this.formatting);
            }

            public NamedVar withDimensionsAfterName(List<Dimension> dimensionsAfterName) {
                return this.dimensionsAfterName == dimensionsAfterName ? this : new NamedVar(this.id, this.name, dimensionsAfterName, this.initializer, this.type, this.formatting);
            }

            public NamedVar withInitializer(Expression initializer) {
                return this.initializer == initializer ? this : new NamedVar(this.id, this.name, this.dimensionsAfterName, initializer, this.type, this.formatting);
            }

            public NamedVar withType(JavaType type) {
                return this.type == type ? this : new NamedVar(this.id, this.name, this.dimensionsAfterName, this.initializer, type, this.formatting);
            }

            public NamedVar withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new NamedVar(this.id, this.name, this.dimensionsAfterName, this.initializer, this.type, formatting);
            }
        }

        public static class Dimension
        implements J {
            private final UUID id;
            private final Empty whitespace;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dimension)) {
                    return false;
                }
                Dimension other = (Dimension)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Dimension;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "whitespace", "formatting"})
            public Dimension(UUID id, Empty whitespace, Formatting formatting) {
                this.id = id;
                this.whitespace = whitespace;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Empty getWhitespace() {
                return this.whitespace;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.VariableDecls.Dimension(id=" + this.getId() + ", whitespace=" + this.getWhitespace() + ", formatting=" + this.getFormatting() + ")";
            }

            public Dimension withWhitespace(Empty whitespace) {
                return this.whitespace == whitespace ? this : new Dimension(this.id, whitespace, this.formatting);
            }

            public Dimension withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Dimension(this.id, this.whitespace, formatting);
            }
        }

        public static class Varargs
        implements J {
            private final UUID id;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Varargs)) {
                    return false;
                }
                Varargs other = (Varargs)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Varargs;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public Varargs(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.VariableDecls.Varargs(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public Varargs withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Varargs(this.id, formatting);
            }
        }
    }

    public static class UnparsedSource
    implements J,
    Statement,
    Expression {
        private final UUID id;
        private final String source;
        private final Formatting formatting;

        @Override
        public JavaType getType() {
            return null;
        }

        public UnparsedSource withType(JavaType type) {
            return null;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitUnparsedSource(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnparsedSource)) {
                return false;
            }
            UnparsedSource other = (UnparsedSource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UnparsedSource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "source", "formatting"})
        public UnparsedSource(UUID id, String source, Formatting formatting) {
            this.id = id;
            this.source = source;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public String getSource() {
            return this.source;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.UnparsedSource(id=" + this.getId() + ", source=" + this.getSource() + ", formatting=" + this.getFormatting() + ")";
        }

        public UnparsedSource withSource(String source) {
            return this.source == source ? this : new UnparsedSource(this.id, source, this.formatting);
        }

        public UnparsedSource withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new UnparsedSource(this.id, this.source, formatting);
        }
    }

    public static class Unary
    implements J,
    Statement,
    Expression {
        private final UUID id;
        private final Operator operator;
        private final Expression expr;
        @Nullable
        private final JavaType type;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitUnary(this);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return this.expr.getSideEffects();
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unary)) {
                return false;
            }
            Unary other = (Unary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Unary;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "operator", "expr", "type", "formatting"})
        public Unary(UUID id, Operator operator, Expression expr, JavaType type, Formatting formatting) {
            this.id = id;
            this.operator = operator;
            this.expr = expr;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public Expression getExpr() {
            return this.expr;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Unary(id=" + this.getId() + ", operator=" + this.getOperator() + ", expr=" + this.getExpr() + ", type=" + this.getType() + ", formatting=" + this.getFormatting() + ")";
        }

        public Unary withOperator(Operator operator) {
            return this.operator == operator ? this : new Unary(this.id, operator, this.expr, this.type, this.formatting);
        }

        public Unary withExpr(Expression expr) {
            return this.expr == expr ? this : new Unary(this.id, this.operator, expr, this.type, this.formatting);
        }

        public Unary withType(JavaType type) {
            return this.type == type ? this : new Unary(this.id, this.operator, this.expr, type, this.formatting);
        }

        public Unary withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Unary(this.id, this.operator, this.expr, this.type, formatting);
        }

        public static abstract class Operator
        implements J {
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Operator)) {
                    return false;
                }
                Operator other = (Operator)o;
                return other.canEqual(this);
            }

            protected boolean canEqual(Object other) {
                return other instanceof Operator;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public String toString() {
                return "J.Unary.Operator()";
            }

            public static class Not
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Not)) {
                        return false;
                    }
                    Not other = (Not)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Not;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Not(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.Not(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Not withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Not(this.id, formatting);
                }
            }

            public static class Complement
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Complement)) {
                        return false;
                    }
                    Complement other = (Complement)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Complement;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Complement(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.Complement(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Complement withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Complement(this.id, formatting);
                }
            }

            public static class Negative
            extends Operator {
                private final UUID id;
                private final Formatting formatting = Formatting.EMPTY;

                public <T extends Tree> T withFormatting(Formatting fmt) {
                    return (T)this;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Negative)) {
                        return false;
                    }
                    Negative other = (Negative)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Negative;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id"})
                public Negative(UUID id) {
                    this.id = id;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.Negative(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }
            }

            public static class Positive
            extends Operator {
                private final UUID id;
                private final Formatting formatting = Formatting.EMPTY;

                public <T extends Tree> T withFormatting(Formatting fmt) {
                    return (T)this;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Positive)) {
                        return false;
                    }
                    Positive other = (Positive)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Positive;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id"})
                public Positive(UUID id) {
                    this.id = id;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.Positive(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }
            }

            public static class PostDecrement
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof PostDecrement)) {
                        return false;
                    }
                    PostDecrement other = (PostDecrement)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof PostDecrement;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public PostDecrement(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.PostDecrement(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public PostDecrement withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new PostDecrement(this.id, formatting);
                }
            }

            public static class PostIncrement
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof PostIncrement)) {
                        return false;
                    }
                    PostIncrement other = (PostIncrement)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof PostIncrement;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public PostIncrement(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.PostIncrement(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public PostIncrement withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new PostIncrement(this.id, formatting);
                }
            }

            public static class PreDecrement
            extends Operator {
                private final UUID id;
                private final Formatting formatting = Formatting.EMPTY;

                public <T extends Tree> T withFormatting(Formatting fmt) {
                    return (T)this;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof PreDecrement)) {
                        return false;
                    }
                    PreDecrement other = (PreDecrement)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof PreDecrement;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id"})
                public PreDecrement(UUID id) {
                    this.id = id;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.PreDecrement(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }
            }

            public static class PreIncrement
            extends Operator {
                private final UUID id;
                private final Formatting formatting = Formatting.EMPTY;

                public <T extends Tree> T withFormatting(Formatting fmt) {
                    return (T)this;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof PreIncrement)) {
                        return false;
                    }
                    PreIncrement other = (PreIncrement)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof PreIncrement;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id"})
                public PreIncrement(UUID id) {
                    this.id = id;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.PreIncrement(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }
            }
        }
    }

    public static class TypeParameters
    implements J {
        private final UUID id;
        private final List<TypeParameter> params;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitTypeParameters(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeParameters)) {
                return false;
            }
            TypeParameters other = (TypeParameters)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TypeParameters;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "params", "formatting"})
        public TypeParameters(UUID id, List<TypeParameter> params, Formatting formatting) {
            this.id = id;
            this.params = params;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public List<TypeParameter> getParams() {
            return this.params;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.TypeParameters(id=" + this.getId() + ", params=" + this.getParams() + ", formatting=" + this.getFormatting() + ")";
        }

        public TypeParameters withParams(List<TypeParameter> params) {
            return this.params == params ? this : new TypeParameters(this.id, params, this.formatting);
        }

        public TypeParameters withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new TypeParameters(this.id, this.params, formatting);
        }
    }

    public static class TypeParameter
    implements J {
        private final UUID id;
        private final List<Annotation> annotations;
        private final Expression name;
        @Nullable
        private final Bounds bounds;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitTypeParameter(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeParameter)) {
                return false;
            }
            TypeParameter other = (TypeParameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TypeParameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "annotations", "name", "bounds", "formatting"})
        public TypeParameter(UUID id, List<Annotation> annotations, Expression name, Bounds bounds, Formatting formatting) {
            this.id = id;
            this.annotations = annotations;
            this.name = name;
            this.bounds = bounds;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public Expression getName() {
            return this.name;
        }

        public Bounds getBounds() {
            return this.bounds;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.TypeParameter(id=" + this.getId() + ", annotations=" + this.getAnnotations() + ", name=" + this.getName() + ", bounds=" + this.getBounds() + ", formatting=" + this.getFormatting() + ")";
        }

        public TypeParameter withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new TypeParameter(this.id, annotations, this.name, this.bounds, this.formatting);
        }

        public TypeParameter withName(Expression name) {
            return this.name == name ? this : new TypeParameter(this.id, this.annotations, name, this.bounds, this.formatting);
        }

        public TypeParameter withBounds(Bounds bounds) {
            return this.bounds == bounds ? this : new TypeParameter(this.id, this.annotations, this.name, bounds, this.formatting);
        }

        public TypeParameter withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new TypeParameter(this.id, this.annotations, this.name, this.bounds, formatting);
        }

        public static class Bounds
        implements J {
            private final UUID id;
            private final List<TypeTree> types;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bounds)) {
                    return false;
                }
                Bounds other = (Bounds)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Bounds;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "types", "formatting"})
            public Bounds(UUID id, List<TypeTree> types, Formatting formatting) {
                this.id = id;
                this.types = types;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public List<TypeTree> getTypes() {
                return this.types;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.TypeParameter.Bounds(id=" + this.getId() + ", types=" + this.getTypes() + ", formatting=" + this.getFormatting() + ")";
            }

            public Bounds withTypes(List<TypeTree> types) {
                return this.types == types ? this : new Bounds(this.id, types, this.formatting);
            }

            public Bounds withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Bounds(this.id, this.types, formatting);
            }
        }
    }

    public static class TypeCast
    implements J,
    Expression {
        private final UUID id;
        private final Parentheses<TypeTree> clazz;
        private final Expression expr;
        private final Formatting formatting;

        @Override
        public JavaType getType() {
            return this.clazz.getType();
        }

        public TypeCast withType(JavaType type) {
            return this.withClazz((Parentheses<TypeTree>)this.clazz.withType(type));
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitTypeCast(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeCast)) {
                return false;
            }
            TypeCast other = (TypeCast)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TypeCast;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "clazz", "expr", "formatting"})
        public TypeCast(UUID id, Parentheses<TypeTree> clazz, Expression expr, Formatting formatting) {
            this.id = id;
            this.clazz = clazz;
            this.expr = expr;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Parentheses<TypeTree> getClazz() {
            return this.clazz;
        }

        public Expression getExpr() {
            return this.expr;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.TypeCast(id=" + this.getId() + ", clazz=" + this.getClazz() + ", expr=" + this.getExpr() + ", formatting=" + this.getFormatting() + ")";
        }

        public TypeCast withClazz(Parentheses<TypeTree> clazz) {
            return this.clazz == clazz ? this : new TypeCast(this.id, clazz, this.expr, this.formatting);
        }

        public TypeCast withExpr(Expression expr) {
            return this.expr == expr ? this : new TypeCast(this.id, this.clazz, expr, this.formatting);
        }

        public TypeCast withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new TypeCast(this.id, this.clazz, this.expr, formatting);
        }
    }

    public static class Try
    implements J,
    Statement {
        private final UUID id;
        @Nullable
        private final Resources resources;
        private final Block<Statement> body;
        private final List<Catch> catches;
        @Nullable
        private final Finally finallie;
        private final Formatting formatting;

        public Try withFinally(Finally finallie) {
            if (finallie == this.finallie) {
                return this;
            }
            return new Try(this.id, this.resources, this.body, this.catches, finallie, this.formatting);
        }

        @Nullable
        public Finally getFinally() {
            return this.finallie;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitTry(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Try)) {
                return false;
            }
            Try other = (Try)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Try;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "resources", "body", "catches", "finallie", "formatting"})
        public Try(UUID id, Resources resources, Block<Statement> body, List<Catch> catches, Finally finallie, Formatting formatting) {
            this.id = id;
            this.resources = resources;
            this.body = body;
            this.catches = catches;
            this.finallie = finallie;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Try withResources(Resources resources) {
            return this.resources == resources ? this : new Try(this.id, resources, this.body, this.catches, this.finallie, this.formatting);
        }

        public Resources getResources() {
            return this.resources;
        }

        public Try withBody(Block<Statement> body) {
            return this.body == body ? this : new Try(this.id, this.resources, body, this.catches, this.finallie, this.formatting);
        }

        public Block<Statement> getBody() {
            return this.body;
        }

        public Try withCatches(List<Catch> catches) {
            return this.catches == catches ? this : new Try(this.id, this.resources, this.body, catches, this.finallie, this.formatting);
        }

        public List<Catch> getCatches() {
            return this.catches;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Try withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Try(this.id, this.resources, this.body, this.catches, this.finallie, formatting);
        }

        public static class Finally
        implements J {
            private final UUID id;
            private final Block<Statement> body;
            private final Formatting formatting;

            @Override
            public <R> R acceptJava(JavaSourceVisitor<R> v) {
                return v.visitFinally(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Finally)) {
                    return false;
                }
                Finally other = (Finally)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Finally;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "body", "formatting"})
            public Finally(UUID id, Block<Statement> body, Formatting formatting) {
                this.id = id;
                this.body = body;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Block<Statement> getBody() {
                return this.body;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Try.Finally(id=" + this.getId() + ", body=" + this.getBody() + ", formatting=" + this.getFormatting() + ")";
            }

            public Finally withBody(Block<Statement> body) {
                return this.body == body ? this : new Finally(this.id, body, this.formatting);
            }

            public Finally withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Finally(this.id, this.body, formatting);
            }
        }

        public static class Catch
        implements J {
            private final UUID id;
            private final Parentheses<VariableDecls> param;
            private final Block<Statement> body;
            private final Formatting formatting;

            @Override
            public <R> R acceptJava(JavaSourceVisitor<R> v) {
                return v.visitCatch(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Catch)) {
                    return false;
                }
                Catch other = (Catch)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Catch;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "param", "body", "formatting"})
            public Catch(UUID id, Parentheses<VariableDecls> param, Block<Statement> body, Formatting formatting) {
                this.id = id;
                this.param = param;
                this.body = body;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Parentheses<VariableDecls> getParam() {
                return this.param;
            }

            public Block<Statement> getBody() {
                return this.body;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Try.Catch(id=" + this.getId() + ", param=" + this.getParam() + ", body=" + this.getBody() + ", formatting=" + this.getFormatting() + ")";
            }

            public Catch withParam(Parentheses<VariableDecls> param) {
                return this.param == param ? this : new Catch(this.id, param, this.body, this.formatting);
            }

            public Catch withBody(Block<Statement> body) {
                return this.body == body ? this : new Catch(this.id, this.param, body, this.formatting);
            }

            public Catch withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Catch(this.id, this.param, this.body, formatting);
            }
        }

        public static class Resources
        implements J {
            private final UUID id;
            private final List<VariableDecls> decls;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Resources)) {
                    return false;
                }
                Resources other = (Resources)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Resources;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "decls", "formatting"})
            public Resources(UUID id, List<VariableDecls> decls, Formatting formatting) {
                this.id = id;
                this.decls = decls;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public List<VariableDecls> getDecls() {
                return this.decls;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Try.Resources(id=" + this.getId() + ", decls=" + this.getDecls() + ", formatting=" + this.getFormatting() + ")";
            }

            public Resources withDecls(List<VariableDecls> decls) {
                return this.decls == decls ? this : new Resources(this.id, decls, this.formatting);
            }

            public Resources withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Resources(this.id, this.decls, formatting);
            }
        }
    }

    public static class Throw
    implements J,
    Statement {
        private final UUID id;
        private final Expression exception;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitThrow(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Throw)) {
                return false;
            }
            Throw other = (Throw)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Throw;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "exception", "formatting"})
        public Throw(UUID id, Expression exception, Formatting formatting) {
            this.id = id;
            this.exception = exception;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getException() {
            return this.exception;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Throw(id=" + this.getId() + ", exception=" + this.getException() + ", formatting=" + this.getFormatting() + ")";
        }

        public Throw withException(Expression exception) {
            return this.exception == exception ? this : new Throw(this.id, exception, this.formatting);
        }

        public Throw withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Throw(this.id, this.exception, formatting);
        }
    }

    public static class Ternary
    implements J,
    Expression {
        private final UUID id;
        private final Expression condition;
        private final Expression truePart;
        private final Expression falsePart;
        @Nullable
        private final JavaType type;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitTernary(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ternary)) {
                return false;
            }
            Ternary other = (Ternary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Ternary;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "condition", "truePart", "falsePart", "type", "formatting"})
        public Ternary(UUID id, Expression condition, Expression truePart, Expression falsePart, JavaType type, Formatting formatting) {
            this.id = id;
            this.condition = condition;
            this.truePart = truePart;
            this.falsePart = falsePart;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getCondition() {
            return this.condition;
        }

        public Expression getTruePart() {
            return this.truePart;
        }

        public Expression getFalsePart() {
            return this.falsePart;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Ternary(id=" + this.getId() + ", condition=" + this.getCondition() + ", truePart=" + this.getTruePart() + ", falsePart=" + this.getFalsePart() + ", type=" + this.getType() + ", formatting=" + this.getFormatting() + ")";
        }

        public Ternary withCondition(Expression condition) {
            return this.condition == condition ? this : new Ternary(this.id, condition, this.truePart, this.falsePart, this.type, this.formatting);
        }

        public Ternary withTruePart(Expression truePart) {
            return this.truePart == truePart ? this : new Ternary(this.id, this.condition, truePart, this.falsePart, this.type, this.formatting);
        }

        public Ternary withFalsePart(Expression falsePart) {
            return this.falsePart == falsePart ? this : new Ternary(this.id, this.condition, this.truePart, falsePart, this.type, this.formatting);
        }

        public Ternary withType(JavaType type) {
            return this.type == type ? this : new Ternary(this.id, this.condition, this.truePart, this.falsePart, type, this.formatting);
        }

        public Ternary withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Ternary(this.id, this.condition, this.truePart, this.falsePart, this.type, formatting);
        }
    }

    public static class Synchronized
    implements J,
    Statement {
        private final UUID id;
        private final Parentheses<Expression> lock;
        private final Block<Statement> body;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitSynchronized(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Synchronized)) {
                return false;
            }
            Synchronized other = (Synchronized)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Synchronized;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "lock", "body", "formatting"})
        public Synchronized(UUID id, Parentheses<Expression> lock, Block<Statement> body, Formatting formatting) {
            this.id = id;
            this.lock = lock;
            this.body = body;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Parentheses<Expression> getLock() {
            return this.lock;
        }

        public Block<Statement> getBody() {
            return this.body;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Synchronized(id=" + this.getId() + ", lock=" + this.getLock() + ", body=" + this.getBody() + ", formatting=" + this.getFormatting() + ")";
        }

        public Synchronized withLock(Parentheses<Expression> lock) {
            return this.lock == lock ? this : new Synchronized(this.id, lock, this.body, this.formatting);
        }

        public Synchronized withBody(Block<Statement> body) {
            return this.body == body ? this : new Synchronized(this.id, this.lock, body, this.formatting);
        }

        public Synchronized withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Synchronized(this.id, this.lock, this.body, formatting);
        }
    }

    public static class Switch
    implements J,
    Statement {
        private final UUID id;
        private final Parentheses<Expression> selector;
        private final Block<Case> cases;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitSwitch(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Switch)) {
                return false;
            }
            Switch other = (Switch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Switch;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "selector", "cases", "formatting"})
        public Switch(UUID id, Parentheses<Expression> selector, Block<Case> cases, Formatting formatting) {
            this.id = id;
            this.selector = selector;
            this.cases = cases;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Parentheses<Expression> getSelector() {
            return this.selector;
        }

        public Block<Case> getCases() {
            return this.cases;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Switch(id=" + this.getId() + ", selector=" + this.getSelector() + ", cases=" + this.getCases() + ", formatting=" + this.getFormatting() + ")";
        }

        public Switch withSelector(Parentheses<Expression> selector) {
            return this.selector == selector ? this : new Switch(this.id, selector, this.cases, this.formatting);
        }

        public Switch withCases(Block<Case> cases) {
            return this.cases == cases ? this : new Switch(this.id, this.selector, cases, this.formatting);
        }

        public Switch withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Switch(this.id, this.selector, this.cases, formatting);
        }
    }

    public static class Return
    implements J,
    Statement {
        private final UUID id;
        @Nullable
        private final Expression expr;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitReturn(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Return)) {
                return false;
            }
            Return other = (Return)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Return;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "expr", "formatting"})
        public Return(UUID id, Expression expr, Formatting formatting) {
            this.id = id;
            this.expr = expr;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getExpr() {
            return this.expr;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Return(id=" + this.getId() + ", expr=" + this.getExpr() + ", formatting=" + this.getFormatting() + ")";
        }

        public Return withExpr(Expression expr) {
            return this.expr == expr ? this : new Return(this.id, expr, this.formatting);
        }

        public Return withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Return(this.id, this.expr, formatting);
        }
    }

    public static class Primitive
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final JavaType.Primitive type;
        private final Formatting formatting;

        public Primitive withType(JavaType type) {
            if (!(type instanceof JavaType.Primitive)) {
                throw new IllegalArgumentException("Cannot apply a non-primitive type to Primitve");
            }
            return new Primitive(this.id, (JavaType.Primitive)type, this.formatting);
        }

        @Override
        @NonNull
        public JavaType.Primitive getType() {
            return this.type;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitPrimitive(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Primitive)) {
                return false;
            }
            Primitive other = (Primitive)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Primitive;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "type", "formatting"})
        public Primitive(UUID id, JavaType.Primitive type, Formatting formatting) {
            this.id = id;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Primitive withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Primitive(this.id, this.type, formatting);
        }
    }

    public static class Parentheses<T extends J>
    implements J,
    Expression {
        private final UUID id;
        private final T tree;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitParentheses(this);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return this.tree instanceof Expression ? ((Expression)this.tree).getSideEffects() : Collections.emptyList();
        }

        @Override
        public JavaType getType() {
            return this.tree instanceof Expression ? ((Expression)this.tree).getType() : (this.tree instanceof NameTree ? ((NameTree)this.tree).getType() : null);
        }

        public Parentheses<T> withType(JavaType type) {
            return this.tree instanceof Expression ? (Parentheses)((Expression)this.tree).withType(type) : (this.tree instanceof NameTree ? (Parentheses)((NameTree)this.tree).withType(type) : this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parentheses)) {
                return false;
            }
            Parentheses other = (Parentheses)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parentheses;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "tree", "formatting"})
        public Parentheses(UUID id, T tree, Formatting formatting) {
            this.id = id;
            this.tree = tree;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public T getTree() {
            return this.tree;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Parentheses(id=" + this.getId() + ", tree=" + this.getTree() + ", formatting=" + this.getFormatting() + ")";
        }

        public Parentheses<T> withTree(T tree) {
            return this.tree == tree ? this : new Parentheses<T>(this.id, tree, this.formatting);
        }

        public Parentheses<T> withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Parentheses<T>(this.id, this.tree, formatting);
        }
    }

    public static class ParameterizedType
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final NameTree clazz;
        @Nullable
        private final TypeParameters typeParameters;
        private final Formatting formatting;

        @Override
        public JavaType getType() {
            return this.clazz.getType();
        }

        public ParameterizedType withType(JavaType type) {
            return this.withClazz((NameTree)this.clazz.withType(type));
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitParameterizedType(this);
        }

        public static ParameterizedType build(String typeName, String ... genericTypeNames) {
            JavaType.Class typeNameType = JavaType.Class.build(typeName);
            return new ParameterizedType(Tree.randomId(), Ident.build(Tree.randomId(), typeNameType.getClassName(), typeNameType, Formatting.EMPTY), new TypeParameters(Tree.randomId(), Formatting.formatFirstPrefix(Arrays.stream(genericTypeNames).map(generic -> {
                JavaType.Class genericType = JavaType.Class.build(generic);
                return new TypeParameter(Tree.randomId(), Collections.emptyList(), Ident.build(Tree.randomId(), genericType.getClassName(), genericType, Formatting.EMPTY), null, Formatting.format((String)" "));
            }).collect(Collectors.toList()), (String)""), Formatting.EMPTY), Formatting.EMPTY);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType other = (ParameterizedType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ParameterizedType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "clazz", "typeParameters", "formatting"})
        public ParameterizedType(UUID id, NameTree clazz, TypeParameters typeParameters, Formatting formatting) {
            this.id = id;
            this.clazz = clazz;
            this.typeParameters = typeParameters;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public NameTree getClazz() {
            return this.clazz;
        }

        public TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.ParameterizedType(id=" + this.getId() + ", clazz=" + this.getClazz() + ", typeParameters=" + this.getTypeParameters() + ", formatting=" + this.getFormatting() + ")";
        }

        public ParameterizedType withClazz(NameTree clazz) {
            return this.clazz == clazz ? this : new ParameterizedType(this.id, clazz, this.typeParameters, this.formatting);
        }

        public ParameterizedType withTypeParameters(TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new ParameterizedType(this.id, this.clazz, typeParameters, this.formatting);
        }

        public ParameterizedType withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new ParameterizedType(this.id, this.clazz, this.typeParameters, formatting);
        }
    }

    public static class Package
    implements J {
        private final UUID id;
        private final Expression expr;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitPackage(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Package)) {
                return false;
            }
            Package other = (Package)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Package;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "expr", "formatting"})
        public Package(UUID id, Expression expr, Formatting formatting) {
            this.id = id;
            this.expr = expr;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getExpr() {
            return this.expr;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Package(id=" + this.getId() + ", expr=" + this.getExpr() + ", formatting=" + this.getFormatting() + ")";
        }

        public Package withExpr(Expression expr) {
            return this.expr == expr ? this : new Package(this.id, expr, this.formatting);
        }

        public Package withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Package(this.id, this.expr, formatting);
        }
    }

    public static class NewClass
    implements J,
    Statement,
    Expression {
        private final UUID id;
        @Nullable
        private final TypeTree clazz;
        @Nullable
        private final Arguments args;
        @Nullable
        private final Block<? extends Tree> body;
        @Nullable
        private final JavaType type;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitNewClass(this);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NewClass)) {
                return false;
            }
            NewClass other = (NewClass)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NewClass;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "clazz", "args", "body", "type", "formatting"})
        public NewClass(UUID id, TypeTree clazz, Arguments args, Block<? extends Tree> body, JavaType type, Formatting formatting) {
            this.id = id;
            this.clazz = clazz;
            this.args = args;
            this.body = body;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public TypeTree getClazz() {
            return this.clazz;
        }

        public Arguments getArgs() {
            return this.args;
        }

        public Block<? extends Tree> getBody() {
            return this.body;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.NewClass(id=" + this.getId() + ", clazz=" + this.getClazz() + ", args=" + this.getArgs() + ", body=" + this.getBody() + ", type=" + this.getType() + ", formatting=" + this.getFormatting() + ")";
        }

        public NewClass withClazz(TypeTree clazz) {
            return this.clazz == clazz ? this : new NewClass(this.id, clazz, this.args, this.body, this.type, this.formatting);
        }

        public NewClass withArgs(Arguments args) {
            return this.args == args ? this : new NewClass(this.id, this.clazz, args, this.body, this.type, this.formatting);
        }

        public NewClass withBody(Block<? extends Tree> body) {
            return this.body == body ? this : new NewClass(this.id, this.clazz, this.args, body, this.type, this.formatting);
        }

        public NewClass withType(JavaType type) {
            return this.type == type ? this : new NewClass(this.id, this.clazz, this.args, this.body, type, this.formatting);
        }

        public NewClass withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new NewClass(this.id, this.clazz, this.args, this.body, this.type, formatting);
        }

        public static class Arguments
        implements J {
            private final UUID id;
            private final List<Expression> args;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Arguments)) {
                    return false;
                }
                Arguments other = (Arguments)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Arguments;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "args", "formatting"})
            public Arguments(UUID id, List<Expression> args, Formatting formatting) {
                this.id = id;
                this.args = args;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public List<Expression> getArgs() {
                return this.args;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.NewClass.Arguments(id=" + this.getId() + ", args=" + this.getArgs() + ", formatting=" + this.getFormatting() + ")";
            }

            public Arguments withArgs(List<Expression> args) {
                return this.args == args ? this : new Arguments(this.id, args, this.formatting);
            }

            public Arguments withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Arguments(this.id, this.args, formatting);
            }
        }
    }

    public static class NewArray
    implements J,
    Expression {
        private final UUID id;
        @Nullable
        private final TypeTree typeExpr;
        private final List<Dimension> dimensions;
        @Nullable
        private final Initializer initializer;
        @Nullable
        private final JavaType type;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitNewArray(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NewArray)) {
                return false;
            }
            NewArray other = (NewArray)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NewArray;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "typeExpr", "dimensions", "initializer", "type", "formatting"})
        public NewArray(UUID id, TypeTree typeExpr, List<Dimension> dimensions, Initializer initializer, JavaType type, Formatting formatting) {
            this.id = id;
            this.typeExpr = typeExpr;
            this.dimensions = dimensions;
            this.initializer = initializer;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public TypeTree getTypeExpr() {
            return this.typeExpr;
        }

        public List<Dimension> getDimensions() {
            return this.dimensions;
        }

        public Initializer getInitializer() {
            return this.initializer;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.NewArray(id=" + this.getId() + ", typeExpr=" + this.getTypeExpr() + ", dimensions=" + this.getDimensions() + ", initializer=" + this.getInitializer() + ", type=" + this.getType() + ", formatting=" + this.getFormatting() + ")";
        }

        public NewArray withTypeExpr(TypeTree typeExpr) {
            return this.typeExpr == typeExpr ? this : new NewArray(this.id, typeExpr, this.dimensions, this.initializer, this.type, this.formatting);
        }

        public NewArray withDimensions(List<Dimension> dimensions) {
            return this.dimensions == dimensions ? this : new NewArray(this.id, this.typeExpr, dimensions, this.initializer, this.type, this.formatting);
        }

        public NewArray withInitializer(Initializer initializer) {
            return this.initializer == initializer ? this : new NewArray(this.id, this.typeExpr, this.dimensions, initializer, this.type, this.formatting);
        }

        public NewArray withType(JavaType type) {
            return this.type == type ? this : new NewArray(this.id, this.typeExpr, this.dimensions, this.initializer, type, this.formatting);
        }

        public NewArray withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new NewArray(this.id, this.typeExpr, this.dimensions, this.initializer, this.type, formatting);
        }

        public static class Initializer
        implements J {
            private final UUID id;
            private final List<Expression> elements;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Initializer)) {
                    return false;
                }
                Initializer other = (Initializer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Initializer;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "elements", "formatting"})
            public Initializer(UUID id, List<Expression> elements, Formatting formatting) {
                this.id = id;
                this.elements = elements;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public List<Expression> getElements() {
                return this.elements;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.NewArray.Initializer(id=" + this.getId() + ", elements=" + this.getElements() + ", formatting=" + this.getFormatting() + ")";
            }

            public Initializer withElements(List<Expression> elements) {
                return this.elements == elements ? this : new Initializer(this.id, elements, this.formatting);
            }

            public Initializer withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Initializer(this.id, this.elements, formatting);
            }
        }

        public static class Dimension
        implements J {
            private final UUID id;
            private final Expression size;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dimension)) {
                    return false;
                }
                Dimension other = (Dimension)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Dimension;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "size", "formatting"})
            public Dimension(UUID id, Expression size, Formatting formatting) {
                this.id = id;
                this.size = size;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Expression getSize() {
                return this.size;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.NewArray.Dimension(id=" + this.getId() + ", size=" + this.getSize() + ", formatting=" + this.getFormatting() + ")";
            }

            public Dimension withSize(Expression size) {
                return this.size == size ? this : new Dimension(this.id, size, this.formatting);
            }

            public Dimension withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Dimension(this.id, this.size, formatting);
            }
        }
    }

    public static class MultiCatch
    implements J,
    TypeTree {
        private final UUID id;
        private final List<NameTree> alternatives;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitMultiCatch(this);
        }

        public MultiCatch withType(JavaType type) {
            return this;
        }

        @Override
        @JsonIgnore
        public JavaType getType() {
            return new JavaType.MultiCatch(this.alternatives.stream().filter(Objects::nonNull).map(NameTree::getType).collect(Collectors.toList()));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiCatch)) {
                return false;
            }
            MultiCatch other = (MultiCatch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MultiCatch;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "alternatives", "formatting"})
        public MultiCatch(UUID id, List<NameTree> alternatives, Formatting formatting) {
            this.id = id;
            this.alternatives = alternatives;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public List<NameTree> getAlternatives() {
            return this.alternatives;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.MultiCatch(id=" + this.getId() + ", alternatives=" + this.getAlternatives() + ", formatting=" + this.getFormatting() + ")";
        }

        public MultiCatch withAlternatives(List<NameTree> alternatives) {
            return this.alternatives == alternatives ? this : new MultiCatch(this.id, alternatives, this.formatting);
        }

        public MultiCatch withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new MultiCatch(this.id, this.alternatives, formatting);
        }
    }

    public static abstract class Modifier
    implements J {
        static boolean hasModifier(Collection<Modifier> modifiers, String modifier) {
            return modifiers.stream().anyMatch(m -> m.getClass().getSimpleName().toLowerCase().equals(modifier));
        }

        static List<Modifier> withModifiers(List<Modifier> existing, String ... modifierKeywords) {
            boolean visibilityChanged = false;
            ArrayList<Modifier> modifiers = new ArrayList<Modifier>(existing);
            for (String modifier : modifierKeywords) {
                Modifier m;
                int i;
                int sizeBeforeAdd = modifiers.size();
                if ("final".equals(modifier) && !Modifier.hasModifier(existing, "final")) {
                    boolean finalAdded = false;
                    for (i = 0; i < sizeBeforeAdd; ++i) {
                        m = (Modifier)modifiers.get(i);
                        if (m instanceof Static) {
                            modifiers.add(i + 1, new Final(Tree.randomId(), Formatting.format((String)" ")));
                            finalAdded = true;
                            break;
                        }
                        if (i != modifiers.size() - 1) continue;
                        modifiers.set(i, (Modifier)m.withSuffix(""));
                        modifiers.add(i + 1, new Final(Tree.randomId(), Formatting.format((String)" ", (String)m.getFormatting().getSuffix())));
                        finalAdded = true;
                    }
                    if (finalAdded) continue;
                    modifiers.add(0, new Final(Tree.randomId(), Formatting.EMPTY));
                    continue;
                }
                if ("static".equals(modifier) && !Modifier.hasModifier(existing, "static")) {
                    boolean staticAdded = false;
                    int afterAccessModifier = 0;
                    for (int i2 = 0; i2 < sizeBeforeAdd; ++i2) {
                        Modifier m2 = (Modifier)modifiers.get(i2);
                        if (m2 instanceof Private || m2 instanceof Protected || m2 instanceof Public) {
                            afterAccessModifier = i2 + 1;
                        } else if (m2 instanceof Final) {
                            modifiers.set(i2, (Modifier)m2.withFormatting(Formatting.format((String)" ", (String)m2.getFormatting().getSuffix())));
                            modifiers.add(i2, new Static(Tree.randomId(), Formatting.format((String)m2.getFormatting().getPrefix())));
                            staticAdded = true;
                            break;
                        }
                        if (i2 != modifiers.size() - 1) continue;
                        modifiers.set(i2, (Modifier)m2.withSuffix(""));
                        modifiers.add(afterAccessModifier, new Static(Tree.randomId(), Formatting.format((String)" ", (String)m2.getFormatting().getSuffix())));
                        staticAdded = true;
                    }
                    if (staticAdded) continue;
                    modifiers.add(0, new Static(Tree.randomId(), Formatting.EMPTY));
                    continue;
                }
                if (!"public".equals(modifier) && !"protected".equals(modifier) && !"private".equals(modifier) || Modifier.hasModifier(existing, modifier)) continue;
                boolean accessModifierAdded = false;
                for (i = 0; i < sizeBeforeAdd; ++i) {
                    m = (Modifier)modifiers.get(i);
                    if (m instanceof Private || m instanceof Protected || m instanceof Public) {
                        modifiers.set(i, Modifier.buildModifier(modifier, m.getFormatting()));
                        accessModifierAdded = true;
                        visibilityChanged = true;
                        break;
                    }
                    if (i != modifiers.size() - 1) continue;
                    modifiers.add(0, Modifier.buildModifier(modifier, Formatting.format((String)((Modifier)modifiers.get(0)).getFormatting().getPrefix(), (String)m.getFormatting().getSuffix())));
                    modifiers.set(i + 1, (Modifier)m.withFormatting(Formatting.format((String)" ", (String)"")));
                    accessModifierAdded = true;
                }
                if (accessModifierAdded) continue;
                modifiers.add(0, Modifier.buildModifier(modifier, Formatting.EMPTY));
            }
            return visibilityChanged || modifiers.size() > existing.size() ? modifiers : existing;
        }

        private static Modifier buildModifier(String modifier, Formatting formatting) {
            Modifier access;
            switch (modifier) {
                case "public": {
                    access = new Public(Tree.randomId(), formatting);
                    break;
                }
                case "protected": {
                    access = new Protected(Tree.randomId(), formatting);
                    break;
                }
                default: {
                    access = new Private(Tree.randomId(), formatting);
                }
            }
            return access;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Modifier)) {
                return false;
            }
            Modifier other = (Modifier)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof Modifier;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public static class Volatile
        extends Modifier {
            private final UUID id;
            private final Formatting formatting;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Volatile)) {
                    return false;
                }
                Volatile other = (Volatile)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Volatile;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public Volatile(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Modifier.Volatile(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public Volatile withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Volatile(this.id, formatting);
            }
        }

        public static class Transient
        extends Modifier {
            private final UUID id;
            private final Formatting formatting;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Transient)) {
                    return false;
                }
                Transient other = (Transient)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Transient;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public Transient(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Modifier.Transient(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public Transient withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Transient(this.id, formatting);
            }
        }

        public static class Synchronized
        extends Modifier {
            private final UUID id;
            private final Formatting formatting;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Synchronized)) {
                    return false;
                }
                Synchronized other = (Synchronized)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Synchronized;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public Synchronized(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Modifier.Synchronized(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public Synchronized withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Synchronized(this.id, formatting);
            }
        }

        public static class Strictfp
        extends Modifier {
            private final UUID id;
            private final Formatting formatting;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Strictfp)) {
                    return false;
                }
                Strictfp other = (Strictfp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Strictfp;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public Strictfp(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Modifier.Strictfp(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public Strictfp withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Strictfp(this.id, formatting);
            }
        }

        public static class Native
        extends Modifier {
            private final UUID id;
            private final Formatting formatting;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Native)) {
                    return false;
                }
                Native other = (Native)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Native;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public Native(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Modifier.Native(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public Native withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Native(this.id, formatting);
            }
        }

        public static class Final
        extends Modifier {
            private final UUID id;
            private final Formatting formatting;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Final)) {
                    return false;
                }
                Final other = (Final)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Final;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public Final(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Modifier.Final(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public Final withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Final(this.id, formatting);
            }
        }

        public static class Static
        extends Modifier {
            private final UUID id;
            private final Formatting formatting;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Static)) {
                    return false;
                }
                Static other = (Static)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Static;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public Static(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Modifier.Static(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public Static withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Static(this.id, formatting);
            }
        }

        public static class Abstract
        extends Modifier {
            private final UUID id;
            private final Formatting formatting;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Abstract)) {
                    return false;
                }
                Abstract other = (Abstract)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Abstract;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public Abstract(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Modifier.Abstract(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public Abstract withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Abstract(this.id, formatting);
            }
        }

        public static class Private
        extends Modifier {
            private final UUID id;
            private final Formatting formatting;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Private)) {
                    return false;
                }
                Private other = (Private)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Private;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public Private(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Modifier.Private(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public Private withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Private(this.id, formatting);
            }
        }

        public static class Protected
        extends Modifier {
            private final UUID id;
            private final Formatting formatting;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Protected)) {
                    return false;
                }
                Protected other = (Protected)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Protected;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public Protected(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Modifier.Protected(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public Protected withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Protected(this.id, formatting);
            }
        }

        public static class Public
        extends Modifier {
            private final UUID id;
            private final Formatting formatting;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Public)) {
                    return false;
                }
                Public other = (Public)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Public;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public Public(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Modifier.Public(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public Public withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Public(this.id, formatting);
            }
        }

        public static class Default
        extends Modifier {
            private final UUID id;
            private final Formatting formatting;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Default)) {
                    return false;
                }
                Default other = (Default)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Default;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public Default(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Modifier.Default(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public Default withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Default(this.id, formatting);
            }
        }
    }

    public static class MethodInvocation
    implements J,
    Statement,
    Expression {
        private final UUID id;
        @Nullable
        private final Expression select;
        @Nullable
        private final TypeParameters typeParameters;
        private final Ident name;
        private final Arguments args;
        @Nullable
        private final JavaType.Method type;
        private final Formatting formatting;

        public MethodInvocation withType(JavaType type) {
            if (type instanceof JavaType.Method) {
                return new MethodInvocation(this.id, this.select, this.typeParameters, this.name, this.args, (JavaType.Method)type, this.formatting);
            }
            return this;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitMethodInvocation(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        @JsonIgnore
        @Nullable
        public JavaType getReturnType() {
            return this.type == null ? null : (this.type.getResolvedSignature() == null ? null : this.type.getResolvedSignature().getReturnType());
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodInvocation)) {
                return false;
            }
            MethodInvocation other = (MethodInvocation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MethodInvocation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "select", "typeParameters", "name", "args", "type", "formatting"})
        public MethodInvocation(UUID id, Expression select, TypeParameters typeParameters, Ident name, Arguments args, JavaType.Method type, Formatting formatting) {
            this.id = id;
            this.select = select;
            this.typeParameters = typeParameters;
            this.name = name;
            this.args = args;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getSelect() {
            return this.select;
        }

        public TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        public Ident getName() {
            return this.name;
        }

        public Arguments getArgs() {
            return this.args;
        }

        @Override
        public JavaType.Method getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.MethodInvocation(id=" + this.getId() + ", select=" + this.getSelect() + ", typeParameters=" + this.getTypeParameters() + ", name=" + this.getName() + ", args=" + this.getArgs() + ", type=" + this.getType() + ", formatting=" + this.getFormatting() + ")";
        }

        public MethodInvocation withSelect(Expression select) {
            return this.select == select ? this : new MethodInvocation(this.id, select, this.typeParameters, this.name, this.args, this.type, this.formatting);
        }

        public MethodInvocation withTypeParameters(TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new MethodInvocation(this.id, this.select, typeParameters, this.name, this.args, this.type, this.formatting);
        }

        public MethodInvocation withName(Ident name) {
            return this.name == name ? this : new MethodInvocation(this.id, this.select, this.typeParameters, name, this.args, this.type, this.formatting);
        }

        public MethodInvocation withArgs(Arguments args) {
            return this.args == args ? this : new MethodInvocation(this.id, this.select, this.typeParameters, this.name, args, this.type, this.formatting);
        }

        public MethodInvocation withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new MethodInvocation(this.id, this.select, this.typeParameters, this.name, this.args, this.type, formatting);
        }

        public static class Arguments
        implements J {
            private final UUID id;
            private final List<Expression> args;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Arguments)) {
                    return false;
                }
                Arguments other = (Arguments)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Arguments;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "args", "formatting"})
            public Arguments(UUID id, List<Expression> args, Formatting formatting) {
                this.id = id;
                this.args = args;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public List<Expression> getArgs() {
                return this.args;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.MethodInvocation.Arguments(id=" + this.getId() + ", args=" + this.getArgs() + ", formatting=" + this.getFormatting() + ")";
            }

            public Arguments withArgs(List<Expression> args) {
                return this.args == args ? this : new Arguments(this.id, args, this.formatting);
            }

            public Arguments withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Arguments(this.id, this.args, formatting);
            }
        }
    }

    public static class MethodDecl
    implements J {
        private final UUID id;
        private final List<Annotation> annotations;
        private final List<Modifier> modifiers;
        @Nullable
        private final TypeParameters typeParameters;
        @Nullable
        private final TypeTree returnTypeExpr;
        private final Ident name;
        private final Parameters params;
        @Nullable
        private final Throws throwz;
        @Nullable
        private final Block<Statement> body;
        @Nullable
        private final Default defaultValue;
        private final Formatting formatting;

        public MethodDecl withModifiers(List<Modifier> modifiers) {
            if (modifiers == this.modifiers) {
                return this;
            }
            return new MethodDecl(this.id, this.annotations, modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.formatting);
        }

        public MethodDecl withModifiers(String ... modifierKeywords) {
            List<Modifier> fixedModifiers = Modifier.withModifiers(this.modifiers, modifierKeywords);
            if (fixedModifiers == this.modifiers) {
                return this;
            }
            if (this.modifiers.isEmpty()) {
                if (this.typeParameters != null) {
                    return this.withModifiers(Formatting.formatFirstPrefix(fixedModifiers, (String)this.typeParameters.getFormatting().getPrefix())).withTypeParameters((TypeParameters)this.typeParameters.withPrefix(" "));
                }
                if (this.returnTypeExpr != null) {
                    return this.withModifiers(Formatting.formatFirstPrefix(fixedModifiers, (String)this.returnTypeExpr.getFormatting().getPrefix())).withReturnTypeExpr((TypeTree)this.returnTypeExpr.withPrefix(" "));
                }
                return this.withModifiers(Formatting.formatFirstPrefix(fixedModifiers, (String)this.name.getFormatting().getPrefix())).withName((Ident)this.name.withPrefix(" "));
            }
            return this.withModifiers(fixedModifiers);
        }

        public MethodDecl withThrows(Throws throwz) {
            if (throwz == this.throwz) {
                return this;
            }
            return new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, throwz, this.body, this.defaultValue, this.formatting);
        }

        @JsonProperty(value="throwz")
        @Nullable
        public Throws getThrows() {
            return this.throwz;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitMethod(this);
        }

        @JsonIgnore
        public boolean isAbstract() {
            return this.body == null;
        }

        public boolean hasType(String clazz) {
            return (Boolean)new HasType(clazz).visit(this);
        }

        public List<Annotation> findAnnotations(String signature) {
            return (List)new FindAnnotations(signature).visit(this);
        }

        @JsonIgnore
        public boolean isConstructor() {
            return this.getReturnTypeExpr() == null;
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        public boolean hasModifier(String modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodDecl)) {
                return false;
            }
            MethodDecl other = (MethodDecl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MethodDecl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "annotations", "modifiers", "typeParameters", "returnTypeExpr", "name", "params", "throwz", "body", "defaultValue", "formatting"})
        public MethodDecl(UUID id, List<Annotation> annotations, List<Modifier> modifiers, TypeParameters typeParameters, TypeTree returnTypeExpr, Ident name, Parameters params, Throws throwz, Block<Statement> body, Default defaultValue, Formatting formatting) {
            this.id = id;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.typeParameters = typeParameters;
            this.returnTypeExpr = returnTypeExpr;
            this.name = name;
            this.params = params;
            this.throwz = throwz;
            this.body = body;
            this.defaultValue = defaultValue;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public MethodDecl withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new MethodDecl(this.id, annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.formatting);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        public MethodDecl withTypeParameters(TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new MethodDecl(this.id, this.annotations, this.modifiers, typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.formatting);
        }

        public TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        public MethodDecl withReturnTypeExpr(TypeTree returnTypeExpr) {
            return this.returnTypeExpr == returnTypeExpr ? this : new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.formatting);
        }

        public TypeTree getReturnTypeExpr() {
            return this.returnTypeExpr;
        }

        public MethodDecl withName(Ident name) {
            return this.name == name ? this : new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, name, this.params, this.throwz, this.body, this.defaultValue, this.formatting);
        }

        public Ident getName() {
            return this.name;
        }

        public MethodDecl withParams(Parameters params) {
            return this.params == params ? this : new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, params, this.throwz, this.body, this.defaultValue, this.formatting);
        }

        public Parameters getParams() {
            return this.params;
        }

        public MethodDecl withBody(Block<Statement> body) {
            return this.body == body ? this : new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, body, this.defaultValue, this.formatting);
        }

        public Block<Statement> getBody() {
            return this.body;
        }

        public MethodDecl withDefaultValue(Default defaultValue) {
            return this.defaultValue == defaultValue ? this : new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, defaultValue, this.formatting);
        }

        public Default getDefaultValue() {
            return this.defaultValue;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public MethodDecl withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, formatting);
        }

        public static class Default
        implements J {
            private final UUID id;
            private final Expression value;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Default)) {
                    return false;
                }
                Default other = (Default)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Default;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "value", "formatting"})
            public Default(UUID id, Expression value, Formatting formatting) {
                this.id = id;
                this.value = value;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Expression getValue() {
                return this.value;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.MethodDecl.Default(id=" + this.getId() + ", value=" + this.getValue() + ", formatting=" + this.getFormatting() + ")";
            }

            public Default withValue(Expression value) {
                return this.value == value ? this : new Default(this.id, value, this.formatting);
            }

            public Default withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Default(this.id, this.value, formatting);
            }
        }

        public static class Throws
        implements J {
            private final UUID id;
            private final List<NameTree> exceptions;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Throws)) {
                    return false;
                }
                Throws other = (Throws)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Throws;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "exceptions", "formatting"})
            public Throws(UUID id, List<NameTree> exceptions, Formatting formatting) {
                this.id = id;
                this.exceptions = exceptions;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public List<NameTree> getExceptions() {
                return this.exceptions;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.MethodDecl.Throws(id=" + this.getId() + ", exceptions=" + this.getExceptions() + ", formatting=" + this.getFormatting() + ")";
            }

            public Throws withExceptions(List<NameTree> exceptions) {
                return this.exceptions == exceptions ? this : new Throws(this.id, exceptions, this.formatting);
            }

            public Throws withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Throws(this.id, this.exceptions, formatting);
            }
        }

        public static class Parameters
        implements J {
            private final UUID id;
            private final List<Statement> params;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Parameters)) {
                    return false;
                }
                Parameters other = (Parameters)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Parameters;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "params", "formatting"})
            public Parameters(UUID id, List<Statement> params, Formatting formatting) {
                this.id = id;
                this.params = params;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public List<Statement> getParams() {
                return this.params;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.MethodDecl.Parameters(id=" + this.getId() + ", params=" + this.getParams() + ", formatting=" + this.getFormatting() + ")";
            }

            public Parameters withParams(List<Statement> params) {
                return this.params == params ? this : new Parameters(this.id, params, this.formatting);
            }

            public Parameters withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Parameters(this.id, this.params, formatting);
            }
        }
    }

    public static class MemberReference
    implements J,
    Expression {
        private final UUID id;
        private final Expression containing;
        @Nullable
        private final TypeParameters typeParameters;
        private final Ident reference;
        @Nullable
        private final JavaType type;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitMemberReference(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MemberReference)) {
                return false;
            }
            MemberReference other = (MemberReference)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MemberReference;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "containing", "typeParameters", "reference", "type", "formatting"})
        public MemberReference(UUID id, Expression containing, TypeParameters typeParameters, Ident reference, JavaType type, Formatting formatting) {
            this.id = id;
            this.containing = containing;
            this.typeParameters = typeParameters;
            this.reference = reference;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getContaining() {
            return this.containing;
        }

        public TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        public Ident getReference() {
            return this.reference;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.MemberReference(id=" + this.getId() + ", containing=" + this.getContaining() + ", typeParameters=" + this.getTypeParameters() + ", reference=" + this.getReference() + ", type=" + this.getType() + ", formatting=" + this.getFormatting() + ")";
        }

        public MemberReference withContaining(Expression containing) {
            return this.containing == containing ? this : new MemberReference(this.id, containing, this.typeParameters, this.reference, this.type, this.formatting);
        }

        public MemberReference withTypeParameters(TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new MemberReference(this.id, this.containing, typeParameters, this.reference, this.type, this.formatting);
        }

        public MemberReference withReference(Ident reference) {
            return this.reference == reference ? this : new MemberReference(this.id, this.containing, this.typeParameters, reference, this.type, this.formatting);
        }

        public MemberReference withType(JavaType type) {
            return this.type == type ? this : new MemberReference(this.id, this.containing, this.typeParameters, this.reference, type, this.formatting);
        }

        public MemberReference withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new MemberReference(this.id, this.containing, this.typeParameters, this.reference, this.type, formatting);
        }
    }

    public static class Literal
    implements J,
    Expression {
        private final UUID id;
        @Nullable
        private final Object value;
        private final String valueSource;
        private final JavaType.Primitive type;
        private final Formatting formatting;

        public Literal withType(JavaType type) {
            if (type instanceof JavaType.Primitive) {
                return new Literal(this.id, this.value, this.valueSource, (JavaType.Primitive)type, this.formatting);
            }
            return this;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitLiteral(this);
        }

        public <T> String transformValue(Function<T, Object> transform) {
            Matcher valueMatcher = Pattern.compile("(.*)" + Pattern.quote(this.value == null ? "null" : this.value.toString()) + "(.*)").matcher(this.printTrimmed().replace("\\", ""));
            if (valueMatcher.find()) {
                String prefix = valueMatcher.group(1);
                String suffix = valueMatcher.group(2);
                return prefix + transform.apply(this.value) + suffix;
            }
            throw new IllegalStateException("Encountered a literal `" + this + "` that could not be transformed");
        }

        public static Literal buildString(String value) {
            return new Literal(Tree.randomId(), value, "\"" + value + "\"", JavaType.Primitive.String, Formatting.EMPTY);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal other = (Literal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Literal;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "value", "valueSource", "type", "formatting"})
        public Literal(UUID id, Object value, String valueSource, JavaType.Primitive type, Formatting formatting) {
            this.id = id;
            this.value = value;
            this.valueSource = valueSource;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Object getValue() {
            return this.value;
        }

        public String getValueSource() {
            return this.valueSource;
        }

        @Override
        public JavaType.Primitive getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Literal(id=" + this.getId() + ", value=" + this.getValue() + ", valueSource=" + this.getValueSource() + ", type=" + this.getType() + ", formatting=" + this.getFormatting() + ")";
        }

        public Literal withValue(Object value) {
            return this.value == value ? this : new Literal(this.id, value, this.valueSource, this.type, this.formatting);
        }

        public Literal withValueSource(String valueSource) {
            return this.valueSource == valueSource ? this : new Literal(this.id, this.value, valueSource, this.type, this.formatting);
        }

        public Literal withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Literal(this.id, this.value, this.valueSource, this.type, formatting);
        }
    }

    public static class Lambda
    implements J,
    Expression {
        private final UUID id;
        private final Parameters paramSet;
        private final Arrow arrow;
        private final Tree body;
        @Nullable
        private final JavaType type;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitLambda(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Lambda)) {
                return false;
            }
            Lambda other = (Lambda)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Lambda;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "paramSet", "arrow", "body", "type", "formatting"})
        public Lambda(UUID id, Parameters paramSet, Arrow arrow, Tree body, JavaType type, Formatting formatting) {
            this.id = id;
            this.paramSet = paramSet;
            this.arrow = arrow;
            this.body = body;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Parameters getParamSet() {
            return this.paramSet;
        }

        public Arrow getArrow() {
            return this.arrow;
        }

        public Tree getBody() {
            return this.body;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Lambda(id=" + this.getId() + ", paramSet=" + this.getParamSet() + ", arrow=" + this.getArrow() + ", body=" + this.getBody() + ", type=" + this.getType() + ", formatting=" + this.getFormatting() + ")";
        }

        public Lambda withParamSet(Parameters paramSet) {
            return this.paramSet == paramSet ? this : new Lambda(this.id, paramSet, this.arrow, this.body, this.type, this.formatting);
        }

        public Lambda withArrow(Arrow arrow) {
            return this.arrow == arrow ? this : new Lambda(this.id, this.paramSet, arrow, this.body, this.type, this.formatting);
        }

        public Lambda withBody(Tree body) {
            return this.body == body ? this : new Lambda(this.id, this.paramSet, this.arrow, body, this.type, this.formatting);
        }

        public Lambda withType(JavaType type) {
            return this.type == type ? this : new Lambda(this.id, this.paramSet, this.arrow, this.body, type, this.formatting);
        }

        public Lambda withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Lambda(this.id, this.paramSet, this.arrow, this.body, this.type, formatting);
        }

        public static class Parameters
        implements J {
            private final UUID id;
            private final boolean parenthesized;
            private final List<? extends Tree> params;
            private final Formatting formatting = Formatting.EMPTY;

            public <T extends Tree> T withFormatting(Formatting fmt) {
                return (T)this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Parameters)) {
                    return false;
                }
                Parameters other = (Parameters)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Parameters;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "parenthesized", "params"})
            public Parameters(UUID id, boolean parenthesized, List<? extends Tree> params) {
                this.id = id;
                this.parenthesized = parenthesized;
                this.params = params;
            }

            public UUID getId() {
                return this.id;
            }

            public boolean isParenthesized() {
                return this.parenthesized;
            }

            public List<? extends Tree> getParams() {
                return this.params;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Lambda.Parameters(id=" + this.getId() + ", parenthesized=" + this.isParenthesized() + ", params=" + this.getParams() + ", formatting=" + this.getFormatting() + ")";
            }

            public Parameters withParenthesized(boolean parenthesized) {
                return this.parenthesized == parenthesized ? this : new Parameters(this.id, parenthesized, this.params);
            }

            public Parameters withParams(List<? extends Tree> params) {
                return this.params == params ? this : new Parameters(this.id, this.parenthesized, params);
            }
        }

        public static class Arrow
        implements J {
            private final UUID id;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Arrow)) {
                    return false;
                }
                Arrow other = (Arrow)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Arrow;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public Arrow(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Lambda.Arrow(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public Arrow withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Arrow(this.id, formatting);
            }
        }
    }

    public static class Label
    implements J,
    Statement {
        private final UUID id;
        private final Ident label;
        private final Statement statement;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitLabel(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Label)) {
                return false;
            }
            Label other = (Label)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Label;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "label", "statement", "formatting"})
        public Label(UUID id, Ident label, Statement statement, Formatting formatting) {
            this.id = id;
            this.label = label;
            this.statement = statement;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Ident getLabel() {
            return this.label;
        }

        public Statement getStatement() {
            return this.statement;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Label(id=" + this.getId() + ", label=" + this.getLabel() + ", statement=" + this.getStatement() + ", formatting=" + this.getFormatting() + ")";
        }

        public Label withLabel(Ident label) {
            return this.label == label ? this : new Label(this.id, label, this.statement, this.formatting);
        }

        public Label withStatement(Statement statement) {
            return this.statement == statement ? this : new Label(this.id, this.label, statement, this.formatting);
        }

        public Label withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Label(this.id, this.label, this.statement, formatting);
        }
    }

    public static class InstanceOf
    implements J,
    Expression {
        private final UUID id;
        private final Expression expr;
        private final Tree clazz;
        @Nullable
        private final JavaType type;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitInstanceOf(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceOf)) {
                return false;
            }
            InstanceOf other = (InstanceOf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InstanceOf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "expr", "clazz", "type", "formatting"})
        public InstanceOf(UUID id, Expression expr, Tree clazz, JavaType type, Formatting formatting) {
            this.id = id;
            this.expr = expr;
            this.clazz = clazz;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getExpr() {
            return this.expr;
        }

        public Tree getClazz() {
            return this.clazz;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.InstanceOf(id=" + this.getId() + ", expr=" + this.getExpr() + ", clazz=" + this.getClazz() + ", type=" + this.getType() + ", formatting=" + this.getFormatting() + ")";
        }

        public InstanceOf withExpr(Expression expr) {
            return this.expr == expr ? this : new InstanceOf(this.id, expr, this.clazz, this.type, this.formatting);
        }

        public InstanceOf withClazz(Tree clazz) {
            return this.clazz == clazz ? this : new InstanceOf(this.id, this.expr, clazz, this.type, this.formatting);
        }

        public InstanceOf withType(JavaType type) {
            return this.type == type ? this : new InstanceOf(this.id, this.expr, this.clazz, type, this.formatting);
        }

        public InstanceOf withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new InstanceOf(this.id, this.expr, this.clazz, this.type, formatting);
        }
    }

    public static class Import
    implements J,
    Comparable<Import> {
        private final UUID id;
        private final FieldAccess qualid;
        private final boolean statik;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitImport(this);
        }

        public boolean isStatic() {
            return this.statik;
        }

        @JsonIgnore
        public boolean isFromType(String clazz) {
            if ("*".equals(this.qualid.getSimpleName())) {
                return this.qualid.target.printTrimmed().equals(Arrays.stream(clazz.split("\\.")).filter(pkgOrNam -> Character.isLowerCase(pkgOrNam.charAt(0))).collect(Collectors.joining(".")));
            }
            return (this.isStatic() ? this.qualid.getTarget().printTrimmed() : this.qualid.printTrimmed()).equals(clazz);
        }

        public String getTypeName() {
            return this.isStatic() ? this.qualid.getTarget().printTrimmed() : this.qualid.printTrimmed();
        }

        @JsonIgnore
        public String getPackageName() {
            JavaType.Class importType = TypeUtils.asClass(this.qualid.getType());
            if (importType != null) {
                return importType.getPackageName();
            }
            AtomicBoolean takeWhile = new AtomicBoolean(true);
            return Arrays.stream(this.qualid.getTarget().printTrimmed().split("\\.")).filter(pkg -> {
                takeWhile.set(takeWhile.get() && !pkg.isEmpty() && Character.isLowerCase(pkg.charAt(0)));
                return takeWhile.get();
            }).collect(Collectors.joining("."));
        }

        @Override
        public int compareTo(Import o) {
            String p1 = this.getPackageName();
            String p2 = o.getPackageName();
            String[] p1s = p1.split("\\.");
            String[] p2s = p2.split("\\.");
            for (int i = 0; i < p1s.length; ++i) {
                String s = p1s[i];
                if (p2s.length < i + 1) {
                    return 1;
                }
                if (s.equals(p2s[i])) continue;
                return s.compareTo(p2s[i]);
            }
            return p1s.length < p2s.length ? -1 : this.getQualid().getSimpleName().compareTo(o.getQualid().getSimpleName());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Import)) {
                return false;
            }
            Import other = (Import)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Import;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "qualid", "statik", "formatting"})
        public Import(UUID id, FieldAccess qualid, boolean statik, Formatting formatting) {
            this.id = id;
            this.qualid = qualid;
            this.statik = statik;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Import withQualid(FieldAccess qualid) {
            return this.qualid == qualid ? this : new Import(this.id, qualid, this.statik, this.formatting);
        }

        public FieldAccess getQualid() {
            return this.qualid;
        }

        public Import withStatik(boolean statik) {
            return this.statik == statik ? this : new Import(this.id, this.qualid, statik, this.formatting);
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Import withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Import(this.id, this.qualid, this.statik, formatting);
        }
    }

    public static class If
    implements J,
    Statement {
        private final UUID id;
        private final Parentheses<Expression> ifCondition;
        private final Statement thenPart;
        @Nullable
        private final Else elsePart;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitIf(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof If)) {
                return false;
            }
            If other = (If)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof If;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "ifCondition", "thenPart", "elsePart", "formatting"})
        public If(UUID id, Parentheses<Expression> ifCondition, Statement thenPart, Else elsePart, Formatting formatting) {
            this.id = id;
            this.ifCondition = ifCondition;
            this.thenPart = thenPart;
            this.elsePart = elsePart;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Parentheses<Expression> getIfCondition() {
            return this.ifCondition;
        }

        public Statement getThenPart() {
            return this.thenPart;
        }

        public Else getElsePart() {
            return this.elsePart;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.If(id=" + this.getId() + ", ifCondition=" + this.getIfCondition() + ", thenPart=" + this.getThenPart() + ", elsePart=" + this.getElsePart() + ", formatting=" + this.getFormatting() + ")";
        }

        public If withIfCondition(Parentheses<Expression> ifCondition) {
            return this.ifCondition == ifCondition ? this : new If(this.id, ifCondition, this.thenPart, this.elsePart, this.formatting);
        }

        public If withThenPart(Statement thenPart) {
            return this.thenPart == thenPart ? this : new If(this.id, this.ifCondition, thenPart, this.elsePart, this.formatting);
        }

        public If withElsePart(Else elsePart) {
            return this.elsePart == elsePart ? this : new If(this.id, this.ifCondition, this.thenPart, elsePart, this.formatting);
        }

        public If withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new If(this.id, this.ifCondition, this.thenPart, this.elsePart, formatting);
        }

        public static class Else
        implements J {
            private final UUID id;
            private final Statement statement;
            private final Formatting formatting;

            @Override
            public <R> R acceptJava(JavaSourceVisitor<R> v) {
                return v.visitElse(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Else)) {
                    return false;
                }
                Else other = (Else)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Else;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "statement", "formatting"})
            public Else(UUID id, Statement statement, Formatting formatting) {
                this.id = id;
                this.statement = statement;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Statement getStatement() {
                return this.statement;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.If.Else(id=" + this.getId() + ", statement=" + this.getStatement() + ", formatting=" + this.getFormatting() + ")";
            }

            public Else withStatement(Statement statement) {
                return this.statement == statement ? this : new Else(this.id, statement, this.formatting);
            }

            public Else withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Else(this.id, this.statement, formatting);
            }
        }
    }

    public static class Ident
    implements J,
    TypeTree,
    Expression {
        private static final Map<String, Map<JavaType, IdentFlyweight>> flyweights = HashObjObjMaps.newMutableMap();
        private final UUID id;
        private final IdentFlyweight ident;
        private final Formatting formatting;

        private Ident(UUID id, IdentFlyweight ident, Formatting formatting) {
            this.id = id;
            this.ident = ident;
            this.formatting = formatting;
        }

        @Override
        public JavaType getType() {
            return this.ident.getType();
        }

        public Ident withType(JavaType type) {
            return Ident.build(this.id, this.getSimpleName(), type, this.formatting);
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.ident.getSimpleName();
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitIdentifier(this);
        }

        public Ident withName(String name) {
            return Ident.build(this.id, name, this.getType(), this.formatting);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JsonCreator
        public static Ident build(@JsonProperty(value="id") UUID id, @JsonProperty(value="simpleName") String simpleName, @JsonProperty(value="type") @Nullable JavaType type, @JsonProperty(value="formatting") Formatting formatting) {
            Map<String, Map<JavaType, IdentFlyweight>> map = flyweights;
            synchronized (map) {
                return new Ident(id, flyweights.computeIfAbsent(simpleName, n -> HashObjObjMaps.newMutableMap()).computeIfAbsent(type, t -> new IdentFlyweight(simpleName, (JavaType)t)), formatting);
            }
        }

        public static Ident buildClassName(String fullyQualifiedName) {
            JavaType.Class classType = JavaType.Class.build(fullyQualifiedName);
            return Ident.build(Tree.randomId(), classType.getClassName(), classType, Formatting.EMPTY);
        }

        public String toString() {
            return "Ident(" + this.printTrimmed() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ident)) {
                return false;
            }
            Ident other = (Ident)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Ident;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public UUID getId() {
            return this.id;
        }

        public IdentFlyweight getIdent() {
            return this.ident;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Ident withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Ident(this.id, this.ident, formatting);
        }

        public static class IdentFlyweight
        implements Serializable {
            private final String simpleName;
            @Nullable
            private final JavaType type;

            @ConstructorProperties(value={"simpleName", "type"})
            public IdentFlyweight(String simpleName, JavaType type) {
                this.simpleName = simpleName;
                this.type = type;
            }

            public String getSimpleName() {
                return this.simpleName;
            }

            public JavaType getType() {
                return this.type;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IdentFlyweight)) {
                    return false;
                }
                IdentFlyweight other = (IdentFlyweight)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$simpleName = this.getSimpleName();
                String other$simpleName = other.getSimpleName();
                if (this$simpleName == null ? other$simpleName != null : !this$simpleName.equals(other$simpleName)) {
                    return false;
                }
                JavaType this$type = this.getType();
                JavaType other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            protected boolean canEqual(Object other) {
                return other instanceof IdentFlyweight;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $simpleName = this.getSimpleName();
                result = result * 59 + ($simpleName == null ? 43 : $simpleName.hashCode());
                JavaType $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public String toString() {
                return "J.Ident.IdentFlyweight(simpleName=" + this.getSimpleName() + ", type=" + this.getType() + ")";
            }
        }
    }

    public static class ForLoop
    implements J,
    Statement {
        private final UUID id;
        private final Control control;
        private final Statement body;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitForLoop(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForLoop)) {
                return false;
            }
            ForLoop other = (ForLoop)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForLoop;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "control", "body", "formatting"})
        public ForLoop(UUID id, Control control, Statement body, Formatting formatting) {
            this.id = id;
            this.control = control;
            this.body = body;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Control getControl() {
            return this.control;
        }

        public Statement getBody() {
            return this.body;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.ForLoop(id=" + this.getId() + ", control=" + this.getControl() + ", body=" + this.getBody() + ", formatting=" + this.getFormatting() + ")";
        }

        public ForLoop withControl(Control control) {
            return this.control == control ? this : new ForLoop(this.id, control, this.body, this.formatting);
        }

        public ForLoop withBody(Statement body) {
            return this.body == body ? this : new ForLoop(this.id, this.control, body, this.formatting);
        }

        public ForLoop withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new ForLoop(this.id, this.control, this.body, formatting);
        }

        public static class Control
        implements J {
            private final UUID id;
            private final Statement init;
            private final Expression condition;
            private final List<Statement> update;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Control)) {
                    return false;
                }
                Control other = (Control)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Control;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "init", "condition", "update", "formatting"})
            public Control(UUID id, Statement init, Expression condition, List<Statement> update, Formatting formatting) {
                this.id = id;
                this.init = init;
                this.condition = condition;
                this.update = update;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Statement getInit() {
                return this.init;
            }

            public Expression getCondition() {
                return this.condition;
            }

            public List<Statement> getUpdate() {
                return this.update;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.ForLoop.Control(id=" + this.getId() + ", init=" + this.getInit() + ", condition=" + this.getCondition() + ", update=" + this.getUpdate() + ", formatting=" + this.getFormatting() + ")";
            }

            public Control withInit(Statement init) {
                return this.init == init ? this : new Control(this.id, init, this.condition, this.update, this.formatting);
            }

            public Control withCondition(Expression condition) {
                return this.condition == condition ? this : new Control(this.id, this.init, condition, this.update, this.formatting);
            }

            public Control withUpdate(List<Statement> update) {
                return this.update == update ? this : new Control(this.id, this.init, this.condition, update, this.formatting);
            }

            public Control withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Control(this.id, this.init, this.condition, this.update, formatting);
            }
        }
    }

    public static class ForEachLoop
    implements J,
    Statement {
        private final UUID id;
        private final Control control;
        private final Statement body;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitForEachLoop(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForEachLoop)) {
                return false;
            }
            ForEachLoop other = (ForEachLoop)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForEachLoop;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "control", "body", "formatting"})
        public ForEachLoop(UUID id, Control control, Statement body, Formatting formatting) {
            this.id = id;
            this.control = control;
            this.body = body;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Control getControl() {
            return this.control;
        }

        public Statement getBody() {
            return this.body;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.ForEachLoop(id=" + this.getId() + ", control=" + this.getControl() + ", body=" + this.getBody() + ", formatting=" + this.getFormatting() + ")";
        }

        public ForEachLoop withControl(Control control) {
            return this.control == control ? this : new ForEachLoop(this.id, control, this.body, this.formatting);
        }

        public ForEachLoop withBody(Statement body) {
            return this.body == body ? this : new ForEachLoop(this.id, this.control, body, this.formatting);
        }

        public ForEachLoop withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new ForEachLoop(this.id, this.control, this.body, formatting);
        }

        public static class Control
        implements J {
            private final UUID id;
            private final VariableDecls variable;
            private final Expression iterable;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Control)) {
                    return false;
                }
                Control other = (Control)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Control;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "variable", "iterable", "formatting"})
            public Control(UUID id, VariableDecls variable, Expression iterable, Formatting formatting) {
                this.id = id;
                this.variable = variable;
                this.iterable = iterable;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public VariableDecls getVariable() {
                return this.variable;
            }

            public Expression getIterable() {
                return this.iterable;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.ForEachLoop.Control(id=" + this.getId() + ", variable=" + this.getVariable() + ", iterable=" + this.getIterable() + ", formatting=" + this.getFormatting() + ")";
            }

            public Control withVariable(VariableDecls variable) {
                return this.variable == variable ? this : new Control(this.id, variable, this.iterable, this.formatting);
            }

            public Control withIterable(Expression iterable) {
                return this.iterable == iterable ? this : new Control(this.id, this.variable, iterable, this.formatting);
            }

            public Control withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Control(this.id, this.variable, this.iterable, formatting);
            }
        }
    }

    public static class FieldAccess
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Expression target;
        private final Ident name;
        @Nullable
        private final JavaType type;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitFieldAccess(this);
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return this.target.getSideEffects();
        }

        public String toString() {
            return "FieldAccess(" + this.printTrimmed() + ")";
        }

        @Nullable
        public NameTree asClassReference() {
            if (this.target instanceof NameTree) {
                String fqn = null;
                if (this.type instanceof JavaType.Class) {
                    fqn = ((JavaType.Class)this.type).getFullyQualifiedName();
                } else if (this.type instanceof JavaType.ShallowClass) {
                    fqn = ((JavaType.ShallowClass)this.type).getFullyQualifiedName();
                }
                return "java.lang.Class".equals(fqn) ? (NameTree)((Object)this.target) : null;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldAccess)) {
                return false;
            }
            FieldAccess other = (FieldAccess)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldAccess;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "target", "name", "type", "formatting"})
        public FieldAccess(UUID id, Expression target, Ident name, JavaType type, Formatting formatting) {
            this.id = id;
            this.target = target;
            this.name = name;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getTarget() {
            return this.target;
        }

        public Ident getName() {
            return this.name;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public FieldAccess withTarget(Expression target) {
            return this.target == target ? this : new FieldAccess(this.id, target, this.name, this.type, this.formatting);
        }

        public FieldAccess withName(Ident name) {
            return this.name == name ? this : new FieldAccess(this.id, this.target, name, this.type, this.formatting);
        }

        public FieldAccess withType(JavaType type) {
            return this.type == type ? this : new FieldAccess(this.id, this.target, this.name, type, this.formatting);
        }

        public FieldAccess withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new FieldAccess(this.id, this.target, this.name, this.type, formatting);
        }
    }

    public static class EnumValueSet
    implements J,
    Statement {
        private final UUID id;
        private final List<EnumValue> enums;
        private final boolean terminatedWithSemicolon;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitEnumValueSet(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumValueSet)) {
                return false;
            }
            EnumValueSet other = (EnumValueSet)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnumValueSet;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "enums", "terminatedWithSemicolon", "formatting"})
        public EnumValueSet(UUID id, List<EnumValue> enums, boolean terminatedWithSemicolon, Formatting formatting) {
            this.id = id;
            this.enums = enums;
            this.terminatedWithSemicolon = terminatedWithSemicolon;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public List<EnumValue> getEnums() {
            return this.enums;
        }

        public boolean isTerminatedWithSemicolon() {
            return this.terminatedWithSemicolon;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.EnumValueSet(id=" + this.getId() + ", enums=" + this.getEnums() + ", terminatedWithSemicolon=" + this.isTerminatedWithSemicolon() + ", formatting=" + this.getFormatting() + ")";
        }

        public EnumValueSet withEnums(List<EnumValue> enums) {
            return this.enums == enums ? this : new EnumValueSet(this.id, enums, this.terminatedWithSemicolon, this.formatting);
        }

        public EnumValueSet withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new EnumValueSet(this.id, this.enums, this.terminatedWithSemicolon, formatting);
        }
    }

    public static class EnumValue
    implements J,
    Statement {
        private final UUID id;
        private final Ident name;
        @Nullable
        private final NewClass initializer;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitEnumValue(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumValue)) {
                return false;
            }
            EnumValue other = (EnumValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnumValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "name", "initializer", "formatting"})
        public EnumValue(UUID id, Ident name, NewClass initializer, Formatting formatting) {
            this.id = id;
            this.name = name;
            this.initializer = initializer;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Ident getName() {
            return this.name;
        }

        public NewClass getInitializer() {
            return this.initializer;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.EnumValue(id=" + this.getId() + ", name=" + this.getName() + ", initializer=" + this.getInitializer() + ", formatting=" + this.getFormatting() + ")";
        }

        public EnumValue withName(Ident name) {
            return this.name == name ? this : new EnumValue(this.id, name, this.initializer, this.formatting);
        }

        public EnumValue withInitializer(NewClass initializer) {
            return this.initializer == initializer ? this : new EnumValue(this.id, this.name, initializer, this.formatting);
        }

        public EnumValue withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new EnumValue(this.id, this.name, this.initializer, formatting);
        }
    }

    public static class Empty
    implements J,
    Statement,
    Expression,
    TypeTree {
        private final UUID id;
        private final Formatting formatting;

        @Override
        public JavaType getType() {
            return null;
        }

        public Empty withType(JavaType type) {
            return this;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitEmpty(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty other = (Empty)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Empty;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "formatting"})
        public Empty(UUID id, Formatting formatting) {
            this.id = id;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Empty(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
        }

        public Empty withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Empty(this.id, formatting);
        }
    }

    public static class DoWhileLoop
    implements J,
    Statement {
        private final UUID id;
        private final Statement body;
        private final While whileCondition;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitDoWhileLoop(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DoWhileLoop)) {
                return false;
            }
            DoWhileLoop other = (DoWhileLoop)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DoWhileLoop;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "body", "whileCondition", "formatting"})
        public DoWhileLoop(UUID id, Statement body, While whileCondition, Formatting formatting) {
            this.id = id;
            this.body = body;
            this.whileCondition = whileCondition;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Statement getBody() {
            return this.body;
        }

        public While getWhileCondition() {
            return this.whileCondition;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.DoWhileLoop(id=" + this.getId() + ", body=" + this.getBody() + ", whileCondition=" + this.getWhileCondition() + ", formatting=" + this.getFormatting() + ")";
        }

        public DoWhileLoop withBody(Statement body) {
            return this.body == body ? this : new DoWhileLoop(this.id, body, this.whileCondition, this.formatting);
        }

        public DoWhileLoop withWhileCondition(While whileCondition) {
            return this.whileCondition == whileCondition ? this : new DoWhileLoop(this.id, this.body, whileCondition, this.formatting);
        }

        public DoWhileLoop withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new DoWhileLoop(this.id, this.body, this.whileCondition, formatting);
        }

        public static class While
        implements J {
            private final UUID id;
            private final Parentheses<Expression> condition;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof While)) {
                    return false;
                }
                While other = (While)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof While;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "condition", "formatting"})
            public While(UUID id, Parentheses<Expression> condition, Formatting formatting) {
                this.id = id;
                this.condition = condition;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Parentheses<Expression> getCondition() {
                return this.condition;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.DoWhileLoop.While(id=" + this.getId() + ", condition=" + this.getCondition() + ", formatting=" + this.getFormatting() + ")";
            }

            public While withCondition(Parentheses<Expression> condition) {
                return this.condition == condition ? this : new While(this.id, condition, this.formatting);
            }

            public While withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new While(this.id, this.condition, formatting);
            }
        }
    }

    public static class Continue
    implements J,
    Statement {
        private final UUID id;
        @Nullable
        private final Ident label;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitContinue(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Continue)) {
                return false;
            }
            Continue other = (Continue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Continue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "label", "formatting"})
        public Continue(UUID id, Ident label, Formatting formatting) {
            this.id = id;
            this.label = label;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Ident getLabel() {
            return this.label;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Continue(id=" + this.getId() + ", label=" + this.getLabel() + ", formatting=" + this.getFormatting() + ")";
        }

        public Continue withLabel(Ident label) {
            return this.label == label ? this : new Continue(this.id, label, this.formatting);
        }

        public Continue withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Continue(this.id, this.label, formatting);
        }
    }

    public static class CompilationUnit
    implements J,
    SourceFile {
        private final UUID id;
        private final String sourcePath;
        private final Map<Metadata, String> metadata;
        @Nullable
        private final Package packageDecl;
        private final List<Import> imports;
        private final List<ClassDecl> classes;
        private final Formatting formatting;
        protected final String jacksonPolymorphicTypeTag = ".J$CompilationUnit";

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitCompilationUnit(this);
        }

        public boolean hasImport(String clazz) {
            return (Boolean)new HasImport(clazz).visit(this);
        }

        public boolean hasType(String clazz) {
            return (Boolean)new HasType(clazz).visit(this);
        }

        public List<MethodInvocation> findMethodCalls(String signature) {
            return (List)new FindMethods(signature).visit(this);
        }

        public Set<NameTree> findType(String clazz) {
            return (Set)new FindType(clazz).visit(this);
        }

        public Refactor<CompilationUnit> refactor() {
            return new Refactor((Tree)this);
        }

        @JsonProperty(value="@c")
        public String getJacksonPolymorphicTypeTag() {
            return ".J$CompilationUnit";
        }

        public static CompilationUnit buildEmptyClass(Path sourceSet, String packageName, String className) {
            String sourcePath = sourceSet.resolve(packageName.replace(".", System.getProperty("separator") == null ? "/" : System.getProperty("separator"))).resolve(className + ".java").toString();
            return new CompilationUnit(Tree.randomId(), sourcePath, Collections.emptyMap(), new Package(Tree.randomId(), (Expression)TreeBuilder.buildName(packageName).withPrefix(" "), Formatting.EMPTY), Collections.emptyList(), Collections.singletonList(new ClassDecl(Tree.randomId(), Collections.emptyList(), Collections.emptyList(), new ClassDecl.Kind.Class(Tree.randomId(), Formatting.EMPTY), (Ident)TreeBuilder.buildName(className).withPrefix(" "), null, null, null, new Block<J>(Tree.randomId(), null, Collections.emptyList(), Formatting.format((String)" "), "\n"), JavaType.Class.build(packageName + "." + className), Formatting.format((String)"\n\n")).withModifiers("public")), Formatting.EMPTY);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CompilationUnit;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "sourcePath", "metadata", "packageDecl", "imports", "classes", "formatting"})
        public CompilationUnit(UUID id, String sourcePath, Map<Metadata, String> metadata, Package packageDecl, List<Import> imports, List<ClassDecl> classes, Formatting formatting) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.metadata = metadata;
            this.packageDecl = packageDecl;
            this.imports = imports;
            this.classes = classes;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public Map<Metadata, String> getMetadata() {
            return this.metadata;
        }

        public Package getPackageDecl() {
            return this.packageDecl;
        }

        public List<Import> getImports() {
            return this.imports;
        }

        public List<ClassDecl> getClasses() {
            return this.classes;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.CompilationUnit(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", metadata=" + this.getMetadata() + ", packageDecl=" + this.getPackageDecl() + ", imports=" + this.getImports() + ", classes=" + this.getClasses() + ", formatting=" + this.getFormatting() + ", jacksonPolymorphicTypeTag=" + this.getJacksonPolymorphicTypeTag() + ")";
        }

        public CompilationUnit withMetadata(Map<Metadata, String> metadata) {
            return this.metadata == metadata ? this : new CompilationUnit(this.id, this.sourcePath, metadata, this.packageDecl, this.imports, this.classes, this.formatting);
        }

        public CompilationUnit withPackageDecl(Package packageDecl) {
            return this.packageDecl == packageDecl ? this : new CompilationUnit(this.id, this.sourcePath, this.metadata, packageDecl, this.imports, this.classes, this.formatting);
        }

        public CompilationUnit withImports(List<Import> imports) {
            return this.imports == imports ? this : new CompilationUnit(this.id, this.sourcePath, this.metadata, this.packageDecl, imports, this.classes, this.formatting);
        }

        public CompilationUnit withClasses(List<ClassDecl> classes) {
            return this.classes == classes ? this : new CompilationUnit(this.id, this.sourcePath, this.metadata, this.packageDecl, this.imports, classes, this.formatting);
        }

        public CompilationUnit withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new CompilationUnit(this.id, this.sourcePath, this.metadata, this.packageDecl, this.imports, this.classes, formatting);
        }
    }

    public static class ClassDecl
    implements J,
    Statement {
        private final UUID id;
        private final List<Annotation> annotations;
        private final List<Modifier> modifiers;
        private final Kind kind;
        private final Ident name;
        @Nullable
        private final TypeParameters typeParameters;
        @Nullable
        private final Extends extendings;
        @Nullable
        private final Implements implementings;
        private final Block<J> body;
        @Nullable
        private final JavaType type;
        private final Formatting formatting;

        public ClassDecl withModifiers(List<Modifier> modifiers) {
            if (modifiers == this.modifiers) {
                return this;
            }
            return new ClassDecl(this.id, this.annotations, modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type, this.formatting);
        }

        public ClassDecl withModifiers(String ... modifierKeywords) {
            List<Modifier> fixedModifiers = Modifier.withModifiers(this.modifiers, modifierKeywords);
            if (fixedModifiers == this.modifiers) {
                return this;
            }
            if (this.modifiers.isEmpty()) {
                return this.withModifiers(fixedModifiers).withKind((Kind)this.kind.withPrefix(" "));
            }
            return this.withModifiers(fixedModifiers);
        }

        public ClassDecl withExtends(@Nullable Extends extendings) {
            if (extendings == this.extendings) {
                return this;
            }
            return new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, extendings, this.implementings, this.body, this.type, this.formatting);
        }

        @JsonProperty(value="extendings")
        @Nullable
        public Extends getExtends() {
            return this.extendings;
        }

        public ClassDecl withImplements(@Nullable Implements implementings) {
            if (implementings == this.implementings) {
                return this;
            }
            return new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, implementings, this.body, this.type, this.formatting);
        }

        @JsonProperty(value="implementings")
        @Nullable
        public Implements getImplements() {
            return this.implementings;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitClassDecl(this);
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        @Nullable
        public EnumValueSet getEnumValues() {
            return this.body.getStatements().stream().filter(EnumValueSet.class::isInstance).map(EnumValueSet.class::cast).findAny().orElse(null);
        }

        @JsonIgnore
        public List<VariableDecls> getFields() {
            return this.body.getStatements().stream().filter(VariableDecls.class::isInstance).map(VariableDecls.class::cast).collect(Collectors.toList());
        }

        @JsonIgnore
        public List<MethodDecl> getMethods() {
            return this.body.getStatements().stream().filter(MethodDecl.class::isInstance).map(MethodDecl.class::cast).collect(Collectors.toList());
        }

        public List<VariableDecls> findFields(String clazz) {
            return (List)new FindFields(clazz).visit(this);
        }

        public List<JavaType.Var> findInheritedFields(String clazz) {
            return (List)new FindInheritedFields(clazz).visit(this);
        }

        public List<MethodInvocation> findMethodCalls(String signature) {
            return (List)new FindMethods(signature).visit(this);
        }

        public Set<NameTree> findType(String clazz) {
            return (Set)new FindType(clazz).visit(this);
        }

        public List<Annotation> findAnnotations(String signature) {
            return (List)new FindAnnotations(signature).visit(this);
        }

        public boolean hasType(String clazz) {
            return (Boolean)new HasType(clazz).visit(this);
        }

        public boolean hasModifier(String modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        @JsonIgnore
        public boolean isEnum() {
            return this.kind instanceof Kind.Enum;
        }

        @JsonIgnore
        public boolean isClass() {
            return this.kind instanceof Kind.Class;
        }

        @JsonIgnore
        public boolean isInterface() {
            return this.kind instanceof Kind.Interface;
        }

        @JsonIgnore
        public boolean isAnnotation() {
            return this.kind instanceof Kind.Annotation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassDecl)) {
                return false;
            }
            ClassDecl other = (ClassDecl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClassDecl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "annotations", "modifiers", "kind", "name", "typeParameters", "extendings", "implementings", "body", "type", "formatting"})
        public ClassDecl(UUID id, List<Annotation> annotations, List<Modifier> modifiers, Kind kind, Ident name, TypeParameters typeParameters, Extends extendings, Implements implementings, Block<J> body, JavaType type, Formatting formatting) {
            this.id = id;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.kind = kind;
            this.name = name;
            this.typeParameters = typeParameters;
            this.extendings = extendings;
            this.implementings = implementings;
            this.body = body;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public ClassDecl withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new ClassDecl(this.id, annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type, this.formatting);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        public ClassDecl withKind(Kind kind) {
            return this.kind == kind ? this : new ClassDecl(this.id, this.annotations, this.modifiers, kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type, this.formatting);
        }

        public Kind getKind() {
            return this.kind;
        }

        public ClassDecl withName(Ident name) {
            return this.name == name ? this : new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, name, this.typeParameters, this.extendings, this.implementings, this.body, this.type, this.formatting);
        }

        public Ident getName() {
            return this.name;
        }

        public ClassDecl withTypeParameters(TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, this.name, typeParameters, this.extendings, this.implementings, this.body, this.type, this.formatting);
        }

        public TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        public ClassDecl withBody(Block<J> body) {
            return this.body == body ? this : new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, body, this.type, this.formatting);
        }

        public Block<J> getBody() {
            return this.body;
        }

        public JavaType getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public ClassDecl withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type, formatting);
        }

        public static class Implements
        implements J {
            private final UUID id;
            private final List<TypeTree> from;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Implements)) {
                    return false;
                }
                Implements other = (Implements)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Implements;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "from", "formatting"})
            public Implements(UUID id, List<TypeTree> from, Formatting formatting) {
                this.id = id;
                this.from = from;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public List<TypeTree> getFrom() {
                return this.from;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.ClassDecl.Implements(id=" + this.getId() + ", from=" + this.getFrom() + ", formatting=" + this.getFormatting() + ")";
            }

            public Implements withFrom(List<TypeTree> from) {
                return this.from == from ? this : new Implements(this.id, from, this.formatting);
            }

            public Implements withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Implements(this.id, this.from, formatting);
            }
        }

        public static class Extends
        implements J {
            private final UUID id;
            private final TypeTree from;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Extends)) {
                    return false;
                }
                Extends other = (Extends)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Extends;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "from", "formatting"})
            public Extends(UUID id, TypeTree from, Formatting formatting) {
                this.id = id;
                this.from = from;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public TypeTree getFrom() {
                return this.from;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.ClassDecl.Extends(id=" + this.getId() + ", from=" + this.getFrom() + ", formatting=" + this.getFormatting() + ")";
            }

            public Extends withFrom(TypeTree from) {
                return this.from == from ? this : new Extends(this.id, from, this.formatting);
            }

            public Extends withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Extends(this.id, this.from, formatting);
            }
        }

        public static abstract class Kind
        implements J {
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Kind)) {
                    return false;
                }
                Kind other = (Kind)o;
                return other.canEqual(this);
            }

            protected boolean canEqual(Object other) {
                return other instanceof Kind;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public static class Annotation
            extends Kind {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Annotation)) {
                        return false;
                    }
                    Annotation other = (Annotation)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Annotation;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Annotation(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.ClassDecl.Kind.Annotation(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Annotation withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Annotation(this.id, formatting);
                }
            }

            public static class Interface
            extends Kind {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Interface)) {
                        return false;
                    }
                    Interface other = (Interface)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Interface;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Interface(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.ClassDecl.Kind.Interface(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Interface withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Interface(this.id, formatting);
                }
            }

            public static class Enum
            extends Kind {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Enum)) {
                        return false;
                    }
                    Enum other = (Enum)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Enum;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Enum(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.ClassDecl.Kind.Enum(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Enum withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Enum(this.id, formatting);
                }
            }

            public static class Class
            extends Kind {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Class)) {
                        return false;
                    }
                    Class other = (Class)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Class;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Class(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.ClassDecl.Kind.Class(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Class withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Class(this.id, formatting);
                }
            }
        }
    }

    public static class Case
    implements J,
    Statement {
        private final UUID id;
        @Nullable
        private final Expression pattern;
        private final List<Statement> statements;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitCase(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Case)) {
                return false;
            }
            Case other = (Case)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Case;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "pattern", "statements", "formatting"})
        public Case(UUID id, Expression pattern, List<Statement> statements, Formatting formatting) {
            this.id = id;
            this.pattern = pattern;
            this.statements = statements;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getPattern() {
            return this.pattern;
        }

        public List<Statement> getStatements() {
            return this.statements;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Case(id=" + this.getId() + ", pattern=" + this.getPattern() + ", statements=" + this.getStatements() + ", formatting=" + this.getFormatting() + ")";
        }

        public Case withPattern(Expression pattern) {
            return this.pattern == pattern ? this : new Case(this.id, pattern, this.statements, this.formatting);
        }

        public Case withStatements(List<Statement> statements) {
            return this.statements == statements ? this : new Case(this.id, this.pattern, statements, this.formatting);
        }

        public Case withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Case(this.id, this.pattern, this.statements, formatting);
        }
    }

    public static class Break
    implements J,
    Statement {
        private final UUID id;
        @Nullable
        private final Ident label;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitBreak(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Break)) {
                return false;
            }
            Break other = (Break)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Break;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "label", "formatting"})
        public Break(UUID id, Ident label, Formatting formatting) {
            this.id = id;
            this.label = label;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Ident getLabel() {
            return this.label;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Break(id=" + this.getId() + ", label=" + this.getLabel() + ", formatting=" + this.getFormatting() + ")";
        }

        public Break withLabel(Ident label) {
            return this.label == label ? this : new Break(this.id, label, this.formatting);
        }

        public Break withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Break(this.id, this.label, formatting);
        }
    }

    public static class Block<T extends J>
    implements J,
    Statement {
        private final UUID id;
        @Nullable
        private final Empty statik;
        private final List<T> statements;
        private final Formatting formatting;
        private final String endOfBlockSuffix;

        public Block<T> withStatic(Empty statik) {
            return new Block<T>(this.id, statik, this.statements, this.formatting, this.endOfBlockSuffix);
        }

        @Nullable
        public Empty getStatic() {
            return this.statik;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitBlock(this);
        }

        @JsonIgnore
        public int getIndent() {
            return Formatting.getIndent((String)this.endOfBlockSuffix);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            Block other = (Block)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Block;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "statik", "statements", "formatting", "endOfBlockSuffix"})
        public Block(UUID id, Empty statik, List<T> statements, Formatting formatting, String endOfBlockSuffix) {
            this.id = id;
            this.statik = statik;
            this.statements = statements;
            this.formatting = formatting;
            this.endOfBlockSuffix = endOfBlockSuffix;
        }

        public UUID getId() {
            return this.id;
        }

        public Block<T> withStatements(List<T> statements) {
            return this.statements == statements ? this : new Block<T>(this.id, this.statik, statements, this.formatting, this.endOfBlockSuffix);
        }

        public List<T> getStatements() {
            return this.statements;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Block<T> withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Block<T>(this.id, this.statik, this.statements, formatting, this.endOfBlockSuffix);
        }

        public Block<T> withEndOfBlockSuffix(String endOfBlockSuffix) {
            return this.endOfBlockSuffix == endOfBlockSuffix ? this : new Block<T>(this.id, this.statik, this.statements, this.formatting, endOfBlockSuffix);
        }

        public String getEndOfBlockSuffix() {
            return this.endOfBlockSuffix;
        }
    }

    public static class Binary
    implements J,
    Expression {
        private final UUID id;
        private final Expression left;
        private final Operator operator;
        private final Expression right;
        @Nullable
        private final JavaType type;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitBinary(this);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            ArrayList<Tree> sideEffects = new ArrayList<Tree>(2);
            sideEffects.addAll(this.left.getSideEffects());
            sideEffects.addAll(this.right.getSideEffects());
            return sideEffects;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binary)) {
                return false;
            }
            Binary other = (Binary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Binary;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "left", "operator", "right", "type", "formatting"})
        public Binary(UUID id, Expression left, Operator operator, Expression right, JavaType type, Formatting formatting) {
            this.id = id;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getLeft() {
            return this.left;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public Expression getRight() {
            return this.right;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Binary(id=" + this.getId() + ", left=" + this.getLeft() + ", operator=" + this.getOperator() + ", right=" + this.getRight() + ", type=" + this.getType() + ", formatting=" + this.getFormatting() + ")";
        }

        public Binary withLeft(Expression left) {
            return this.left == left ? this : new Binary(this.id, left, this.operator, this.right, this.type, this.formatting);
        }

        public Binary withOperator(Operator operator) {
            return this.operator == operator ? this : new Binary(this.id, this.left, operator, this.right, this.type, this.formatting);
        }

        public Binary withRight(Expression right) {
            return this.right == right ? this : new Binary(this.id, this.left, this.operator, right, this.type, this.formatting);
        }

        public Binary withType(JavaType type) {
            return this.type == type ? this : new Binary(this.id, this.left, this.operator, this.right, type, this.formatting);
        }

        public Binary withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Binary(this.id, this.left, this.operator, this.right, this.type, formatting);
        }

        public static abstract class Operator
        implements J {
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Operator)) {
                    return false;
                }
                Operator other = (Operator)o;
                return other.canEqual(this);
            }

            protected boolean canEqual(Object other) {
                return other instanceof Operator;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public static class And
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof And)) {
                        return false;
                    }
                    And other = (And)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof And;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public And(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.And(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public And withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new And(this.id, formatting);
                }
            }

            public static class Or
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Or)) {
                        return false;
                    }
                    Or other = (Or)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Or;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Or(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.Or(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Or withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Or(this.id, formatting);
                }
            }

            public static class UnsignedRightShift
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof UnsignedRightShift)) {
                        return false;
                    }
                    UnsignedRightShift other = (UnsignedRightShift)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof UnsignedRightShift;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public UnsignedRightShift(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.UnsignedRightShift(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public UnsignedRightShift withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new UnsignedRightShift(this.id, formatting);
                }
            }

            public static class RightShift
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof RightShift)) {
                        return false;
                    }
                    RightShift other = (RightShift)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof RightShift;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public RightShift(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.RightShift(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public RightShift withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new RightShift(this.id, formatting);
                }
            }

            public static class LeftShift
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LeftShift)) {
                        return false;
                    }
                    LeftShift other = (LeftShift)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof LeftShift;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public LeftShift(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.LeftShift(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public LeftShift withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new LeftShift(this.id, formatting);
                }
            }

            public static class BitXor
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BitXor)) {
                        return false;
                    }
                    BitXor other = (BitXor)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof BitXor;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public BitXor(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.BitXor(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public BitXor withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new BitXor(this.id, formatting);
                }
            }

            public static class BitOr
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BitOr)) {
                        return false;
                    }
                    BitOr other = (BitOr)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof BitOr;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public BitOr(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.BitOr(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public BitOr withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new BitOr(this.id, formatting);
                }
            }

            public static class BitAnd
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BitAnd)) {
                        return false;
                    }
                    BitAnd other = (BitAnd)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof BitAnd;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public BitAnd(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.BitAnd(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public BitAnd withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new BitAnd(this.id, formatting);
                }
            }

            public static class NotEqual
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof NotEqual)) {
                        return false;
                    }
                    NotEqual other = (NotEqual)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof NotEqual;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public NotEqual(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.NotEqual(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public NotEqual withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new NotEqual(this.id, formatting);
                }
            }

            public static class Equal
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Equal)) {
                        return false;
                    }
                    Equal other = (Equal)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Equal;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Equal(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.Equal(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Equal withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Equal(this.id, formatting);
                }
            }

            public static class GreaterThanOrEqual
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof GreaterThanOrEqual)) {
                        return false;
                    }
                    GreaterThanOrEqual other = (GreaterThanOrEqual)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof GreaterThanOrEqual;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public GreaterThanOrEqual(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.GreaterThanOrEqual(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public GreaterThanOrEqual withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new GreaterThanOrEqual(this.id, formatting);
                }
            }

            public static class LessThanOrEqual
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LessThanOrEqual)) {
                        return false;
                    }
                    LessThanOrEqual other = (LessThanOrEqual)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof LessThanOrEqual;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public LessThanOrEqual(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.LessThanOrEqual(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public LessThanOrEqual withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new LessThanOrEqual(this.id, formatting);
                }
            }

            public static class GreaterThan
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof GreaterThan)) {
                        return false;
                    }
                    GreaterThan other = (GreaterThan)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof GreaterThan;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public GreaterThan(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.GreaterThan(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public GreaterThan withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new GreaterThan(this.id, formatting);
                }
            }

            public static class LessThan
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LessThan)) {
                        return false;
                    }
                    LessThan other = (LessThan)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof LessThan;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public LessThan(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.LessThan(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public LessThan withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new LessThan(this.id, formatting);
                }
            }

            public static class Modulo
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Modulo)) {
                        return false;
                    }
                    Modulo other = (Modulo)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Modulo;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Modulo(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.Modulo(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Modulo withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Modulo(this.id, formatting);
                }
            }

            public static class Division
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Division)) {
                        return false;
                    }
                    Division other = (Division)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Division;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Division(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.Division(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Division withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Division(this.id, formatting);
                }
            }

            public static class Multiplication
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Multiplication)) {
                        return false;
                    }
                    Multiplication other = (Multiplication)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Multiplication;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Multiplication(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.Multiplication(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Multiplication withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Multiplication(this.id, formatting);
                }
            }

            public static class Subtraction
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Subtraction)) {
                        return false;
                    }
                    Subtraction other = (Subtraction)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Subtraction;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Subtraction(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.Subtraction(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Subtraction withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Subtraction(this.id, formatting);
                }
            }

            public static class Addition
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Addition)) {
                        return false;
                    }
                    Addition other = (Addition)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Addition;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Addition(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.Binary.Operator.Addition(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Addition withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Addition(this.id, formatting);
                }
            }
        }
    }

    public static class AssignOp
    implements J,
    Statement,
    Expression {
        private final UUID id;
        private final Expression variable;
        private final Operator operator;
        private final Expression assignment;
        @Nullable
        private final JavaType type;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitAssignOp(this);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssignOp)) {
                return false;
            }
            AssignOp other = (AssignOp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AssignOp;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "variable", "operator", "assignment", "type", "formatting"})
        public AssignOp(UUID id, Expression variable, Operator operator, Expression assignment, JavaType type, Formatting formatting) {
            this.id = id;
            this.variable = variable;
            this.operator = operator;
            this.assignment = assignment;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getVariable() {
            return this.variable;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public Expression getAssignment() {
            return this.assignment;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.AssignOp(id=" + this.getId() + ", variable=" + this.getVariable() + ", operator=" + this.getOperator() + ", assignment=" + this.getAssignment() + ", type=" + this.getType() + ", formatting=" + this.getFormatting() + ")";
        }

        public AssignOp withVariable(Expression variable) {
            return this.variable == variable ? this : new AssignOp(this.id, variable, this.operator, this.assignment, this.type, this.formatting);
        }

        public AssignOp withOperator(Operator operator) {
            return this.operator == operator ? this : new AssignOp(this.id, this.variable, operator, this.assignment, this.type, this.formatting);
        }

        public AssignOp withAssignment(Expression assignment) {
            return this.assignment == assignment ? this : new AssignOp(this.id, this.variable, this.operator, assignment, this.type, this.formatting);
        }

        public AssignOp withType(JavaType type) {
            return this.type == type ? this : new AssignOp(this.id, this.variable, this.operator, this.assignment, type, this.formatting);
        }

        public AssignOp withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new AssignOp(this.id, this.variable, this.operator, this.assignment, this.type, formatting);
        }

        public static abstract class Operator
        implements J {
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Operator)) {
                    return false;
                }
                Operator other = (Operator)o;
                return other.canEqual(this);
            }

            protected boolean canEqual(Object other) {
                return other instanceof Operator;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public static class UnsignedRightShift
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof UnsignedRightShift)) {
                        return false;
                    }
                    UnsignedRightShift other = (UnsignedRightShift)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof UnsignedRightShift;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public UnsignedRightShift(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.AssignOp.Operator.UnsignedRightShift(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public UnsignedRightShift withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new UnsignedRightShift(this.id, formatting);
                }
            }

            public static class RightShift
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof RightShift)) {
                        return false;
                    }
                    RightShift other = (RightShift)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof RightShift;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public RightShift(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.AssignOp.Operator.RightShift(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public RightShift withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new RightShift(this.id, formatting);
                }
            }

            public static class LeftShift
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LeftShift)) {
                        return false;
                    }
                    LeftShift other = (LeftShift)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof LeftShift;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public LeftShift(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.AssignOp.Operator.LeftShift(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public LeftShift withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new LeftShift(this.id, formatting);
                }
            }

            public static class BitXor
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BitXor)) {
                        return false;
                    }
                    BitXor other = (BitXor)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof BitXor;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public BitXor(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.AssignOp.Operator.BitXor(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public BitXor withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new BitXor(this.id, formatting);
                }
            }

            public static class BitOr
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BitOr)) {
                        return false;
                    }
                    BitOr other = (BitOr)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof BitOr;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public BitOr(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.AssignOp.Operator.BitOr(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public BitOr withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new BitOr(this.id, formatting);
                }
            }

            public static class BitAnd
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BitAnd)) {
                        return false;
                    }
                    BitAnd other = (BitAnd)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof BitAnd;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public BitAnd(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.AssignOp.Operator.BitAnd(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public BitAnd withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new BitAnd(this.id, formatting);
                }
            }

            public static class Modulo
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Modulo)) {
                        return false;
                    }
                    Modulo other = (Modulo)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Modulo;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Modulo(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.AssignOp.Operator.Modulo(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Modulo withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Modulo(this.id, formatting);
                }
            }

            public static class Division
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Division)) {
                        return false;
                    }
                    Division other = (Division)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Division;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Division(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.AssignOp.Operator.Division(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Division withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Division(this.id, formatting);
                }
            }

            public static class Multiplication
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Multiplication)) {
                        return false;
                    }
                    Multiplication other = (Multiplication)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Multiplication;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Multiplication(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.AssignOp.Operator.Multiplication(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Multiplication withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Multiplication(this.id, formatting);
                }
            }

            public static class Subtraction
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Subtraction)) {
                        return false;
                    }
                    Subtraction other = (Subtraction)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Subtraction;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Subtraction(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.AssignOp.Operator.Subtraction(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Subtraction withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Subtraction(this.id, formatting);
                }
            }

            public static class Addition
            extends Operator {
                private final UUID id;
                private final Formatting formatting;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Addition)) {
                        return false;
                    }
                    Addition other = (Addition)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Addition;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "formatting"})
                public Addition(UUID id, Formatting formatting) {
                    this.id = id;
                    this.formatting = formatting;
                }

                public UUID getId() {
                    return this.id;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public String toString() {
                    return "J.AssignOp.Operator.Addition(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
                }

                public Addition withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Addition(this.id, formatting);
                }
            }
        }
    }

    public static class Assign
    implements J,
    Statement,
    Expression {
        private final UUID id;
        private final Expression variable;
        private final Expression assignment;
        @Nullable
        private final JavaType type;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitAssign(this);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assign)) {
                return false;
            }
            Assign other = (Assign)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Assign;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "variable", "assignment", "type", "formatting"})
        public Assign(UUID id, Expression variable, Expression assignment, JavaType type, Formatting formatting) {
            this.id = id;
            this.variable = variable;
            this.assignment = assignment;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getVariable() {
            return this.variable;
        }

        public Expression getAssignment() {
            return this.assignment;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Assign(id=" + this.getId() + ", variable=" + this.getVariable() + ", assignment=" + this.getAssignment() + ", type=" + this.getType() + ", formatting=" + this.getFormatting() + ")";
        }

        public Assign withVariable(Expression variable) {
            return this.variable == variable ? this : new Assign(this.id, variable, this.assignment, this.type, this.formatting);
        }

        public Assign withAssignment(Expression assignment) {
            return this.assignment == assignment ? this : new Assign(this.id, this.variable, assignment, this.type, this.formatting);
        }

        public Assign withType(JavaType type) {
            return this.type == type ? this : new Assign(this.id, this.variable, this.assignment, type, this.formatting);
        }

        public Assign withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Assign(this.id, this.variable, this.assignment, this.type, formatting);
        }
    }

    public static class Assert
    implements J,
    Statement {
        private final UUID id;
        private final Expression condition;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitAssert(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assert)) {
                return false;
            }
            Assert other = (Assert)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Assert;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "condition", "formatting"})
        public Assert(UUID id, Expression condition, Formatting formatting) {
            this.id = id;
            this.condition = condition;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getCondition() {
            return this.condition;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Assert(id=" + this.getId() + ", condition=" + this.getCondition() + ", formatting=" + this.getFormatting() + ")";
        }

        public Assert withCondition(Expression condition) {
            return this.condition == condition ? this : new Assert(this.id, condition, this.formatting);
        }

        public Assert withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Assert(this.id, this.condition, formatting);
        }
    }

    public static class ArrayType
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final TypeTree elementType;
        private final List<Dimension> dimensions;
        private final Formatting formatting;

        @Override
        public JavaType getType() {
            return this.elementType.getType();
        }

        public ArrayType withType(JavaType type) {
            return this.withElementType((TypeTree)this.elementType.withType(type));
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitArrayType(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayType)) {
                return false;
            }
            ArrayType other = (ArrayType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ArrayType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "elementType", "dimensions", "formatting"})
        public ArrayType(UUID id, TypeTree elementType, List<Dimension> dimensions, Formatting formatting) {
            this.id = id;
            this.elementType = elementType;
            this.dimensions = dimensions;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public TypeTree getElementType() {
            return this.elementType;
        }

        public List<Dimension> getDimensions() {
            return this.dimensions;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.ArrayType(id=" + this.getId() + ", elementType=" + this.getElementType() + ", dimensions=" + this.getDimensions() + ", formatting=" + this.getFormatting() + ")";
        }

        public ArrayType withElementType(TypeTree elementType) {
            return this.elementType == elementType ? this : new ArrayType(this.id, elementType, this.dimensions, this.formatting);
        }

        public ArrayType withDimensions(List<Dimension> dimensions) {
            return this.dimensions == dimensions ? this : new ArrayType(this.id, this.elementType, dimensions, this.formatting);
        }

        public ArrayType withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new ArrayType(this.id, this.elementType, this.dimensions, formatting);
        }

        public static class Dimension
        implements J {
            private final UUID id;
            private final Empty inner;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dimension)) {
                    return false;
                }
                Dimension other = (Dimension)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Dimension;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "inner", "formatting"})
            public Dimension(UUID id, Empty inner, Formatting formatting) {
                this.id = id;
                this.inner = inner;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Empty getInner() {
                return this.inner;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.ArrayType.Dimension(id=" + this.getId() + ", inner=" + this.getInner() + ", formatting=" + this.getFormatting() + ")";
            }

            public Dimension withInner(Empty inner) {
                return this.inner == inner ? this : new Dimension(this.id, inner, this.formatting);
            }

            public Dimension withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Dimension(this.id, this.inner, formatting);
            }
        }
    }

    public static class ArrayAccess
    implements J,
    Expression {
        private final UUID id;
        private final Expression indexed;
        private final Dimension dimension;
        @Nullable
        private final JavaType type;
        private final Formatting formatting;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitArrayAccess(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayAccess)) {
                return false;
            }
            ArrayAccess other = (ArrayAccess)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ArrayAccess;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "indexed", "dimension", "type", "formatting"})
        public ArrayAccess(UUID id, Expression indexed, Dimension dimension, JavaType type, Formatting formatting) {
            this.id = id;
            this.indexed = indexed;
            this.dimension = dimension;
            this.type = type;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getIndexed() {
            return this.indexed;
        }

        public Dimension getDimension() {
            return this.dimension;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.ArrayAccess(id=" + this.getId() + ", indexed=" + this.getIndexed() + ", dimension=" + this.getDimension() + ", type=" + this.getType() + ", formatting=" + this.getFormatting() + ")";
        }

        public ArrayAccess withIndexed(Expression indexed) {
            return this.indexed == indexed ? this : new ArrayAccess(this.id, indexed, this.dimension, this.type, this.formatting);
        }

        public ArrayAccess withDimension(Dimension dimension) {
            return this.dimension == dimension ? this : new ArrayAccess(this.id, this.indexed, dimension, this.type, this.formatting);
        }

        public ArrayAccess withType(JavaType type) {
            return this.type == type ? this : new ArrayAccess(this.id, this.indexed, this.dimension, type, this.formatting);
        }

        public ArrayAccess withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new ArrayAccess(this.id, this.indexed, this.dimension, this.type, formatting);
        }

        public static class Dimension
        implements J {
            private final UUID id;
            private final Expression index;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dimension)) {
                    return false;
                }
                Dimension other = (Dimension)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Dimension;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "index", "formatting"})
            public Dimension(UUID id, Expression index, Formatting formatting) {
                this.id = id;
                this.index = index;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Expression getIndex() {
                return this.index;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.ArrayAccess.Dimension(id=" + this.getId() + ", index=" + this.getIndex() + ", formatting=" + this.getFormatting() + ")";
            }

            public Dimension withIndex(Expression index) {
                return this.index == index ? this : new Dimension(this.id, index, this.formatting);
            }

            public Dimension withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Dimension(this.id, this.index, formatting);
            }
        }
    }

    public static class Annotation
    implements J,
    Expression {
        private final UUID id;
        private final NameTree annotationType;
        @Nullable
        private final Arguments args;
        private final Formatting formatting;

        @Override
        @JsonIgnore
        public JavaType getType() {
            return this.annotationType.getType();
        }

        public Annotation withType(@Nullable JavaType type) {
            return this.withAnnotationType((NameTree)this.annotationType.withType(type));
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitAnnotation(this);
        }

        public <T extends Tree> Optional<T> whenType(Class<T> treeType) {
            return Optional.empty();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Annotation)) {
                return false;
            }
            Annotation other = (Annotation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Annotation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "annotationType", "args", "formatting"})
        public Annotation(UUID id, NameTree annotationType, Arguments args, Formatting formatting) {
            this.id = id;
            this.annotationType = annotationType;
            this.args = args;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public NameTree getAnnotationType() {
            return this.annotationType;
        }

        public Arguments getArgs() {
            return this.args;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.Annotation(id=" + this.getId() + ", annotationType=" + this.getAnnotationType() + ", args=" + this.getArgs() + ", formatting=" + this.getFormatting() + ")";
        }

        public Annotation withAnnotationType(NameTree annotationType) {
            return this.annotationType == annotationType ? this : new Annotation(this.id, annotationType, this.args, this.formatting);
        }

        public Annotation withArgs(Arguments args) {
            return this.args == args ? this : new Annotation(this.id, this.annotationType, args, this.formatting);
        }

        public Annotation withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Annotation(this.id, this.annotationType, this.args, formatting);
        }

        public static class Arguments
        implements J {
            private final UUID id;
            private final List<Expression> args;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Arguments)) {
                    return false;
                }
                Arguments other = (Arguments)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Arguments;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "args", "formatting"})
            public Arguments(UUID id, List<Expression> args, Formatting formatting) {
                this.id = id;
                this.args = args;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public List<Expression> getArgs() {
                return this.args;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "J.Annotation.Arguments(id=" + this.getId() + ", args=" + this.getArgs() + ", formatting=" + this.getFormatting() + ")";
            }

            public Arguments withArgs(List<Expression> args) {
                return this.args == args ? this : new Arguments(this.id, args, this.formatting);
            }

            public Arguments withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Arguments(this.id, this.args, formatting);
            }
        }
    }

    public static class AnnotatedType
    implements J,
    Expression,
    TypeTree {
        private final UUID id;
        private final List<Annotation> annotations;
        private final TypeTree typeExpr;
        private final Formatting formatting;

        @Override
        public JavaType getType() {
            return this.typeExpr.getType();
        }

        public AnnotatedType withType(@Nullable JavaType type) {
            return this.withTypeExpr((TypeTree)this.typeExpr.withType(type));
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitAnnotatedType(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnnotatedType)) {
                return false;
            }
            AnnotatedType other = (AnnotatedType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AnnotatedType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "annotations", "typeExpr", "formatting"})
        public AnnotatedType(UUID id, List<Annotation> annotations, TypeTree typeExpr, Formatting formatting) {
            this.id = id;
            this.annotations = annotations;
            this.typeExpr = typeExpr;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public TypeTree getTypeExpr() {
            return this.typeExpr;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "J.AnnotatedType(id=" + this.getId() + ", annotations=" + this.getAnnotations() + ", typeExpr=" + this.getTypeExpr() + ", formatting=" + this.getFormatting() + ")";
        }

        public AnnotatedType withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new AnnotatedType(this.id, annotations, this.typeExpr, this.formatting);
        }

        public AnnotatedType withTypeExpr(TypeTree typeExpr) {
            return this.typeExpr == typeExpr ? this : new AnnotatedType(this.id, this.annotations, typeExpr, this.formatting);
        }

        public AnnotatedType withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new AnnotatedType(this.id, this.annotations, this.typeExpr, formatting);
        }
    }
}

