/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class ShiftFormatRightVisitor
extends JavaRefactorVisitor {
    private final Tree scope;
    private final String shift;

    public ShiftFormatRightVisitor(Tree scope, int shift, boolean isIndentedWithSpaces) {
        this.scope = scope;
        this.shift = IntStream.range(0, shift).mapToObj(n -> isIndentedWithSpaces ? " " : "\t").collect(Collectors.joining(""));
        this.setCursoringOn();
    }

    @Override
    public J visitElse(J.If.Else elze) {
        J.If.Else e = (J.If.Else)this.refactor(elze, x$0 -> super.visitElse((J.If.Else)x$0));
        if (this.getCursor().isScopeInPath(this.scope) && this.isOnOwnLine(elze)) {
            e = (J.If.Else)e.withPrefix(e.getFormatting().getPrefix() + this.shift);
        }
        return e;
    }

    @Override
    public J visitStatement(Statement statement) {
        Statement s = (Statement)this.refactor(statement, x$0 -> (J)super.visitStatement((Statement)x$0));
        if (this.getCursor().isScopeInPath(this.scope) && this.isOnOwnLine(statement)) {
            s = (Statement)s.withPrefix(s.getFormatting().getPrefix() + this.shift);
        }
        return s;
    }

    @Override
    public J visitBlock(J.Block<J> block) {
        J.Block b = (J.Block)this.refactor(block, x$0 -> super.visitBlock((J.Block)x$0));
        if (this.getCursor().isScopeInPath(this.scope)) {
            b = b.withEndOfBlockSuffix(b.getEndOfBlockSuffix() + this.shift);
        }
        return b;
    }

    @Override
    public J visitNewArray(J.NewArray newArray) {
        String suffix;
        J.NewArray n = (J.NewArray)this.refactor(newArray, x$0 -> super.visitNewArray((J.NewArray)x$0));
        if (n.getInitializer() != null && (suffix = Formatting.lastSuffix(n.getInitializer().getElements())).contains("\n")) {
            List elements = Formatting.formatLastSuffix(n.getInitializer().getElements(), (String)(suffix + this.shift));
            n = n.withInitializer(n.getInitializer().withElements(elements.stream().map(e -> (Expression)e.withPrefix(e.getFormatting().getPrefix() + this.shift)).collect(Collectors.toList())));
        }
        return n;
    }

    private boolean isOnOwnLine(Tree tree) {
        AtomicBoolean takeWhile = new AtomicBoolean(true);
        return tree.getFormatting().getPrefix().chars().filter(c -> {
            takeWhile.set(takeWhile.get() && (c == 10 || c == 13));
            return takeWhile.get();
        }).count() > 0L;
    }
}

