/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.OrderImports;
import org.openrewrite.java.search.HasType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TreeBuilder;

public class AddImport
extends JavaRefactorVisitor {
    public static OrderImports orderImports = OrderImports.intellij();
    private String type;
    @Nullable
    private String staticMethod;
    private boolean onlyIfReferenced = true;
    private JavaType.Class classType;

    public AddImport() {
        orderImports.setRemoveUnused(false);
    }

    public void setType(String type) {
        this.type = type;
        this.classType = JavaType.Class.build(type);
    }

    public void setStaticMethod(@Nullable String staticMethod) {
        this.staticMethod = staticMethod;
    }

    public void setOnlyIfReferenced(boolean onlyIfReferenced) {
        this.onlyIfReferenced = onlyIfReferenced;
    }

    public Iterable<Tag> getTags() {
        return Tags.of((String[])new String[]{"class", this.type, "static.method", this.staticMethod == null ? "none" : this.staticMethod});
    }

    public Validated validate() {
        return Validated.required((String)"type", (Object)this.type);
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu) {
        boolean hasReferences = (Boolean)new HasType(this.type).visit(cu);
        if (this.onlyIfReferenced && !hasReferences) {
            return cu;
        }
        if (this.classType.getPackageName().isEmpty()) {
            return cu;
        }
        if (cu.getImports().stream().anyMatch(i -> {
            String ending = i.getQualid().getSimpleName();
            if (this.staticMethod == null) {
                return !i.isStatic() && i.getPackageName().equals(this.classType.getPackageName()) && (ending.equals(this.classType.getClassName()) || ending.equals("*"));
            }
            return i.isStatic() && i.getTypeName().equals(this.classType.getFullyQualifiedName()) && (ending.equals(this.staticMethod) || ending.equals("*"));
        })) {
            return cu;
        }
        J.Import importToAdd = new J.Import(Tree.randomId(), (J.FieldAccess)TreeBuilder.buildName(this.classType.getFullyQualifiedName() + (this.staticMethod == null ? "" : "." + this.staticMethod), Formatting.format((String)" ")), this.staticMethod != null, Formatting.EMPTY);
        ArrayList<J.Import> imports = new ArrayList<J.Import>(cu.getImports());
        if (imports.isEmpty()) {
            importToAdd = cu.getPackageDecl() == null ? (J.Import)importToAdd.withPrefix(cu.getClasses().get(0).getFormatting().getPrefix() + "\n\n") : (J.Import)importToAdd.withPrefix("\n\n");
        }
        cu = cu.withClasses(Formatting.formatFirstPrefix(cu.getClasses(), (String)"\n\n"));
        imports.add(importToAdd);
        cu = cu.withImports(imports);
        this.andThen(orderImports);
        return cu;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddImport)) {
            return false;
        }
        AddImport other = (AddImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$staticMethod = this.staticMethod;
        String other$staticMethod = other.staticMethod;
        if (this$staticMethod == null ? other$staticMethod != null : !this$staticMethod.equals(other$staticMethod)) {
            return false;
        }
        return this.onlyIfReferenced == other.onlyIfReferenced;
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddImport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $staticMethod = this.staticMethod;
        result = result * 59 + ($staticMethod == null ? 43 : $staticMethod.hashCode());
        result = result * 59 + (this.onlyIfReferenced ? 79 : 97);
        return result;
    }
}

