/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.openrewrite.Metadata;
import org.openrewrite.java.tree.J;

public class TreeSerializer {
    private final TypeReference<List<J.CompilationUnit>> cuListType = new TypeReference<List<J.CompilationUnit>>(){};
    private final ObjectMapper mapper;
    private final SimpleModule metadataModule = new SimpleModule();

    public TreeSerializer() {
        this.metadataModule.addKeySerializer(Metadata.class, (JsonSerializer)new MetadataKeySerializer());
        this.metadataModule.addKeyDeserializer(Metadata.class, (KeyDeserializer)new MetadataKeyDeserializer());
        SmileFactory f = new SmileFactory();
        f.configure(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES, true);
        this.mapper = new ObjectMapper((JsonFactory)f).registerModule((Module)this.metadataModule).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public String writePretty(J.CompilationUnit cu) {
        try {
            return new ObjectMapper().registerModule((Module)this.metadataModule).setSerializationInclusion(JsonInclude.Include.NON_NULL).writerWithDefaultPrettyPrinter().writeValueAsString((Object)cu);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void write(List<J.CompilationUnit> cus, OutputStream out) {
        try {
            this.mapper.writeValue(out, cus);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] write(List<J.CompilationUnit> cus) {
        try {
            return this.mapper.writeValueAsBytes(cus);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public void write(J.CompilationUnit cu, OutputStream out) {
        try {
            this.mapper.writeValue(out, (Object)cu);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] write(J.CompilationUnit cu) {
        try {
            return this.mapper.writeValueAsBytes((Object)cu);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public List<J.CompilationUnit> readList(InputStream input) {
        try {
            return (List)this.mapper.readValue(input, this.cuListType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<J.CompilationUnit> readList(byte[] bytes) {
        try {
            return (List)this.mapper.readValue(bytes, this.cuListType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public J.CompilationUnit read(InputStream input) {
        try {
            return (J.CompilationUnit)this.mapper.readValue(input, J.CompilationUnit.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public J.CompilationUnit read(byte[] bytes) {
        try {
            return (J.CompilationUnit)this.mapper.readValue(bytes, J.CompilationUnit.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class MetadataKeySerializer
    extends StdSerializer<Metadata> {
        public MetadataKeySerializer() {
            super(Metadata.class);
        }

        public void serialize(Metadata value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeFieldName(value.getClass().getName() + "#" + value.toString());
        }
    }

    private static class MetadataKeyDeserializer
    extends KeyDeserializer {
        private final Map<String, Function<String, Metadata>> metadataValueByName = new ConcurrentHashMap<String, Function<String, Metadata>>();

        private MetadataKeyDeserializer() {
        }

        public Metadata deserializeKey(String key, DeserializationContext ctxt) {
            String[] classAndValue = key.split("#", 2);
            return (Metadata)this.metadataValueByName.computeIfAbsent(classAndValue[0], this::loadMetadataClass).apply(classAndValue[1]);
        }

        private Function<String, Metadata> loadMetadataClass(String clazz) {
            try {
                Class<?> metadataClass = Class.forName(clazz);
                return value -> {
                    try {
                        return (Metadata)metadataClass.getDeclaredMethod("valueOf", String.class).invoke(null, value);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

