/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeTree;

public class GenerateConstructorUsingFields
extends JavaRefactorVisitor {
    private final J.ClassDecl scope;
    private final List<J.VariableDecls> fields;

    public GenerateConstructorUsingFields(J.ClassDecl scope, List<J.VariableDecls> fields) {
        this.scope = scope;
        this.fields = fields;
        this.setCursoringOn();
    }

    @Override
    public J visitClassDecl(J.ClassDecl classDecl) {
        if (this.scope.isScope(classDecl) && !this.hasRequiredArgsConstructor(classDecl)) {
            List<J> statements = classDecl.getBody().getStatements();
            int lastField = 0;
            for (int i = 0; i < statements.size(); ++i) {
                if (!(statements.get(i) instanceof J.VariableDecls)) continue;
                lastField = i;
            }
            List<Statement> constructorParams = this.fields.stream().map(mv -> new J.VariableDecls(Tree.randomId(), Collections.emptyList(), Collections.emptyList(), mv.getTypeExpr() != null ? (TypeTree)mv.getTypeExpr().withFormatting(Formatting.EMPTY) : null, null, Formatting.formatFirstPrefix(mv.getDimensionsBeforeName(), (String)""), Formatting.formatFirstPrefix(mv.getVars(), (String)" "), Formatting.EMPTY)).collect(Collectors.toList());
            for (int i = 1; i < constructorParams.size(); ++i) {
                constructorParams.set(i, (Statement)((Statement)constructorParams.get(i)).withFormatting(Formatting.format((String)" ")));
            }
            Formatting constructorFormatting = this.formatter.format(classDecl.getBody());
            J.MethodDecl constructor = new J.MethodDecl(Tree.randomId(), Collections.emptyList(), Collections.singletonList(new J.Modifier.Public(Tree.randomId(), Formatting.EMPTY)), null, null, J.Ident.build(Tree.randomId(), classDecl.getSimpleName(), classDecl.getType(), Formatting.format((String)" ")), new J.MethodDecl.Parameters(Tree.randomId(), constructorParams, Formatting.EMPTY), null, new J.Block<Statement>(Tree.randomId(), null, Collections.emptyList(), Formatting.format((String)" "), this.formatter.findIndent(classDecl.getBody().getIndent(), (Tree[])classDecl.getBody().getStatements().toArray(Tree[]::new)).getPrefix()), null, constructorFormatting.withPrefix("\n" + constructorFormatting.getPrefix()));
            this.andThen(new AddAssignmentsToConstructor(constructor));
            statements.add(lastField + 1, constructor);
            return classDecl.withBody(classDecl.getBody().withStatements(statements));
        }
        return super.visitClassDecl(classDecl);
    }

    private boolean hasRequiredArgsConstructor(J.ClassDecl cd) {
        Set injectedFieldNames = this.fields.stream().map(f -> f.getVars().get(0).getSimpleName()).collect(Collectors.toSet());
        return cd.getBody().getStatements().stream().anyMatch(stat -> stat.whenType(J.MethodDecl.class).filter(J.MethodDecl::isConstructor).map(md -> md.getParams().getParams().stream().map(p -> p.whenType(J.VariableDecls.class).map(mv -> mv.getVars().get(0).getSimpleName()).orElseThrow(() -> new RuntimeException("not possible to get here"))).allMatch(injectedFieldNames::contains)).orElse(false));
    }

    private class AddAssignmentsToConstructor
    extends JavaRefactorVisitor {
        private final J.MethodDecl scope;

        private AddAssignmentsToConstructor(J.MethodDecl scope) {
            this.scope = scope;
            this.setCursoringOn();
        }

        @Override
        public J visitMethod(J.MethodDecl method) {
            if (this.scope.isScope(method)) {
                return method.withBody(method.getBody().withStatements(TreeBuilder.buildSnippet(this.enclosingCompilationUnit(), this.getCursor(), GenerateConstructorUsingFields.this.fields.stream().map(mv -> {
                    String name = mv.getVars().get(0).getSimpleName();
                    return "this." + name + " = " + name + ";";
                }).collect(Collectors.joining("\n", "", "\n")), new JavaType.Class[0])));
            }
            return super.visitMethod(method);
        }
    }
}

