/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.stream.Collectors;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class ChangeFieldType
extends JavaRefactorVisitor {
    private JavaType.Class type;
    private String targetType;

    public void setType(String type) {
        this.type = JavaType.Class.build(type);
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public Iterable<Tag> getTags() {
        return Tags.of((String[])new String[]{"type", this.type.getFullyQualifiedName(), "target.type", this.targetType});
    }

    public Validated validate() {
        return Validated.required((String)"type", (Object)this.type).and(Validated.required((String)"targetType", (Object)this.targetType));
    }

    @Override
    public J visitMultiVariable(J.VariableDecls multiVariable) {
        if (multiVariable.getTypeAsClass().equals(this.type)) {
            this.andThen(new Scoped(multiVariable, this.targetType));
        }
        return super.visitMultiVariable(multiVariable);
    }

    public static class Scoped
    extends JavaRefactorVisitor {
        private final J.VariableDecls scope;
        private final String targetType;

        public Scoped(J.VariableDecls scope, String targetType) {
            this.scope = scope;
            this.targetType = targetType;
        }

        public Iterable<Tag> getTags() {
            return Tags.of((String)"to", (String)this.targetType);
        }

        @Override
        public J visitMultiVariable(J.VariableDecls multiVariable) {
            JavaType.Class originalType = multiVariable.getTypeAsClass();
            J.VariableDecls mv = (J.VariableDecls)this.refactor(multiVariable, x$0 -> super.visitMultiVariable((J.VariableDecls)x$0));
            if (this.scope.isScope(multiVariable) && originalType != null && !originalType.getFullyQualifiedName().equals(this.targetType)) {
                JavaType.Class type = JavaType.Class.build(this.targetType);
                this.maybeAddImport(this.targetType);
                this.maybeRemoveImport(originalType);
                mv = mv.withTypeExpr(mv.getTypeExpr() == null ? null : J.Ident.build(mv.getTypeExpr().getId(), type.getClassName(), type, mv.getTypeExpr().getFormatting())).withVars(mv.getVars().stream().map(var -> {
                    JavaType.Class varType = TypeUtils.asClass(var.getType());
                    if (varType != null && !varType.equals(type)) {
                        return var.withType(type).withName(var.getName().withType(type));
                    }
                    return var;
                }).collect(Collectors.toList()));
            }
            return mv;
        }
    }
}

