/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.search.FindType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TreeBuilder;

public class AddImport
extends JavaRefactorVisitor {
    OrderImports orderImports = new IntellijOrderImports();
    private String type;
    @Nullable
    private String staticMethod;
    private boolean onlyIfReferenced = true;
    private JavaType.Class classType;
    private boolean coveredByExistingImport;

    public void setType(String type) {
        this.type = type;
        this.classType = JavaType.Class.build(type);
    }

    public void setStaticMethod(@Nullable String staticMethod) {
        this.staticMethod = staticMethod;
    }

    public void setOnlyIfReferenced(boolean onlyIfReferenced) {
        this.onlyIfReferenced = onlyIfReferenced;
    }

    public Iterable<Tag> getTags() {
        return Tags.of((String[])new String[]{"class", this.type, "static.method", this.staticMethod == null ? "none" : this.staticMethod});
    }

    public Validated validate() {
        return Validated.required((String)"type", (Object)this.type);
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu) {
        boolean hasReferences;
        this.coveredByExistingImport = false;
        boolean bl = hasReferences = !((Set)new FindType(this.type).visit(cu)).isEmpty();
        if (this.onlyIfReferenced && !hasReferences) {
            return cu;
        }
        cu = (J.CompilationUnit)this.refactor(cu, x$0 -> super.visitCompilationUnit((J.CompilationUnit)x$0));
        if (this.coveredByExistingImport) {
            return cu;
        }
        if (this.classType.getPackageName().isEmpty()) {
            return cu;
        }
        if ((cu = cu.withImports(this.orderImports.addImport(cu))).getClasses().size() > 0 && cu.getImports().isEmpty() || cu.getClasses().get(0).getFormatting().getPrefix().chars().takeWhile(c -> c == 10 || c == 13).count() < 2L) {
            ArrayList<J.ClassDecl> classes = new ArrayList<J.ClassDecl>(cu.getClasses());
            classes.set(0, (J.ClassDecl)((J.ClassDecl)classes.get(0)).withPrefix("\n\n"));
            cu = cu.withClasses(classes);
        }
        return cu;
    }

    @Override
    public J visitImport(J.Import impoort) {
        String importedType = impoort.getQualid().getSimpleName();
        if (this.staticMethod != null) {
            if (impoort.isFromType(this.type) && impoort.isStatic() && (importedType.equals(this.staticMethod) || importedType.equals("*"))) {
                this.coveredByExistingImport = true;
            }
        } else if (impoort.isFromType(this.type)) {
            this.coveredByExistingImport = true;
        } else if (importedType.equals("*") && impoort.getQualid().getTarget().printTrimmed().equals(this.classType.getPackageName())) {
            this.coveredByExistingImport = true;
        }
        return super.visitImport(impoort);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddImport)) {
            return false;
        }
        AddImport other = (AddImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$staticMethod = this.staticMethod;
        String other$staticMethod = other.staticMethod;
        if (this$staticMethod == null ? other$staticMethod != null : !this$staticMethod.equals(other$staticMethod)) {
            return false;
        }
        return this.onlyIfReferenced == other.onlyIfReferenced;
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddImport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $staticMethod = this.staticMethod;
        result = result * 59 + ($staticMethod == null ? 43 : $staticMethod.hashCode());
        result = result * 59 + (this.onlyIfReferenced ? 79 : 97);
        return result;
    }

    public class IntellijOrderImports
    extends OrderImports {
        private final int classCountToUseStarImport;
        private final int namesCountToUseStarImport;

        public IntellijOrderImports() {
            this(5, 3);
        }

        @Override
        public List<J.Import> addImport(J.CompilationUnit cu) {
            List<J.Import> importsThatCouldBeStarReplaced = this.importsThatCouldBeStarReplaced(cu);
            boolean starImporting = importsThatCouldBeStarReplaced.size() > (AddImport.this.staticMethod == null ? this.classCountToUseStarImport : this.namesCountToUseStarImport);
            ArrayList<J.Import> importsWithAdded = new ArrayList<J.Import>(cu.getImports());
            if (starImporting) {
                importsWithAdded.removeAll(importsThatCouldBeStarReplaced);
            }
            J.FieldAccess classImportField = (J.FieldAccess)TreeBuilder.buildName(AddImport.this.type, Formatting.format((String)" "));
            if (AddImport.this.staticMethod == null) {
                J.Import importStatementToAdd = new J.Import(Tree.randomId(), starImporting ? (J.FieldAccess)TreeBuilder.buildName(AddImport.this.classType.getPackageName() + ".*", Formatting.format((String)" ")) : classImportField, false, Formatting.format((String)"\n"));
                boolean added = false;
                for (int i = 0; i < importsWithAdded.size(); ++i) {
                    J.Import anImport = (J.Import)importsWithAdded.get(i);
                    if (!anImport.isStatic() && importStatementToAdd.compareTo(anImport) >= 0) continue;
                    importsWithAdded.add(i, importStatementToAdd);
                    added = true;
                    break;
                }
                if (!added) {
                    importsWithAdded.add(importStatementToAdd);
                }
                boolean encounteredJavaImport = false;
                for (int i = 0; i < importsWithAdded.size(); ++i) {
                    J.Import anImport = (J.Import)importsWithAdded.get(i);
                    if (i == 0) {
                        encounteredJavaImport = anImport.getPackageName().startsWith("java");
                        if (cu.getPackageDecl() == null) continue;
                    }
                    if (i == 0 || !encounteredJavaImport && (encounteredJavaImport = anImport.getPackageName().startsWith("java")) || anImport.isStatic()) {
                        importsWithAdded.set(i, (J.Import)anImport.withPrefix("\n\n"));
                        if (!anImport.isStatic()) continue;
                        break;
                    }
                    importsWithAdded.set(i, (J.Import)anImport.withPrefix("\n"));
                }
            } else {
                J.Import importStatementToAdd = new J.Import(Tree.randomId(), new J.FieldAccess(Tree.randomId(), classImportField, J.Ident.build(Tree.randomId(), starImporting ? "*" : AddImport.this.staticMethod, null, Formatting.EMPTY), null, Formatting.EMPTY), true, Formatting.format((String)"\n"));
                boolean added = false;
                for (int i = 0; i < importsWithAdded.size(); ++i) {
                    J.Import anImport = (J.Import)importsWithAdded.get(i);
                    if (!anImport.isStatic() || importStatementToAdd.compareTo(anImport) >= 0) continue;
                    importsWithAdded.add(i, importStatementToAdd);
                    added = true;
                    break;
                }
                if (!added) {
                    importsWithAdded.add(importStatementToAdd);
                }
                boolean encounteredStatic = false;
                for (int i = 0; i < importsWithAdded.size(); ++i) {
                    J.Import anImport = (J.Import)importsWithAdded.get(i);
                    if (!encounteredStatic && (encounteredStatic = anImport.isStatic())) {
                        importsWithAdded.set(i, (J.Import)anImport.withPrefix("\n\n"));
                        continue;
                    }
                    if (!anImport.isStatic()) continue;
                    importsWithAdded.set(i, (J.Import)anImport.withPrefix("\n"));
                }
            }
            return importsWithAdded;
        }

        public IntellijOrderImports(int classCountToUseStarImport, int namesCountToUseStarImport) {
            this.classCountToUseStarImport = classCountToUseStarImport;
            this.namesCountToUseStarImport = namesCountToUseStarImport;
        }
    }

    public abstract class OrderImports {
        public abstract List<J.Import> addImport(J.CompilationUnit var1);

        protected List<J.Import> importsThatCouldBeStarReplaced(J.CompilationUnit cu) {
            return AddImport.this.staticMethod == null ? cu.getImports().stream().filter(i -> !i.isStatic() && i.getPackageName().equals(AddImport.this.classType.getPackageName())).collect(Collectors.toList()) : cu.getImports().stream().filter(i -> {
                String fqn = i.getQualid().getTarget().printTrimmed();
                return i.isStatic() && fqn.substring(0, Math.max(0, fqn.lastIndexOf(46))).equals(AddImport.this.type);
            }).collect(Collectors.toList());
        }
    }
}

