/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class NewClassTest
implements RewriteTest {
    NewClassTest() {
    }

    @Test
    void anonymousInnerClass() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A { static class B {} }\nclass C {\n    A.B anonB = new A.B() {};\n}\n")});
    }

    @Test
    void concreteInnerClass() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A { static class B {} }\nclass C {\n    A.B anonB = new A.B();\n}\n")});
    }

    @Test
    void concreteClassWithParams() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.*;\nclass Test {\n    Object l = new ArrayList < String > ( 0 ) { };\n}\n")});
    }

    @Test
    void rawType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.*;\nclass Test {\n    List<String> l = new ArrayList < > ();\n}\n")});
    }

    @Test
    void anonymousClass() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.ArrayList;\nimport java.util.List;\n\nclass Test {\n    List<Integer> l = new ArrayList<Integer>() {\n        /** Javadoc */\n        @Override\n        public boolean isEmpty() {\n            return false;\n        }\n    };\n}\n")});
    }

    @Test
    void anonymousClassWithMultipleVariableDeclarations() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.File;\nimport java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.Comparator;\n\nclass Test {\n    void method() {\n        Arrays.sort(new ArrayList[]{new ArrayList<File>()}, new Comparator<Object>() {\n            long time1, time2;\n\n            @Override\n            public int compare(Object o1, Object o2) {\n                time1 = ((File) o1).lastModified();\n                time2 = ((File) o2).lastModified();\n                return time1 > time2 ? 1 : 0;\n            }\n        });\n    }\n}\n")});
    }
}

