/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Objects;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class EnumTest
implements RewriteTest {
    EnumTest() {
    }

    @Test
    void enumWithAnnotations() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum Test {\n    @Deprecated(since = \"now\")\n    One,\n\n    @Deprecated(since = \"now\")\n    Two;\n}\n")});
    }

    @Test
    void anonymousClassInitializer() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A {\n    A1(1) {\n        @Override\n        void foo() {}\n    };\n\n    A(int n) {}\n\n    abstract void foo();\n}\n")});
    }

    @Test
    void anonymousClassInitializerNoParentheses() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A {\n    A2 {\n        @Override\n        void foo() {}\n    };\n\n    abstract void foo();\n}\n")});
    }

    @Test
    void enumConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class Outer {\n    public enum A {\n        A1(1);\n\n        A(int n) {}\n    }\n\n    private static final class ContextFailedToStart {\n        private static Object[] combineArguments(String context, Throwable ex, Object[] arguments) {\n            return new Object[arguments.length + 2];\n        }\n    }\n}\n")});
    }

    @Test
    void noArguments() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A {\n    A1, A2();\n}\n")});
    }

    @Test
    void enumWithParameters() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A {\n    ONE(1),\n    TWO(2);\n\n    A(int n) {}\n}\n")});
    }

    @Test
    void enumWithoutParameters() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A { ONE, TWO }")});
    }

    @Test
    void enumUnnecessarilyTerminatedWithSemicolon() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A { ONE ; }")});
    }

    @Test
    void enumValuesTerminatedWithComma() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"enum A { ONE, }")});
    }

    @Test
    void enumWithEmptyParameters() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A { ONE ( ), TWO ( ) }")});
    }

    @Test
    void enumWithParametersAndTrailingComma() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A {\n    ONE(1),\n    TWO(2),\n    ;\n\n    A(int n) {}\n}\n")});
    }

    @Test
    void noValuesJustSemicolon() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A {\n    ;\n    public static final String X = \"receipt-id\";\n}\n", spec -> spec.afterRecipe(cu -> {
            J.EnumValueSet enumValueStatement = (J.EnumValueSet)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            assert (enumValueStatement.getEnums().isEmpty());
            assert (enumValueStatement.isTerminatedWithSemicolon());
        }))});
    }

    @Test
    void enumConstantTypeIsFlagged() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"enum Color {\n    RED,\n    BLUE;\n    public static final Color GREEN = RED;\n}\n\nclass Test {\n    Color run() {\n        return null;\n    }\n}\n", spec -> spec.afterRecipe(cu -> {
            J.MethodDeclaration md = (J.MethodDeclaration)((J.ClassDeclaration)cu.getClasses().get(1)).getBody().getStatements().get(0);
            JavaType.Class colorEnumType = (JavaType.Class)Objects.requireNonNull(md.getReturnTypeExpression()).getType();
            org.junit.jupiter.api.Assertions.assertEquals((Object)JavaType.FullyQualified.Kind.Enum, (Object)Objects.requireNonNull(colorEnumType).getKind());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)((JavaType.Variable)colorEnumType.getMembers().get(0)).hasFlags(new Flag[]{Flag.Enum}));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((JavaType.Variable)colorEnumType.getMembers().get(1)).hasFlags(new Flag[]{Flag.Enum}));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((JavaType.Variable)colorEnumType.getMembers().get(2)).hasFlags(new Flag[]{Flag.Enum}));
        }))});
    }

    @Test
    void enumClassHasJavaTypeClassEnumFlagEnabled() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"enum Color {}\n", spec -> spec.afterRecipe(cu -> org.junit.jupiter.api.Assertions.assertTrue((boolean)Objects.requireNonNull(((J.ClassDeclaration)cu.getClasses().get(0)).getType()).hasFlags(new Flag[]{Flag.Enum}))))});
    }
}

