/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class ForLoopTest
implements RewriteTest {
    ForLoopTest() {
    }

    @Test
    void forLoopMultipleInit() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        int i;\n        int j;\n        for(i = 0, j = 0;;) {\n        }\n    }\n  }\n")});
    }

    @Test
    void forLoop() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        for(int i = 0; i < 10; i++) {\n        }\n    }\n}\n")});
    }

    @Test
    void infiniteLoop() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        for(;;) {\n        }\n    }\n}\n")});
    }

    @Test
    void format() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        for ( int i = 0 ; i < 10 ; i++ ) {\n        }\n    }\n}\n")});
    }

    @Test
    void formatInfiniteLoop() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        for ( ; ; ) {}\n    }\n}\n")});
    }

    @Test
    void formatLoopNoInit() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test(int i) {\n        for ( ; i < 10 ; i++ ) {}\n    }\n}\n")});
    }

    @Test
    void formatLoopNoCondition() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        int i = 0;\n        for(; i < 10; i++) {}\n    }\n}\n")});
    }

    @Test
    void statementTerminatorForSingleLineForLoops() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        for(;;) test();\n    }\n}\n")});
    }

    @Test
    void initializerIsAnAssignment() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n\n        int[] a;\n        int i=0;\n        for(i=0; i<a.length; i++) {}\n    }\n}\n")});
    }

    @Test
    void multiVariableInitialization() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        for(int i, j = 0;;) {}\n    }\n}\n")});
    }
}

