/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.MinimumJava11;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;

class JavadocTest
implements RewriteTest {
    JavadocTest() {
    }

    @Test
    void javadocs() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.List;\n\n/**\n *   {@link List#add(Object) } refers to import\n * @param Something that spans\n * multiple lines.\n */\nclass Test {\n    /**   the position of the first body element or tag is relative to the index beginning after the last contiguous whitespace following '**' */\n    Integer n;\n\n    /**\n     * {@link int}\n     */\n    class Inner {\n        Integer n;\n\n        /**\n         * {@link #n} refers to Inner\n         */\n        void test() {\n        }\n    }\n}\n")});
    }

    @Test
    void singleLineJavadocText() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**   test */\nclass Test {}\n")});
    }

    @Test
    void javaDocWithMultipleLeadingAsterisks() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/** ** * First '*' characters are treated as a margin until a non '*' is parsed.\n ** * @throws IOException validate cursor position.\n */\nclass Test {\n}\n")});
    }

    @Test
    void allBlank() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**   */\nclass Test {\n}\n")});
    }

    @Test
    void allBlankMultiline() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n *\n *\n */\nclass Test {\n}\n")});
    }

    @Test
    void emptyJavadoc() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /***/\n    void empty() {}\n    /**\n     */\n    void onlyNewLine() {}\n}\n")});
    }

    @Test
    void author() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * @author name\n */\npublic class A {\n    void method() {}\n}\n")});
    }

    @Test
    void authorPostFixedNumber() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * @author FirstName LastName 42\n *\n */\npublic class A {\n    void method() {}\n}\n")});
    }

    @Test
    void code() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/** {@code int n = 1; } */\nclass Test {\n}\n")});
    }

    @Test
    void deprecated() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * @deprecated reason\n */\npublic class A {\n    void method() {}\n}\n")});
    }

    @Test
    void htmlComment() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/** <!-- comment --> */\nclass Test {\n}\n")});
    }

    @Test
    void docRoot() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * See the <a href=\"{@docRoot}/copyright.html\">Copyright</a>.\n */\nclass Test {\n}\n")});
    }

    @Test
    void doctype() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/** <!doctype text > test */\nclass Test {\n}\n")});
    }

    @Test
    void multilineAttribute() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * <a href=\"\n * https://...html\">\n * label</a>.\n */\nclass Test {\n}\n")});
    }

    @Test
    void selfClosingHTMLElement() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n *<p/>\n * text\n */\nclass Test {\n}\n")});
    }

    @Test
    void preserveWhitespaceBeforeHTMLElement() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * <p>\n * <p/>\n * text <br>\n * text <br/>\n */\nclass Test {\n}\n")});
    }

    @Test
    void whitespaceBeforeSelfClosingElement() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"package org.foo;\n\n/**\n * Type of an Opening Time.\n * <ul>\n * <li>DELIVERY (text a)</li>\n * <li>PICKUP (text b)</li> <br />\n * </ul>\n */\npublic enum OpenTimeType {\n    DELIVERY,\n    PICKUP\n}\n")});
    }

    @Test
    void multipleLineErroneous() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * @see this\n * or that\n */\nclass Test {\n}\n")});
    }

    @Test
    void erroneous() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/** {@version this is an erroneous tag } */\nclass Test {\n}\n")});
    }

    @Test
    void unknownTags() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * See the {@unknown}.\n * @unknown uh oh\n */\nclass Test {\n}\n")});
    }

    @Test
    void htmlEntity() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/** &amp; &amp ; &#12; */\nclass Test {\n}\n")});
    }

    @Test
    void exception() {
        this.rewriteRun(spec -> spec.typeValidationOptions(TypeValidation.builder().identifiers(false).build()), new SourceSpecs[]{Assertions.java((String)"public class A {\n    /**\n     * @exception ex\n     */\n    void method() {}\n}\n")});
    }

    @Test
    void hidden() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * @hidden value\n */\npublic class A {\n    void method() {}\n}\n")});
    }

    @Test
    void indexOnly() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * {@index}\n * {@index\n */\npublic class A {\n    void method() {}\n}\n")});
    }

    @Test
    void indexNoDescription() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * {@index term}\n * {@index term\n */\nclass Test {\n}\n")});
    }

    @Test
    void indexTermAndDescription() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * {@index term description}\n * {@index term description\n */\nclass Test {\n}\n")});
    }

    @Test
    void inheritDoc() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /**\n     * {@inheritDoc}\n     * @return {@inheritDoc}\n     */\n    void test() {\n    }\n}\n")});
    }

    @Test
    void noMarginJavadocFirstLineTrailingWhitespace() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n   {@link int}\n*/\nclass Test {}\n")});
    }

    @Test
    void leftMargin() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /**\n       {@link int}\n    */\n    String s;\n}\n")});
    }

    @Test
    void noMarginJavadoc() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n   {@link int}\n*/\nclass Test {}\n")});
    }

    @Test
    void singleLineJavadoc() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**   {@link int} */\nclass Test {}\n")});
    }

    @Test
    void whitespaceBeforeAndAfterDelimiter() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Map;\n\n/**\n * {@link Map< String , Integer > }\n */\nclass Test {\n}\n")});
    }

    @Test
    void fullyQualifiedLink() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * {@link java.util.List}\n */\npublic class A {\n    void method() {}\n}\n")});
    }

    @Test
    void fullyQualifiedParameterizedTypeLink() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * {@link java.util.List<String>}\n */\npublic class A {\n    void method() {}\n}\n")});
    }

    @Test
    void fullyQualifiedMethodLink() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * {@link java.util.List#add(Object) }\n */\nclass Test {\n}\n")});
    }

    @Test
    void fieldLink() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.nio.charset.StandardCharsets;\n\n/**\n *   {@link StandardCharsets#UTF_8 }\n *   {@linkplain StandardCharsets#UTF_8 }\n */\nclass Test {\n}\n")});
    }

    @Test
    void thisFieldLink() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n *   {@link #n }\n */\nclass Test {\n    int n;\n}\n")});
    }

    @Test
    void thisMethodLink() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n *   {@link #test() }\n */\nclass Test {\n    void test() {}\n}\n")});
    }

    @Test
    void primitiveLink() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * Line 1\n * Line 2\n * {@link int}\n * @param <T> t\n */\nclass Test<T> {}\n")});
    }

    @Test
    void multiParameterizedType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Map;\n\n/**\n * {@link Map<String, Map<String, Integer>>} multiple parameterized type\n */\nclass Test {\n}\n")});
    }

    @Test
    void parameterizedType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.List;\n\nclass Test {\n    /**\n     * @return - {@link List<String>} - description.\n     * @throws Exception - exception.\n     */\n    List<String> method() throws Exception {\n    }\n}\n")});
    }

    @Test
    void multipleReferenceParameters() {
        this.rewriteRun(spec -> spec.typeValidationOptions(TypeValidation.builder().identifiers(false).build()), new SourceSpecs[]{Assertions.java((String)"class Test {\n    /**\n     * {@link ListenerUtils#getExceptionFromHeader(ConsumerRecord, String, LogAccessor)}\n     */\n    void test() {\n    }\n}\n")});
    }

    @Test
    void blankLink() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * {@link}\n */\nclass Test {\n}\n")});
    }

    @Test
    void missingBracket() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * {@link missing.bracket\n */\nclass Test {\n}\n")});
    }

    @Test
    void methodReferenceNoParameters() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Test {\n    /**\n     * {@linkplain Thread#interrupt}\n     */\n    boolean test();\n}\n")});
    }

    @Test
    void multilineLink() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * {@link\n * multiline}.\n */\nclass Test {\n}\n")});
    }

    @Test
    void constructorLink() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /**\n     * {@link java.util.List()}\n     */\n    void test() {\n    }\n}\n")});
    }

    @Test
    void literal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    /**\n     * @literal\n     */\n    void method() {}\n}\n")});
    }

    @Test
    void nullLiteral() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Test {\n    /**\n     * {@literal null}.\n     */\n    boolean test();\n}\n")});
    }

    @Test
    void emptyParam() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    /**\n     * @param\n     */\n    void method(int val) {}\n}\n")});
    }

    @Test
    void param() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    /**\n     * @param val\n     */\n    void method(int val) {}\n}\n")});
    }

    @Test
    void singleLineParam() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**   @param <T> t */\nclass Test<T> {}\n")});
    }

    @Test
    void lineBreakInParam() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Test {\n    /**\n     * @param <\n     *   T> t hi\n     * @param\n     *   val\n     */\n    <T> boolean test(int val);\n}\n")});
    }

    @Test
    void paramWithMultilineHtmlAttributeNewLineBeforeEquals() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Test {\n    /**\n     * @param contentType <a href\n     *    = \"https://www...\"> label</a>\n     */\n    boolean test(int contentType);\n}\n")});
    }

    @Test
    void paramWithMultilineHtmlAttribute() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Test {\n    /**\n     * @param contentType <a href=\n     *                    \"https://www...\">\n     *                    label</a>\n     */\n    boolean test(int contentType);\n}\n")});
    }

    @Test
    void descriptionOnNewLine() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class Test {\n     /**\n      * @param name\n      *            a name\n      */\n    void test(String name) {\n    }\n}\n")});
    }

    @Test
    void provide() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    /**\n     * @provides int\n     */\n    void method(int val) {}\n}\n")});
    }

    @Test
    void returnTag() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    /**\n     * @return id\n     */\n    int method(int val) {}\n}\n")});
    }

    @Test
    void returnWithoutMargin() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class Test {\n    /** Text\n     @return No margin\n     */\n    public int test() {\n        return 0;\n    }\n}\n")});
    }

    @Test
    void see() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * @see \"Create link via quotes\"\n * @see java.lang.Comparable#compareTo(Object) label\n * @see <a href=\"https://link.here\">label</a>\n */\npublic class A {\n    void method() {}\n}\n")});
    }

    @Test
    void methodFound() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Test {\n    /**\n     * @see java.io.ByteArrayOutputStream#toString(String)\n     */\n    boolean test();\n}\n")});
    }

    @Test
    void methodNotFound() {
        this.rewriteRun(spec -> spec.typeValidationOptions(TypeValidation.builder().methodInvocations(false).build()), new SourceSpecs[]{Assertions.java((String)"interface Test {\n    /**\n     * @see Math#cosine(double)\n     */\n    boolean test();\n}\n")});
    }

    @Test
    void typeNotFound() {
        this.rewriteRun(spec -> spec.typeValidationOptions(TypeValidation.builder().identifiers(false).build()), new SourceSpecs[]{Assertions.java((String)"interface Test {\n    /**\n     * {@link SymbolThatCannotBeFound}\n     * @see Mathy#cos(double)\n     */\n    boolean test();\n}\n")});
    }

    @Test
    void seeWithMultilineAttribute() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Test {\n    /**\n     * @see <a href=\"https://www...\">\n     *            label</a>\n     */\n    boolean test();\n}\n")});
    }

    @Test
    void serial() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * @serial\n */\npublic class A {\n    void method() {}\n}\n")});
    }

    @Test
    void serialData() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * @serialData\n */\npublic class A {\n    void method() {}\n}\n")});
    }

    @Test
    void since() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/** @since 1.0 */\nclass Test {\n}\n")});
    }

    @Test
    void summary() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/** {@summary test description } */\nclass Test {\n}\n")});
    }

    @Test
    void uses() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/** @uses Test for something */\nclass Test {\n    /** @uses Test for something */\n    void method() {}\n}\n")});
    }

    @Test
    void throwsException() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /**\n     * @throws Exception\n     */\n    <T> T test(String t) throws Exception {\n        return null;\n    }\n}\n")});
    }

    @Test
    void value() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /**\n     * The value of this constant is {@value}.\n     */\n    public static final String SCRIPT_START = \"<script>\";\n\n    /**\n     * {@value Test#SCRIPT_START}\n     */\n    void test() {\n    }\n}\n")});
    }

    @Test
    void version() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * @version 1.0.0\n */\npublic class A {\n    void method() {}\n}\n")});
    }

    @Test
    void starMarginWithFirstLineLeadingSpace() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n  *       Line 1\n  */\nclass Test<T> {}\n")});
    }

    @Test
    void javaDocEndsOnSameLine() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /**\n     * Javadoc\n     *\n     * **/\n    void method() {}\n}\n")});
    }

    @Test
    void trailingWhitespaceWithWhitespaceOnEmptyLine() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /**\n     * Text with trailing whitespace.\n     *\n     * @param arg desc\n     */\n    void method(String arg) {\n    }\n}\n")});
    }

    @Test
    void trailingWhitespaceAfterText() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /**\n     * Text with trailing whitespace.\n     * More trailing whitespace\n     */\n    void method() {\n    }\n}\n")});
    }

    @Test
    void trailingWhitespaceAfterAnnotation() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /**\n     * @param arg test text.\n     * More trailing whitespace\n     */\n    void method(String arg) {\n    }\n}\n")});
    }

    @Test
    void commentMissingMultipleAsterisks() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /**\n     * JavaDoc\n        1st new line.\n        2nd new line.\n     * text\n     */\n    void test() {\n    }\n}\n")});
    }

    @Test
    void textWithBlankNewLines() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /**\n    * JavaDocs treats whitespace differently when new lines exist\n\n\n    * with whitespace that is contained in pure text.\n    */\n    void method() {}\n}\n")});
    }

    @Test
    void tagAfterBlankNewLines() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /**\n     * New lines with whitespace followed by a param.\n\n\n     * @return void\n     */\n    void method() {\n    }\n}\n")});
    }

    @Test
    void consecutiveLineBreaksWithNoMargin() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /**\n     * @param oboFile the file to be parsed\n\n     * @return the ontology represented as a BioJava ontology file\n     */\n    void test() {\n    }\n}\n")});
    }

    @Test
    void whitespaceBeforeNonLeadingText() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Test {\n    /**\n     * @return <code>true</code>\n     * <code>false</code> non-leading text.\n     */\n    boolean test();\n}\n")});
    }

    @Test
    void multipleLinesBeforeTag() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * Note\n *\n * @see CoreJackson2Module\n */\npublic class Test {\n}\n")});
    }

    @Test
    void whitespaceOnBlankLineBetweenBodyAndTags() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Test {\n    /**\n     * Returns something.\n     *\n     * @return true\n     */\n    boolean test();\n}\n")});
    }

    @Test
    void trailingWhitespaceAndMultilineMargin() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Test {\n    /**\n     * Text followed by whitespace, and multiple new lines with/without whitespace.\n     *\n     *\n     */\n    void method();\n}\n")});
    }

    @Test
    void seeWithMultilineMethodInvocation() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.Math;\n\ninterface Test {\n    /**\n     * @see Math#pow(\n     *\n     *    double\n     *\n     *\n     *    ,\n     * double\n     *\n     * )\n     */\n    boolean test();\n}\n")});
    }

    @Test
    void javaDocWithCRLF() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\r\n * JavaDoc.\r\n */\r\npublic class A {\r\n}")});
    }

    @Test
    void noMarginWithCRLF() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\r\n * Line 1.\r\n   Text with no margin.\r\n */\r\npublic class A {\r\n}")});
    }

    @Test
    void emptyLinesWithCRLF() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\r\n  /** Text \r\n         \r\n         \r\n     @param arg0 desc\r\n   */\r\n  void method(int arg0) {}\r\n}")});
    }

    @Test
    void multilineJavaDocWithCRLF() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\r\n * Line 1.\r\n * Line 2.\r\n */\r\npublic class A {\r\n    /**\r\n     * Line 1.\r\n     * Line 2.\r\n     */\r\n    void method() {}\r\n}")});
    }

    @Test
    void multilineWithThrowsAndCRLF() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.IOException;\r\n\r\npublic class A {\r\n    /**\r\n     * Line 1.\r\n     * Line 2.\r\n     * @throws IOException text.\r\n     */\r\n    void method() throws IOException {}\r\n}")});
    }

    @Test
    void paramNoDescriptionWithCRLF() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import org.foo;\r\n\r\npublic class A {\r\n    /**\r\n     * @param arg0\r\n     */\r\n    void method(String arg0) {}\r\n}")});
    }

    @Test
    void trailingWhitespaceWithLF() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * Text followed by trailing whitespace with CRLF.\n * \n */\nclass A {}")});
    }

    @Test
    void arrayTypeLiterals() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n  * Create an instance of {@link byte[]} and {@link byte[][]}\n  */\nclass A {}")});
    }

    @Test
    @MinimumJava11
    void arrayTypeLiterals2() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * <p>Values are converted to strings using {@link java.util.Arrays#compare(Comparable[], Comparable[])}}.\n */\nclass A {}")});
    }

    @Test
    void varargsMethod() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A {\n    /**\n     * A dummy main method. This method is not actually called, but we'll use its Javadoc comment to test that\n     * OpenRewrite can handle references like the following: {@link A#varargsMethod(String...)}.\n     *\n     * @param args The arguments to the method.\n     */\n    public static void main(String[] args) {\n        System.out.println(\"Hello, world! This is my original class' main method.\");\n    }\n    public static void varargsMethod(String... args) {\n        System.out.println(\"Hello, world! This is my original class' varargs method.\");\n    }\n}\n")});
    }

    @Test
    void varargsWithPrefix() {
        this.rewriteRun(spec -> spec.typeValidationOptions(TypeValidation.none()), new SourceSpecs[]{Assertions.java((String)"class A {\n    /**\n     * A dummy main method. This method is not actually called, but we'll use its Javadoc comment to test that\n     * OpenRewrite can handle references like the following: {@link A#varargsMethod( Object, String...)} }.\n     *\n     * @param args The arguments to the method.\n     */\n    public static void main(String[] args) {\n        System.out.println(\"Hello, world! This is my original class' main method.\");\n    }\n    public static void varargsMethod(Object o, String... args) {\n        System.out.println(\"Hello, world! This is my original class' varargs method.\");\n    }\n}\n")});
    }

    @Test
    void arrayMethod() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A {\n    /**\n     * A dummy main method. This method is not actually called, but we'll use its Javadoc comment to test that\n     * OpenRewrite can handle references like the following: {@link A#main(String[])}.\n     *\n     * @param args The arguments to the method.\n     */\n    public static void main(String[] args) {\n        System.out.println(\"Hello, world! This is my original class' main method.\");\n    }\n}\n")});
    }

    @Test
    void emptyAttributes() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * DEFINE TENANCY TenantB AS <TenantB OCID>\n * ENDORSE GROUP <TenantA user group name> TO {OBJECTSTORAGE_NAMESPACE_READ} IN TENANCY TenantB\n * DEFINE TENANCY TenantA AS <TenantA OCID>\n * DEFINE GROUP TenantAGroup AS <TenantA user group OCID>\n * ADMIT GROUP TenantAGroup OF TENANCY TenantA TO {OBJECTSTORAGE_NAMESPACE_READ} IN TENANCY\n */\nclass Test {}\n")});
    }

    @Test
    void trailingTab() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"/**\n * See <a href=\"\">here</a>\t\n */\nclass Test {\n}\n")});
    }

    @Test
    void returnOpeningAndClosingBrace() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Test {\n\t/**\n\t * {@return 42}\n\t */\n\tint foo();\n}\n")});
    }

    @Test
    void returnOpeningBraceOnly() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Test {\n\t/**\n\t * {@return 42\n\t */\n\tint foo();\n}\n")});
    }

    @Disabled
    @Test
    void unicodeEscape() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Test {\n\t/**\n\t * Return the {@code \\u0000} codepoint.\n\t */\n\tint foo();\n}\n")});
    }
}

