/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class MemberReferenceTest
implements RewriteTest {
    MemberReferenceTest() {
    }

    @Test
    void unknownDeclaringType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"package com.company.pkg;\n\nimport java.util.concurrent.CompletableFuture;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\nimport com.company.pkg.UnknownClass;\n\npublic class ReproduceParserIssue {\n\n  public static void main(String[] args) {\n    CompletableFuture.supplyAsync(\n        () -> {\n          return Stream.empty()\n              .map(UnknownClass::valueOf)\n              .collect(Collectors.toList());\n        });\n  }\n}\n")});
    }

    @Test
    void memberReferenceWithTypeParameter() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.List;\nimport java.util.Map;\nimport java.util.Set;\nimport java.util.function.Function;\nimport java.util.stream.Collector;\nimport java.util.stream.Collectors;\n\npublic class Sample {\n\n    private void foo(List<Criteria> request) {\n        Set<Id<Criteria>> allCriteria = request.stream()\n                .map(Id::<Criteria>of)\n                .collect(Collectors.toSet());\n        allCriteria = request.stream()\n                .map(Id/**yo**/::/**hola**/<Criteria>/**hello**/of)\n                .collect(Collectors.toSet());\n\n        List<String> result = allCriteria.stream()\n                .map(Sample::idToString)\n                .collect(Collectors.toList());\n    }\n\n    public static <T, K, V> Collector<T, ?, Map<K, V>> toImmutableMap(\n            Function<? super T, ? extends K> keyFunction,\n            Function<? super T, ? extends V> valueFunction) {\n        return null;\n    }\n    private static String idToString(Id id) {\n        return id.toString();\n    }\n    private class Id<T> {\n        static <Y> Id<Y> of(Y thing) {\n            return null;\n        }\n    }\n\n    private class Criteria {\n        Long getId() {\n            return null;\n        }\n    }\n}\n")});
    }

    @Test
    void staticFunctionReference() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.stream.Stream;\n\npublic class StaticLambdaRef {\n    void test() {\n        Stream.of(\"s\").forEach(A :: func);\n    }\n}\n\nclass A {\n    static void func(String s) {}\n}\n")});
    }

    @Test
    void constructorMethodReference() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"              import java.util.HashSet;\nimport java.util.Set;\nimport java.util.stream.Stream;\n              class Test {\n                  Stream<Integer> n = Stream.of(1, 2);\n                  Set<Integer> n2 = n.collect(HashSet < Integer > :: new, HashSet :: add);\n              }\n")});
    }
}

