/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.List;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

class AnnotationTest
implements RewriteTest {
    AnnotationTest() {
    }

    @Test
    void annotationWithDefaultArgument() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"@SuppressWarnings(\"ALL\")\npublic class A {}\n")});
    }

    @Test
    void annotationWithArgument() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"@SuppressWarnings(value = \"ALL\")\npublic class A {}\n")});
    }

    @Test
    void preserveOptionalEmptyParentheses() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"@Deprecated ( )\npublic class A {}\n")});
    }

    @Test
    void newArrayArgument() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\n\n@Target({ FIELD, PARAMETER })\npublic @interface Annotation {}\n")});
    }

    @Test
    void annotationsInManyLocations() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.*;\n@Ho\npublic @Ho final @Ho class Test {\n    @Ho private @Ho transient @Ho String s;\n    @Ho\n    public @Ho final @Ho <T> @Ho T merryChristmas() {\n        return null;\n    }\n    @Ho\n    public @Ho Test() {\n    }\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@interface Hos {\n    Ho[] value();\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@Repeatable(Hos.class)\n@interface Ho {\n}\n")});
    }

    @Test
    void multipleAnnotations() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.*;\n@B\n@C\npublic class A {\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@interface B {\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@interface C {\n}\n")});
    }

    @Test
    void typeParameterAnnotations() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.List;\nimport java.lang.annotation.*;\nclass TypeAnnotationTest {\n    List<@A ? extends @A String> list;\n\n    @Target({ ElementType.FIELD, ElementType.TYPE_USE, ElementType.TYPE_PARAMETER })\n    private @interface A {\n    }\n}\n")});
    }

    @Test
    void annotationsWithComments() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.*;\n@Yo\n// doc\n@Ho\npublic @Yo /* grumpy */ @Ho final @Yo\n// happy\n@Ho class Test {\n    @Yo /* sleepy */ @Ho private @Yo /* bashful */ @Ho transient @Yo /* sneezy */ @Ho String s;\n    @Yo /* dopey */ @Ho\n    public @Yo /* evil queen */ @Ho final @Yo /* mirror */ @Ho <T> @Yo /* apple */ @Ho T itsOffToWorkWeGo() {\n        return null;\n    }\n    @Yo /* snow white */ @Ho\n    public @Yo /* prince */ @Ho Test() {\n    }\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@interface Hos {\n    Ho[] value();\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@Repeatable(Hos.class)\n@interface Ho {\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@interface Yos {\n    Yo[] value();\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@Repeatable(Yos.class)\n@interface Yo {\n}\n")});
    }

    @Disabled
    @Test
    void annotationsInFullyQualified() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"package annotation.fun;\nimport java.lang.annotation.*;\n\n@Target({ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD, ElementType.TYPE_USE})\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface Nullable {\n}\n", SourceSpec::skip), Assertions.java((String)"import annotation.fun.Nullable;\npublic class AnnotationFun {\n    public void justBecauseYouCanDoesntMeanYouShould(java.util.@Nullable List myList) {\n    }\n}\n")});
    }

    @Test
    void annotationOnConstructorName() {
        this.rewriteRun(spec -> spec.recipe((Recipe)RewriteTest.toRecipe(() -> new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext p) {
                if (annotation.getSimpleName().equals("A")) {
                    return null;
                }
                return super.visitAnnotation(annotation, (Object)p);
            }
        })), new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.*;\npublic class TypeAnnotationTest {\n\n    public @Deprecated @A TypeAnnotationTests() {\n    }\n\n    @Target({ ElementType.TYPE, ElementType.TYPE_USE, ElementType.TYPE_PARAMETER })\n    private @interface A {\n    }\n}\n", (String)"import java.lang.annotation.*;\npublic class TypeAnnotationTest {\n\n    public @Deprecated TypeAnnotationTests() {\n    }\n\n    @Target({ ElementType.TYPE, ElementType.TYPE_USE, ElementType.TYPE_PARAMETER })\n    private @interface A {\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Object o) {
                org.assertj.core.api.Assertions.assertThat((List)method.getAllAnnotations()).hasSize(1);
                org.assertj.core.api.Assertions.assertThat((String)((J.Annotation)method.getAllAnnotations().get(0)).getSimpleName()).isEqualTo("Deprecated");
                return method;
            }
        }.visit((Tree)cu, (Object)0)))});
    }
}

